/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import java.util.List;

public class SQLIdentifier
extends SQLExpression {
    public static final String NAME_SEPARATOR = ".";
    public static final String PROP_OBJECT_IDENTIFIER_CHAIN = "identifierChain";
    public static final String PROP_STRING_CATALOG = "catalog";
    public static final String PROP_STRING_DATABASE = "database";
    public static final String PROP_STRING_MODEL_DATASOURCE = "modelDatasource";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_SCHEMA = "schema";
    public static final String PROP_STRING_TABLE = "table";
    public static final String PROP_CONNECTION_STRING = "connectionString";
    public static final String PROP_STRING_RAW_CATALOG = "rawCatalog";
    public static final String PROP_STRING_RAW_CM_DATABASE_NAME = "rawCmDatabaseName";
    public static final String PROP_STRING_RAW_SCHEMA = "rawSchema";
    public static final String SINGLE_QUOTE = "'";
    public static final String A_SPACE = " ";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLIdentifier.create(p, jjtid, 301067);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301067;
    }

    public void setModelDatasourceName(String name) {
        this.setPropertyValue(PROP_STRING_MODEL_DATASOURCE, name);
    }

    public String getModelDatasourceName() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL_DATASOURCE);
    }

    public void setDatabaseName(String database) {
        this.setPropertyValue(PROP_STRING_DATABASE, database);
    }

    public String getDatabaseName() {
        return (String)this.getPropertyValue(PROP_STRING_DATABASE);
    }

    public void setRawCmDatabaseName(String database) {
        this.setPropertyValue(PROP_STRING_RAW_CM_DATABASE_NAME, database);
    }

    public String getRawCmDatabaseName() {
        String dbName = (String)this.getPropertyValue(PROP_STRING_RAW_CM_DATABASE_NAME);
        if (dbName != null) {
            return dbName;
        }
        return this.getDatabaseName();
    }

    public void setCatalogName(String catalog) {
        this.setPropertyValue(PROP_STRING_CATALOG, catalog);
    }

    public String getCatalogName() {
        return (String)this.getPropertyValue(PROP_STRING_CATALOG);
    }

    public void setRawCatalogName(String catalog) {
        this.setPropertyValue(PROP_STRING_RAW_CATALOG, catalog);
    }

    public String getRawCatalogName() {
        String cat = (String)this.getPropertyValue(PROP_STRING_RAW_CATALOG);
        if (cat != null) {
            return cat;
        }
        return this.getCatalogName();
    }

    public void setSchemaName(String schema) {
        this.setPropertyValue(PROP_STRING_SCHEMA, schema);
    }

    public String getSchemaName() {
        return (String)this.getPropertyValue(PROP_STRING_SCHEMA);
    }

    public void setRawSchemaName(String schema) {
        this.setPropertyValue(PROP_STRING_RAW_SCHEMA, schema);
    }

    public String getRawSchemaName() {
        String schema = (String)this.getPropertyValue(PROP_STRING_RAW_SCHEMA);
        if (schema != null) {
            return schema;
        }
        return this.getSchemaName();
    }

    public void setTableName(String table) {
        this.setPropertyValue(PROP_STRING_TABLE, table);
    }

    public String getTableName() {
        return (String)this.getPropertyValue(PROP_STRING_TABLE);
    }

    public void setName(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    public String getName() {
        String[] nameParts;
        String name = (String)this.getPropertyValue(PROP_STRING_NAME);
        if (name == null && (nameParts = this.getIdentifierChain()) != null && nameParts.length > 0) {
            name = nameParts[nameParts.length - 1];
        }
        return name;
    }

    public void setConnectionString(String connectionString) {
        this.setPropertyValue(PROP_CONNECTION_STRING, connectionString);
    }

    public String getConnectionString() {
        return (String)this.getPropertyValue(PROP_CONNECTION_STRING);
    }

    public String getQualifiedName() {
        String dbName = this.getDatabaseName();
        String catalog = this.getCatalogName();
        String schema = this.getSchemaName();
        String table = this.getTableName();
        StringBuilder qName = new StringBuilder();
        if (dbName != null) {
            qName.append(dbName);
            qName.append(NAME_SEPARATOR);
        }
        if (catalog != null) {
            qName.append(catalog);
            qName.append(NAME_SEPARATOR);
        }
        if (schema != null) {
            qName.append(schema);
            qName.append(NAME_SEPARATOR);
        }
        if (table != null) {
            qName.append(table);
            qName.append(NAME_SEPARATOR);
        }
        qName.append(this.getName());
        return qName.toString();
    }

    public String[] getIdentifierChain() {
        return (String[])this.getPropertyValue(PROP_OBJECT_IDENTIFIER_CHAIN);
    }

    public void setIdentifierChain(String[] nameParts) {
        this.setPropertyValue(PROP_OBJECT_IDENTIFIER_CHAIN, nameParts);
    }

    public void setIdentifierChain(List<String> nameParts) {
        this.setPropertyValue(PROP_OBJECT_IDENTIFIER_CHAIN, nameParts.toArray(new String[nameParts.size()]));
    }

    public static void delimitName(StringBuilder buffer, String name, String delimiter, boolean forPlanning) {
        if (forPlanning && name.contains(A_SPACE) && (delimiter == null || delimiter.length() == 0)) {
            delimiter = "\"";
        }
        if (delimiter != null && delimiter.length() != 0) {
            buffer.append(delimiter);
            if (name.contains(delimiter)) {
                String[] tokens = name.split(delimiter);
                for (int idx = 0; idx < tokens.length; ++idx) {
                    buffer.append(tokens[idx]);
                    if (idx >= tokens.length - 1) continue;
                    buffer.append(delimiter);
                    buffer.append(delimiter);
                }
            } else {
                buffer.append(name);
            }
            buffer.append(delimiter);
        } else {
            buffer.append(name);
        }
    }

    public static String escapeSingleQuotes(String name) {
        if (name.contains(SINGLE_QUOTE)) {
            StringBuilder buffer = new StringBuilder();
            String[] tokens = name.split(SINGLE_QUOTE);
            for (int idx = 0; idx < tokens.length; ++idx) {
                buffer.append(tokens[idx]);
                buffer.append(SINGLE_QUOTE);
                buffer.append(SINGLE_QUOTE);
            }
            return buffer.toString();
        }
        return name;
    }

    public void dropQualifiers() {
        this.removeProperty(PROP_STRING_DATABASE);
        this.removeProperty(PROP_STRING_CATALOG);
        this.removeProperty(PROP_STRING_SCHEMA);
        this.removeProperty(PROP_STRING_TABLE);
    }

    public void setQualifiers(SQLIdentifier node) {
        this.setDatabaseName(node.getDatabaseName());
        this.setCatalogName(node.getCatalogName());
        this.setSchemaName(node.getSchemaName());
        this.setTableName(node.getTableName());
    }

    @Override
    public IDataType getDataType() {
        return StringType.DEFAULTSTRINGTYPE;
    }

    @Override
    public boolean isConstantValue() {
        return false;
    }

    public boolean containsExpandedMacros() {
        return this.getPropertyValue(PROP_STRING_RAW_CM_DATABASE_NAME) != null || this.getPropertyValue(PROP_STRING_RAW_CATALOG) != null || this.getPropertyValue(PROP_STRING_RAW_SCHEMA) != null;
    }
}

