/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLDataFlowNode;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLJoin
extends SQLDataFlowNode {
    public static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_ENUM_SUBTYPE = "subType";
    public static final String PROP_ENUM_HINT = "hint";
    public static final int NUMBER_OF_DATAFLOW_ARGUMENTS = 2;
    public static final String PROP_BOOL_INVOLVES_MDX_QUERY = "involvesMdxQuery";
    public static final String PROP_BOOL_CREATED_FOR_JOIN_OP = "createdForJoinOperation";
    public static final String PROP_LEFT_CARDINALITY = "leftCardinality";
    public static final String PROP_RIGHT_CARDINALITY = "rightCardinality";
    public static final int SQL_JOIN_AND_PREDICATE = 1;
    public static final int SQL_JOIN_OR_PREDICATE = 2;
    public static final int SQL_JOIN_NOT_PREDICATE = 3;
    public static final int SQL_JOIN_NON_EQUIJOINS = 4;
    public static final int SQL_JOIN_EQUIJOINS = 5;
    public static final int SQL_JOIN_BETWEEN_PREDICATE = 11;
    public static final int SQL_JOIN_DISTINCTFROM_PREDICATE = 12;
    public static final int SQL_JOIN_IN_PREDICATE = 13;
    public static final int SQL_JOIN_ISNULL_PREDICATE = 14;
    public static final int SQL_JOIN_LIKE_PREDICATE = 15;
    public static final int SQL_JOIN_NON_JOIN_EXPR = 21;
    public static final int SQL_JOIN_NON_JOIN_NON_EQUI_EXPR = 22;
    public static final int SQL_JOIN_FUNCTION = 23;

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLJoin.create(p, jjtid, 301011);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301011;
    }

    public void setJoinType(SubType joinType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)joinType);
    }

    public SubType getJoinType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public String getJoinTypeName() {
        SubType joinSubType = (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
        return joinSubType.joinName;
    }

    public void setHint(Hint joinHint) {
        this.setPropertyValue(PROP_ENUM_HINT, (Object)joinHint);
    }

    public Hint getHint() {
        Hint hint = (Hint)((Object)this.getPropertyValue(PROP_ENUM_HINT));
        if (hint == null) {
            hint = Hint.DEFAULT;
        }
        return hint;
    }

    public IXQEQueryNode getPredicate() {
        if (this.getJoinType() == SubType.CROSS) {
            return null;
        }
        if (this.getNumberChildren() != 3) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "getNumberChildren() != (NUMBER_OF_DATAFLOW_ARGUMENTS + 1)");
        }
        return this.getChild(2);
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        SQLQueryItemList queryItems;
        SQLQueryItemList result = new SQLQueryItemList();
        for (int i = 0; i < 2 && (queryItems = ((SQLQueryNode)this.getChild(i)).getQueryItemList()) != null; ++i) {
            SubType jType = this.getJoinType();
            for (int j = 0; j < queryItems.size(); ++j) {
                SQLQueryItem queryItem = (SQLQueryItem)queryItems.get(j);
                queryItem.setSourceNo(i);
                if (jType != SubType.FULL_OUTER && (jType != SubType.LEFT_OUTER || i != 1) && (jType != SubType.RIGHT_OUTER || i != 0)) continue;
                queryItem.setNullable(true);
            }
            result.addAll(queryItems);
        }
        return result;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        IXQEQueryNode predicate;
        String rightNestedPattern;
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result && this.getParent().getType() == 301011 && this.getParent().getChild(1) == this && ((rightNestedPattern = dataSource.getCapabilities().getStringValue("joins.RightNested", null)) == null || rightNestedPattern.length() == 0)) {
            result = false;
            SQLJoin.addUnsupportedReason(ul, "right nested join not supported", this);
        }
        if (result) {
            boolean bl = result = this.getHint() != Hint.STITCH || dataSource.getCapabilities().getBooleanValue("supports.stitchJoins");
        }
        if (result && (predicate = this.getPredicate()) != null && predicate instanceof SQLAbstractFunction) {
            if (!dataSource.getCapabilities().getBooleanValue("supports.join.subqueriesInOnClause") && predicate.getDescendantsOfType(301059, false).length > 0) {
                SQLJoin.addUnsupportedReason(ul, "subquery in ON clause", this);
                return false;
            }
            BitMask mask = new BitMask();
            ((SQLAbstractFunction)predicate).analyzeJoinCondition(mask);
            if (this.getJoinType() == SubType.FULL_OUTER) {
                if (!dataSource.getCapabilities().getBooleanValue("supports.join.full.distinctJoins") && mask.get(12)) {
                    SQLJoin.addUnsupportedReason(ul, "Unsupported Distinct From in ON clause", this);
                    return false;
                }
                if (!dataSource.getCapabilities().getBooleanValue("supports.join.full.thetaJoins") & mask.get(4)) {
                    SQLJoin.addUnsupportedReason(ul, "Unsupported full outer non equi join", this);
                    return false;
                }
            } else if (this.getJoinType().isOuterJoin() && !dataSource.getCapabilities().getBooleanValue("supports.join.outer.thetaJoins") && mask.get(4)) {
                SQLJoin.addUnsupportedReason(ul, "Unsupported outer non equi join", this);
                return false;
            }
            if (!dataSource.getCapabilities().getBooleanValue("supports.join.orInOnClause") && mask.get(2)) {
                SQLJoin.addUnsupportedReason(ul, "Unsupported OR clause in ON clause", this);
                return false;
            }
            if (!dataSource.getCapabilities().getBooleanValue("supports.join.notInOnClause") && mask.get(3)) {
                SQLJoin.addUnsupportedReason(ul, "Unsupported NOT predicate in ON clause", this);
                return false;
            }
            if (!dataSource.getCapabilities().getBooleanValue("supports.join.betweenInOnClause") && mask.get(11)) {
                SQLJoin.addUnsupportedReason(ul, "Unsupported BETWEEN predicate in ON clause", this);
                return false;
            }
            if (!dataSource.getCapabilities().getBooleanValue("supports.join.likeInOnClause") && mask.get(15)) {
                SQLJoin.addUnsupportedReason(ul, "Unsupported LIKE predicate in ON clause", this);
                return false;
            }
            if (!dataSource.getCapabilities().getBooleanValue("supports.join.inPredicateInOnClause") && mask.get(13)) {
                SQLJoin.addUnsupportedReason(ul, "Unsupported IN predicate in ON clause", this);
                return false;
            }
            if (!dataSource.getCapabilities().getBooleanValue("supports.join.isNullInOnClause") && mask.get(14)) {
                SQLJoin.addUnsupportedReason(ul, "Unsupported ISNULL predicate in ON clause", this);
                return false;
            }
            if (!(!dataSource.getCapabilities().getBooleanValue("supports.join.onlyEquiWithAnd") || !mask.get(1) || mask.cardinality() == 2 && mask.get(5) || mask.cardinality() == 3 && mask.get(5) && mask.get(21))) {
                SQLJoin.addUnsupportedReason(ul, "Only support Equal Comparison with AND operator.", this);
                return false;
            }
        }
        return result;
    }

    public static boolean isFeatureSupported(SQLJoin node, IDataSourceCapabilities capabilities) {
        String value = capabilities.getStringValue(node.getKey(), null);
        return value != null && value.length() != 0;
    }

    public int getJoinLevel() {
        int nestedLevel = 0;
        for (SQLQueryNode node = (SQLQueryNode)this.getChild(0); node != null && node.getType() == 301011; node = (SQLQueryNode)node.getChild(0)) {
            ++nestedLevel;
        }
        return nestedLevel;
    }

    @Override
    protected String getKey() {
        return "joins." + this.getJoinType().key();
    }

    @Override
    public String[] getSyntaxProperties() {
        String[] syntaxProperties = new String[]{PROP_ENUM_SUBTYPE};
        return syntaxProperties;
    }

    @Override
    public int getNumberColumns() {
        return ((SQLQueryNode)this.getChild(0)).getNumberColumns() + ((SQLQueryNode)this.getChild(1)).getNumberColumns();
    }

    @Override
    public int getNumberOfLeafNodes() {
        int nLeafNodes = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.getChild(i).getType() == 301011) {
                nLeafNodes += ((SQLJoin)this.getChild(i)).getNumberOfLeafNodes();
                continue;
            }
            ++nLeafNodes;
        }
        return nLeafNodes;
    }

    @Override
    public IXQEQueryNode getLeafNodeForPredicatePushdown(IXQEQueryNode predicate) {
        List<IXQEQueryNode> leafNodes = SQLPreoptimizerUtil.getLeafNodes(this);
        SQLQueryNode leafNode = null;
        SQLFid fid = (SQLFid)predicate.getFirstDescendantOfTypeOrdered(301032, false);
        int nColumns = 0;
        for (int i = 0; i < leafNodes.size(); ++i) {
            SQLQueryNode child = (SQLQueryNode)leafNodes.get(i);
            if (fid.getVirtualColumnNo() >= (nColumns += child.getNumberColumns())) continue;
            leafNode = child;
            break;
        }
        if (!SQLJoin.canPushPredicateThroughJoin(this.getParent(), leafNode)) {
            leafNode = null;
        }
        return leafNode;
    }

    public static boolean canPushPredicateThroughJoin(IXQEQueryNode root, IXQEQueryNode leafNode) {
        IXQEQueryNode child = leafNode;
        for (IXQEQueryNode parent = leafNode.getParent(); parent != root; parent = parent.getParent()) {
            SQLJoin jNode = (SQLJoin)parent;
            if (jNode.getJoinType() == SubType.FULL_OUTER || jNode.getJoinType() == SubType.LEFT_OUTER && jNode.getChild(1) == child || jNode.getJoinType() == SubType.RIGHT_OUTER && jNode.getChild(0) == child) {
                return false;
            }
            child = parent;
        }
        return true;
    }

    public boolean isInnerJoin() {
        boolean status = !(this.getJoinType() != SubType.INNER || this.getChild(0).getType() == 301011 && !((SQLJoin)this.getChild(0)).isInnerJoin() || this.getChild(1).getType() == 301011 && !((SQLJoin)this.getChild(1)).isInnerJoin());
        return status;
    }

    public void setLeftCardinality(Enum<IRelationship.Cardinality> leftCardinality) {
        this.getChild(0).setPropertyValue(PROP_LEFT_CARDINALITY, leftCardinality);
    }

    public void setRightCardinality(Enum<IRelationship.Cardinality> rightCardinality) {
        this.getChild(1).setPropertyValue(PROP_RIGHT_CARDINALITY, rightCardinality);
    }

    public IRelationship.Cardinality getLeftCardinality() {
        return (IRelationship.Cardinality)((Object)this.getChild(0).getPropertyValue(PROP_LEFT_CARDINALITY));
    }

    public IRelationship.Cardinality getRightCardinality() {
        return (IRelationship.Cardinality)((Object)this.getChild(1).getPropertyValue(PROP_RIGHT_CARDINALITY));
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static enum Hint {
        DEFAULT,
        LOOP,
        HASH,
        MERGE,
        STITCH;

    }

    public static enum SubType {
        CROSS("Cross", "CROSS JOIN"),
        INNER("Inner", "INNER JOIN"),
        LEFT_OUTER("LeftOuter", "LEFT OUTER JOIN"),
        RIGHT_OUTER("RightOuter", "RIGHT OUTER JOIN"),
        FULL_OUTER("FullOuter", "FULL OUTER JOIN"),
        SEMI("Semi", "SEMI-JOIN"),
        ANTI("Anti", "ANTI-JOIN"),
        STITCH("Stitch", "STITCH JOIN");

        private String key;
        private String joinName;

        private SubType(String theKey, String theJoinName) {
            this.key = theKey;
            this.joinName = theJoinName;
        }

        public String key() {
            return this.key;
        }

        public String joinName() {
            return this.joinName;
        }

        public boolean isOuterJoin() {
            return this == LEFT_OUTER || this == RIGHT_OUTER || this == FULL_OUTER;
        }
    }
}

