/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterLikeColumnScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterNotLikeColumnScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorLikeColumnScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorNotLikeColumnScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.regex.XVectorFilterLikeRegexColumnScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.regex.XVectorFilterNotLikeRegexColumnScalar;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLLike
extends SQLAbstractBooleanFunction {
    private static final int MAX_ARGS = 3;
    public static final String PROP_ENUM_SUBTYPE = "subType";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLLike.create(p, jjtid, 301044);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301044;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    @Override
    public String getFunctionName() {
        return this.getSubType().key();
    }

    @Override
    protected String getKey() {
        String key = "predicates." + this.getFunctionName();
        if (this.getNumberChildren() > 2) {
            key = this.getSubType() == SubType.LIKE ? key + ".escape" : key + ".flag";
        }
        return key;
    }

    @Override
    public int getMaximumChildren() {
        return 3;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result) {
            boolean bl = result = this.getChild(1).getType() == 301031 || dataSource.getCapabilities().isSupported("supports.expressionsInLikePattern");
        }
        if (!result) {
            SQLLike.addUnsupportedReason(ul, "Unsupported function.", this);
        }
        return result;
    }

    @Override
    public IDataType getDataType() {
        return BooleanType.BOOLEANTYPE;
    }

    @Override
    protected void analyzeJoinCondition(BitMask bitMask) {
        bitMask.set(15);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        if (this.getParent().getType() == 301030) {
            SQLLike.addUnsupportedReasonForVQE(ul, "Unsupported LIKE predicate inside a value list");
            vectorizable = false;
        } else if (this.getChild(1).getType() != 301031) {
            SQLLike.addUnsupportedReasonForVQE(ul, "Second argument of LIKE predicate must be literal");
            vectorizable = false;
        }
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        boolean isFilter;
        boolean negated = false;
        IXQEQueryNode parent = this.getParent();
        if (parent.getType() == 301027) {
            negated = ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT;
            parent = parent.getParent();
        }
        while (parent.getType() == 301027) {
            parent = parent.getParent();
        }
        boolean bl = isFilter = parent.getType() == 301009;
        if (this.getSubType() == SubType.LIKE) {
            if (isFilter) {
                if (negated) {
                    return XVectorFilterNotLikeColumnScalar.class;
                }
                return XVectorFilterLikeColumnScalar.class;
            }
            if (negated) {
                return XVectorNotLikeColumnScalar.class;
            }
            return XVectorLikeColumnScalar.class;
        }
        if (negated) {
            return XVectorFilterNotLikeRegexColumnScalar.class;
        }
        return XVectorFilterLikeRegexColumnScalar.class;
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static enum SubType {
        LIKE("Like"),
        LIKE_REGEX("LikeRegex");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        String key() {
            return this.key;
        }
    }
}

