/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.NullType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SQLLiteral
extends SQLExpression {
    public static final String PROP_OBJECT_VALUE = "value";
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_BOOLEAN_PADDED = "padded";
    private static final String LITERALS = "literals.";
    public static final String LITERALSFORMAT = "literals.format.";
    private static ConcurrentMap<String, String> capabilitiesKeysCache = new ConcurrentHashMap<String, String>();

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLLiteral.create(p, jjtid, 301031);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    public void setValue(String sValue) {
        IDataType dataType = this.getDataType();
        Value value = (Value)dataType.createValue();
        value.set(sValue);
        this.setPropertyValue(PROP_OBJECT_VALUE, value);
    }

    public void setValue(Value sValue) {
        if (sValue != null) {
            this.setPropertyValue(PROP_OBJECT_VALUE, sValue);
            this.setPropertyValue(PROP_OBJECT_DATATYPE, sValue.getDataType());
        }
    }

    public Value getValue() {
        return (Value)this.getPropertyValue(PROP_OBJECT_VALUE);
    }

    public boolean isPadded() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_PADDED, false);
    }

    public void setPadded(boolean padded) {
        this.setPropertyValue(PROP_BOOLEAN_PADDED, true);
    }

    @Override
    public int getType() {
        return 301031;
    }

    @Override
    public void writeFormattedText(IDataSourceCapabilities capabilities, QueryFormatter formatter) {
        Value value = this.getValue();
        if (value != null) {
            String formatSpec = capabilities.getStringValue(LITERALSFORMAT + this.getDataType().getCapabilitiesKey(), null);
            if (formatSpec != null) {
                formatter.addText(value.getFormattedLiteral(formatSpec));
            } else {
                formatter.addText(value.getJDBCLiteral());
            }
        }
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        boolean result = true;
        IXQEQueryNode parent = this.getParent();
        if (parent != null && parent.getType() == 301030 && parent.getParent() instanceof SQLProject) {
            result = capabilities.getBooleanValue("supports.literalsInSelectList");
        }
        String key = this.getCapabilitiesKey();
        if (result) {
            result = capabilities.isSupported(this.getCapabilitiesKey());
        }
        if (result && this.getDataType().getCCLTypeCode() == 58) {
            TimeValue value = (TimeValue)this.getValue();
            boolean bl = result = value.getNanoseconds() == 0 || capabilities.isSupported(key + ".fractional_seconds");
        }
        if (result && (this.getDataType() instanceof CharType || this.getDataType() instanceof VarcharType) && ((TextValue)this.getValue()).getCurrentLength() == 0) {
            boolean bl = result = !capabilities.isSupported("supports.emptyStringIsNull");
            if (!result) {
                SQLLiteral.addUnsupportedReason(ul, "Empty string is treated as NULL", this);
            }
        }
        return result;
    }

    private String getCapabilitiesKey() {
        String valueFromMap;
        String key = this.getDataType().getTypeName();
        String capabilitiesKey = (String)capabilitiesKeysCache.get(key);
        if (capabilitiesKey == null && (valueFromMap = capabilitiesKeysCache.putIfAbsent(key, capabilitiesKey = LITERALS + this.getDataType().getCapabilitiesKey())) != null) {
            capabilitiesKey = valueFromMap;
        }
        return capabilitiesKey;
    }

    public static boolean isFeatureSupported(IDataSource dataSource, IDataType dType) {
        return dataSource.getCapabilities().isSupported(LITERALS + dType.getCapabilitiesKey());
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node.getType() != 301031) {
            return false;
        }
        Value value = ((SQLLiteral)node).getValue();
        if (value.getDataType().getCCLTypeCode() != this.getValue().getDataType().getCCLTypeCode()) {
            return false;
        }
        return value.compareTo(this.getValue()) == 0;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean isExecutable(boolean localProcessing) {
        return true;
    }

    @Override
    public boolean isIntegerLiteralValueZero() {
        return this.isIntegerLiteral() && this.getValue().getLong() == 0L;
    }

    @Override
    public boolean isIntegerLiteralValueOne() {
        return this.isIntegerLiteral() && this.getValue().getLong() == 1L;
    }

    @Override
    public boolean isIntegerLiteralValueZeroOrOne() {
        if (this.isIntegerLiteral()) {
            long longValue = this.getValue().getLong();
            return longValue == 0L || longValue == 1L;
        }
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.getDataType() == NullType.NULLTYPE;
    }

    @Override
    public IValue execute(XDataContext context) {
        return this.getValue();
    }

    @Override
    public boolean isBooleanLiteral() {
        return this.getDataType().getSubType() == DataSubType.BOOLEANTYPE;
    }

    @Override
    public boolean isCharacterLiteral() {
        return this.getDataType().getSubType() == DataSubType.TEXTTYPE;
    }

    public boolean isIntegerLiteral() {
        return this.getDataType().isInteger();
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        IDataType dType = this.getDataType();
        boolean bl = vectorizable = !dType.isBlob() && !dType.isClob();
        if (!vectorizable) {
            SQLLiteral.addUnsupportedReasonForVQE(ul, "Unsupported literal of type: " + dType.getTypeName());
        }
        return vectorizable;
    }
}

