/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLNativeSql
extends SQLRelation {
    public static final String PROP_STRING_NATIVESQL = "nativesql";
    public static final String PROP_BOOL_PASSTHROUGH = "passthrough";
    public static final String PROP_JDBC_STATEMENT = "statement";
    public static final String PROP_JDBC_RESULTSET = "resultSet";
    public static final String PROP_POOLED_CONNECTION = "pooledConnection";
    public static final String PROP_OBJECT_DESCRIBED_QUERYITEMS = "describedQueryItems";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLNativeSql.create(p, jjtid, 301012);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301012;
    }

    public String getSqlString() {
        return (String)this.getPropertyValue(PROP_STRING_NATIVESQL);
    }

    public void setSqlString(String aSqlString) {
        this.setPropertyValue(PROP_STRING_NATIVESQL, aSqlString);
    }

    public void setIsPassThrough(boolean isPassThrough) {
        this.setPropertyValue(PROP_BOOL_PASSTHROUGH, isPassThrough);
    }

    public boolean isPassThrough() {
        Boolean passthrough = (Boolean)this.getPropertyValue(PROP_BOOL_PASSTHROUGH);
        return passthrough != null && passthrough != false;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result;
        boolean bl = result = !this.isPassThrough();
        if (!result) {
            SQLNativeSql.addUnsupportedReason(ul, "The specified native query is pass-through", this);
        }
        return result;
    }

    @Override
    public List<String> getColumnNames() {
        SQLQueryItemList qItems = this.getQueryItemList();
        ArrayList<String> columnNames = new ArrayList<String>(qItems.size());
        for (SQLQueryItem qItem : qItems) {
            columnNames.add(qItem.getName());
        }
        return columnNames;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node.getType() == this.getType()) {
            SQLNativeSql nativeSql = (SQLNativeSql)node;
            if (this.isPassThrough() == nativeSql.isPassThrough() && this.getSqlString().equals(nativeSql.getSqlString())) {
                return true;
            }
        }
        return false;
    }

    public void setDescQueryItemList(SQLQueryItemList queryItemList) {
        this.setPropertyValue(PROP_OBJECT_DESCRIBED_QUERYITEMS, queryItemList);
    }

    public SQLQueryItemList getDescQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_DESCRIBED_QUERYITEMS);
    }

    public boolean hasWithClause() {
        return SQLNativeSql.hasWithClauseInSQL(this.getSqlString());
    }

    public static boolean hasWithClauseInSQL(String text) {
        boolean found = false;
        Matcher matcherWith = Pattern.compile("\\bwith\\b", 2).matcher(text);
        Matcher matcherSingleQuote = Pattern.compile("'[^']*(''[^']*)*'").matcher(text);
        Matcher matcherDoubleQuote = Pattern.compile("\".*\"").matcher(text);
        Matcher matcherWithInComments = Pattern.compile("--.*\\bwith\\b", 2).matcher(text);
        Matcher matcherComments = Pattern.compile("--").matcher(text);
        int iWithStart = -1;
        int iWithEnd = -1;
        int iStartWithInComments = -1;
        int iEndWithInComments = -1;
        int iStartComments = -1;
        int iEndComments = -1;
        while (!found && matcherWith.find()) {
            found = true;
            iWithStart = matcherWith.start();
            iWithEnd = matcherWith.end();
            if (matcherWithInComments.find()) {
                iStartWithInComments = matcherWithInComments.start();
                iEndWithInComments = matcherWithInComments.end();
                if (iStartWithInComments < iWithStart && iWithEnd <= iEndWithInComments) {
                    matcherComments.find();
                    iStartComments = matcherComments.start();
                    iEndComments = matcherComments.end();
                    if (!SQLNativeSql.isInLiteralRange(matcherSingleQuote, iStartComments, iEndComments) && !SQLNativeSql.isInLiteralRange(matcherDoubleQuote, iStartWithInComments, iEndWithInComments)) {
                        found = false;
                    }
                }
            }
            if (!found || !SQLNativeSql.isInLiteralRange(matcherSingleQuote, iWithStart, iWithEnd) && !SQLNativeSql.isInLiteralRange(matcherDoubleQuote, iWithStart, iWithEnd)) continue;
            found = false;
        }
        return found;
    }

    private static boolean isInLiteralRange(Matcher matcher, int iStart, int iEnd) {
        matcher.reset();
        while (matcher.find()) {
            if (matcher.start() >= iStart || matcher.end() <= iEnd) continue;
            return true;
        }
        return false;
    }
}

