/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import java.util.List;

public class SQLParameter
extends SQLExpression {
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_STRING_MODEL_FILTER_ITEM = "modelFilterItem";
    public static final String PROP_BOOL_USE_PARAMETERIZED_SQL = "useParameterizedSQL";
    public static final String PROP_STRING_VALUE_PREFIX = "valuePrefix";
    public static final String PROP_STRING_VALUE_SUFFIX = "valueSuffix";
    public static final String PROP_STRING_VALUE = "inValue";
    public static final String PROP_STRING_MODE = "mode";
    private static final String PROP_STRING_ISMASTERDETAIL = "isMasterDetailLink";
    public static final String STORED_PROCEDURE_PARAM = "isStoredProcedureParam";
    public static final String C_OUT = "OUT";
    public static final String C_INOUT = "INOUT";
    public static final String C_IN = "IN";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLParameter.create(p, jjtid, 301051);
    }

    public SQLParameter() {
        this.setMode(C_IN);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    public void setName(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    public String getName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public void setMode(String mode) {
        this.setPropertyValue(PROP_STRING_MODE, mode);
    }

    public Boolean isOutParameter() {
        return C_OUT.equalsIgnoreCase((String)this.getPropertyValue(PROP_STRING_MODE));
    }

    public Boolean isInOutParameter() {
        return C_INOUT.equalsIgnoreCase((String)this.getPropertyValue(PROP_STRING_MODE));
    }

    public String getMode() {
        return (String)this.getPropertyValue(PROP_STRING_MODE);
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    public void setModelFilterItem(String modelFilterItem) {
        this.setPropertyValue(PROP_STRING_MODEL_FILTER_ITEM, modelFilterItem);
    }

    public String getModelFilterItem() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL_FILTER_ITEM);
    }

    @Override
    public int getType() {
        return 301051;
    }

    public boolean getUseParameterizedSQL() {
        Boolean useParameterizedSql = (Boolean)this.getPropertyValue(PROP_BOOL_USE_PARAMETERIZED_SQL);
        if (useParameterizedSql != null) {
            return useParameterizedSql;
        }
        return false;
    }

    public void setUseParameterizedSQL(boolean useParamSQL) {
        this.setPropertyValue(PROP_BOOL_USE_PARAMETERIZED_SQL, new Boolean(useParamSQL));
    }

    public void setValuePrefix(String name) {
        this.setPropertyValue(PROP_STRING_VALUE_PREFIX, name);
    }

    public String getValuePrefix() {
        return (String)this.getPropertyValue(PROP_STRING_VALUE_PREFIX);
    }

    public void setValueSuffix(String name) {
        this.setPropertyValue(PROP_STRING_VALUE_SUFFIX, name);
    }

    public String getValueSuffix() {
        return (String)this.getPropertyValue(PROP_STRING_VALUE_SUFFIX);
    }

    public void setInValue(String value) {
        this.setPropertyValue(PROP_STRING_VALUE, value);
    }

    public String getInValue() {
        return (String)this.getPropertyValue(PROP_STRING_VALUE);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node instanceof SQLParameter) {
            SQLParameter parameter = (SQLParameter)node;
            String name1 = this.getName();
            String name2 = parameter.getName();
            if (name1 == null || name2 == null) {
                if (this.getPropertyValue(STORED_PROCEDURE_PARAM) != null && parameter.getPropertyValue(STORED_PROCEDURE_PARAM) != null && this.getMode() != null && this.getMode().equals(parameter.getMode())) {
                    if (this.getMode().equalsIgnoreCase(C_IN) || this.getMode().equalsIgnoreCase(C_INOUT)) {
                        String v1 = this.getInValue();
                        String v2 = parameter.getInValue();
                        if (v1 != null && v2 != null) {
                            return v1.equals(v2);
                        }
                        return v1 == null && v2 == null;
                    }
                    if (this.getMode().equalsIgnoreCase(C_OUT)) {
                        return true;
                    }
                }
                return false;
            }
            if (this.getName().equals(parameter.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    @Override
    public boolean isProjectable() {
        return false;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        boolean bl = vectorizable = this.getParent().getType() != 301030;
        if (!vectorizable) {
            SQLParameter.addUnsupportedReasonForVQE(ul, "Unsupported parameter inside a value list");
        }
        return vectorizable;
    }

    public boolean isMasterDetailLinkParameter() {
        Object isMasterDetailParameter = this.getPropertyValue(PROP_STRING_ISMASTERDETAIL);
        if (isMasterDetailParameter == null) {
            return false;
        }
        return (Boolean)isMasterDetailParameter;
    }

    public void setIsMasterDetailParameter(boolean value) {
        this.setPropertyValue(PROP_STRING_ISMASTERDETAIL, value);
    }
}

