/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLQuantifier
extends SQLExpression {
    public static final String PROP_ENUM_SUBTYPE = "subType";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLQuantifier.create(p, jjtid, 301055);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301055;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    @Override
    public IDataType getDataType() {
        IDataType type = ((IValueExpression)this.getChild(0)).getDataType();
        if (type != null && type.getCCLTypeCode() == 101) {
            type = ((RowType)type).getFieldDataType(0);
        }
        return type;
    }

    @Override
    protected String getKey() {
        return "predicates." + this.getSubType().key();
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        IDataSourceCapabilities capabilities;
        String pattern;
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result && ((pattern = this.getPattern(capabilities = dataSource.getCapabilities())) == null || pattern.compareToIgnoreCase("false") == 0)) {
            result = false;
            SQLQuantifier.addUnsupportedReason(ul, "Unsupported " + this.getKey(), this);
        }
        return result;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = false;
        IXQEQueryNode child = this.getChild(0);
        if (child.getType() == 301059) {
            SQLComparison predicate = (SQLComparison)this.getParent();
            SubType subType = this.getSubType();
            boolean bl = vectorizable = subType == SubType.ALL && predicate.getSubType() == SQLComparison.SubType.EQUAL || subType != SubType.ALL && predicate.getSubType() == SQLComparison.SubType.NOTEQUAL;
            if (!vectorizable) {
                SQLQuantifier.addUnsupportedReasonForVQE(ul, "Unsupported quantifier: " + predicate.getSubType().key() + " " + subType.key());
            }
        }
        return vectorizable;
    }

    @Override
    public String[] getSyntaxProperties() {
        String[] syntaxProperties = new String[]{PROP_ENUM_SUBTYPE};
        return syntaxProperties;
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static enum SubType {
        ALL("All"),
        SOME("Some"),
        ANY("Any");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        public String key() {
            return this.key;
        }
    }
}

