/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.INodeCondition;
import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.sql.IOutputList;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.util.FoldConstants;
import com.cognos.xqe.util.ArrayUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SQLQueryNode
extends XQEQueryNode
implements Node,
ISQLQueryNode,
IValueExpression,
IOutputList,
IVectorContext {
    public static final String PROP_STRING_NOTE = "note";
    public static final String PROP_BOOLEAN_SUPPORTED = "supported";
    public static final String PROP_APP_CONTEXT = "applicationContext";
    public static final String PROP_STRING_UNSUPPORTED_REASON = "reason";
    private static final String PROP_INTEGER_CONTEXTNO = "contextNo";
    private static final String PROP_MAP_HINTS = "hints";
    public static final String PROP_BOOLEAN_RECURSIVE_RELATION = "containRecursiveRelation";
    protected int mJJTid;
    protected SQLParser parser;
    private static final int[] ANCHOR_TYPES = new int[]{301004, 301059, 301014, 301011, 301052, 901012, 901013, 901014, 901015, 901022};
    private static final String COMPARABLE_TYPES = "dataType.comparable";

    protected static SQLQueryNode create(SQLParser p, int jjtid, int nodeType) {
        IXQENodeFactory factory = p.getNodeFactory();
        SQLQueryNode node = (SQLQueryNode)factory.createNode(nodeType);
        node.mJJTid = jjtid;
        node.parser = p;
        return node;
    }

    protected SQLQueryNode() {
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public Node jjtGetParent() {
        return (SQLQueryNode)this.getParent();
    }

    @Override
    public void jjtSetParent(Node n) {
        this.setParent((XQEQueryNode)((Object)n));
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.addChildForParsersOnly((IXQEQueryNode)((Object)n), i);
    }

    public void addFirstChild(Node n) {
        if (this.getNumberChildren() == 0) {
            this.addChild((IXQEQueryNode)((Object)n));
        } else {
            this.addChild((IXQEQueryNode)((Object)n), 0);
        }
    }

    @Override
    public Node jjtGetChild(int i) {
        return (SQLQueryNode)this.getChildren()[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.getChildren().length;
    }

    @Override
    public abstract int getType();

    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        super.copyContentTo(nodeFactory, node);
        SQLQueryNode target = (SQLQueryNode)node;
        target.mJJTid = this.mJJTid;
        target.parser = this.parser;
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    public IDataType getBaseDataType() {
        return this.getDataType();
    }

    public boolean isMeasure() {
        return false;
    }

    @Override
    public boolean validateChildCategories() {
        return true;
    }

    @Override
    public final boolean isSupported(IDataSource dataSource) {
        return this.isSupported(dataSource, null);
    }

    public boolean isSupported(IDataSource dataSource, List<String> ul) {
        Boolean pValue = (Boolean)this.getPropertyValue(PROP_BOOLEAN_SUPPORTED);
        if (pValue != null && pValue.booleanValue()) {
            return true;
        }
        return this.isSupportedImpl(dataSource, ul);
    }

    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = true;
        for (int i = 0; i < this.getNumberChildren() && result; ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (child instanceof SQLQueryNode) {
                result &= ((SQLQueryNode)child).isSupported(dataSource, ul);
                continue;
            }
            if (result &= child.isSupported(dataSource)) continue;
            SQLQueryNode.addUnsupportedReason(ul, "Non SQL node in the planning tree.", this);
        }
        return result;
    }

    static void addUnsupportedReason(List<String> list, String reason, SQLQueryNode node) {
        if (list != null) {
            StringBuilder buffer = new StringBuilder();
            if (list.size() == 0) {
                buffer.append(reason);
                buffer.append(", Node Id:");
                buffer.append(node.getId());
                list.add(buffer.toString());
            }
        }
    }

    public static String getUnsupportedReason(List<String> list) {
        if (list.size() == 0) {
            return "Unknown";
        }
        return list.get(0);
    }

    public static void addUnsupportedReasonForVQE(List<String> list, String reason) {
        if (list != null) {
            list.add(reason);
        }
    }

    public static IDataType[] getIncompatibleDataTypes(IXQEQueryNode[] expressions, IDataSource dataSource) {
        int i;
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        boolean result = true;
        IDataType[] pTypes = new IDataType[expressions.length];
        IDataType[] incompatibleType = new IDataType[2];
        String key = null;
        for (i = 0; i < pTypes.length; ++i) {
            pTypes[i] = ((SQLQueryNode)expressions[i]).getDataType();
        }
        incompatibleType[0] = pTypes[0];
        for (i = 1; i < pTypes.length && result; ++i) {
            incompatibleType[1] = pTypes[i];
            if (incompatibleType[0].getCCLTypeCode() == incompatibleType[1].getCCLTypeCode() || (key = capabilities.generateKey(COMPARABLE_TYPES, incompatibleType)) == null) continue;
            result = capabilities.getBooleanValue(key);
        }
        if (!result) {
            return incompatibleType;
        }
        return null;
    }

    public boolean isSupported(IDataSource dataSource, SQLJoin.SubType jType, int sourceNo) {
        if (dataSource == null) {
            return false;
        }
        return this.isSupported(dataSource);
    }

    public boolean isConvertible(IDataSourceCapabilities capabilities) {
        return false;
    }

    public boolean isDerivedTable() {
        return false;
    }

    public BitMask incidence() {
        return this.incidence(new BitMask());
    }

    public BitMask incidence(BitMask mask) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() == 301059) continue;
            child.incidence(mask);
        }
        return mask;
    }

    public String getPattern(IDataSourceCapabilities capabilities) {
        String pattern = capabilities.getStringValue(this.getKey(), null);
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        return pattern;
    }

    protected String getKey() {
        throw new UnsupportedOperationException();
    }

    public boolean isProjectable() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isProjectableForGroupBy() {
        return this.isProjectable();
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    public boolean hasWindowedAggregates() {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (!child.hasWindowedAggregates()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAggregates() {
        boolean status = false;
        for (int i = 0; i < this.getNumberChildren() && !status; ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() == 301034) {
                status = true;
                continue;
            }
            if (child.getType() == 301059) continue;
            status = child.hasAggregates();
        }
        return status;
    }

    @Override
    public boolean hasParameters() {
        SQLQueryItemList qItemList = this.getQueryItemList();
        return qItemList != null && qItemList.hasParameters();
    }

    @Override
    public boolean isLateralDerivedTable() {
        return false;
    }

    public List<IXQEQueryNode> getProjectableExpressions(IDataSource dataSource) {
        return this.getProjectableExpressions(dataSource, null);
    }

    public List<IXQEQueryNode> getProjectableExpressions(IDataSource dataSource, IXQEQueryNode anchorNode) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressions(dataSource, exprNodeList, anchorNode);
        return exprNodeList;
    }

    protected void getProjectableExpressions(IDataSource dataSource, List<IXQEQueryNode> exprNodeList, IXQEQueryNode anchorNode) {
        if (this.isProjectable() && this.isSupported(dataSource)) {
            exprNodeList.add(this);
            return;
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child == anchorNode || child.getType() == 301004) continue;
            child.getProjectableExpressions(dataSource, exprNodeList, anchorNode);
        }
    }

    public List<IXQEQueryNode> getProjectableExpressions() {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressions(exprNodeList);
        return exprNodeList;
    }

    protected void getProjectableExpressions(List<IXQEQueryNode> exprNodeList) {
        if (this.isProjectable()) {
            exprNodeList.add(this);
            return;
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            child.getProjectableExpressions(exprNodeList);
        }
    }

    public List<IXQEQueryNode> getProjectableExpressions(IDataSource dataSource, SQLJoin.SubType jType, int sourceNo, List<IXQEQueryNode> excludeList, IXQEQueryNode anchorNode, BitMask mask) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressions(dataSource, jType, sourceNo, exprNodeList, excludeList, anchorNode, mask);
        return exprNodeList;
    }

    public void getProjectableExpressions(IDataSource dataSource, SQLJoin.SubType jType, int sourceNo, List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> excludeList, IXQEQueryNode anchorNode, BitMask mask) {
        IDataSourceCapabilities capabilities = null;
        if (dataSource != null) {
            capabilities = dataSource.getCapabilities();
        }
        if (SQLQueryNode.isFOJSpecialCase(this, mask)) {
            this.addNodeToList(this, capabilities, exprNodeList);
            return;
        }
        if (excludeList.contains(this)) {
            for (int i = 0; i < this.getNumberChildren(); ++i) {
                SQLQueryNode child = (SQLQueryNode)this.getChild(i);
                child.getProjectableExpressions(dataSource, jType, sourceNo, exprNodeList, excludeList, anchorNode, mask);
            }
            return;
        }
        BitMask eMask = this.incidence(new BitMask()).lor(mask);
        if (eMask.equals(mask) && this.isProjectable() && this.isSupported(dataSource, jType, sourceNo)) {
            boolean add = true;
            for (int i = 0; i < excludeList.size(); ++i) {
                if (!excludeList.get(i).isAncestor(this)) continue;
                add = false;
                break;
            }
            if (add) {
                this.addNodeToList(this, capabilities, exprNodeList);
                return;
            }
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child == anchorNode || child.getType() == 301004) continue;
            child.getProjectableExpressions(dataSource, jType, sourceNo, exprNodeList, excludeList, anchorNode, mask);
        }
    }

    private static boolean isFOJSpecialCase(SQLQueryNode sqlQueryNode, BitMask mask) {
        IXQEQueryNode pPredicate;
        SQLAbstractBooleanFunction comparison;
        IXQEQueryNode predicate = sqlQueryNode.getParent();
        if (predicate == null) {
            return false;
        }
        int pType = predicate.getType();
        if (pType == 301026) {
            comparison = (SQLComparison)predicate;
            if (((SQLComparison)comparison).getSubType() != SQLComparison.SubType.EQUAL) {
                return false;
            }
        } else if (pType == 301075) {
            comparison = (SQLIsDistinctFrom)predicate;
            if (!((SQLIsDistinctFrom)comparison).isNegated()) {
                return false;
            }
        } else {
            return false;
        }
        if ((pPredicate = predicate.getParent()) == null) {
            return false;
        }
        if (pPredicate.getType() != 301009) {
            return false;
        }
        SQLFilter filter = (SQLFilter)pPredicate;
        if (filter.getSubType() != 301011) {
            return false;
        }
        IXQEQueryNode join = filter.getDescendantsOfTypeOrdered(301011, false).get(0);
        SQLJoin theJoin = (SQLJoin)join;
        if (theJoin.getJoinType() != SQLJoin.SubType.FULL_OUTER) {
            return false;
        }
        BitMask b = sqlQueryNode.incidence();
        if (b.cardinality() > 1) {
            return false;
        }
        return b.intersects(mask);
    }

    protected void addNodeToList(IXQEQueryNode node, IDataSourceCapabilities capabilities, List<IXQEQueryNode> exprNodeList) {
        exprNodeList.add(this);
    }

    public List<IXQEQueryNode> getProjectableExpressions(IDataSource dataSource, int anchorNodeType) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressions(dataSource, exprNodeList, anchorNodeType);
        return exprNodeList;
    }

    public List<IXQEQueryNode> getProjectableExpressions(IDataSource dataSource, List<IXQEQueryNode> includeList, List<IXQEQueryNode> excludeList) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressions(dataSource, exprNodeList, includeList, excludeList);
        return exprNodeList;
    }

    public List<IXQEQueryNode> getProjectableExpressionsIncludingAnchorList(IDataSource dataSource, List<IXQEQueryNode> anchorList) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressionsIncludingAnchorList(dataSource, exprNodeList, anchorList);
        return exprNodeList;
    }

    public List<IXQEQueryNode> getProjectableExpressionsIncludingAnchorList(List<IXQEQueryNode> anchorList) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressionsIncludingAnchorList(exprNodeList, anchorList);
        return exprNodeList;
    }

    public List<IXQEQueryNode> getProjectableExpressionsExcludingAnchorList(IDataSource dataSource, List<IXQEQueryNode> anchorList) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressionsExcludingAnchorList(dataSource, exprNodeList, anchorList);
        return exprNodeList;
    }

    public List<IXQEQueryNode> getProjectableExpressionsExcludingAnchorList(List<IXQEQueryNode> anchorList, IPlanningEnvironment environment) {
        ArrayList<IXQEQueryNode> exprNodeList = new ArrayList<IXQEQueryNode>();
        this.getProjectableExpressionsExcludingAnchorList(exprNodeList, anchorList, environment);
        return exprNodeList;
    }

    protected void getProjectableExpressions(IDataSource dataSource, List<IXQEQueryNode> exprNodeList, int anchorNodeType) {
        if (this.isProjectable() && this.isSupported(dataSource)) {
            exprNodeList.add(this);
            return;
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() == anchorNodeType) continue;
            child.getProjectableExpressions(dataSource, exprNodeList, anchorNodeType);
        }
    }

    protected void getProjectableExpressions(IDataSource dataSource, List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> includeList, List<IXQEQueryNode> excludeList) {
        if (includeList.contains(this)) {
            exprNodeList.add(this);
            return;
        }
        if (excludeList.contains(this)) {
            for (int i = 0; i < this.getNumberChildren(); ++i) {
                SQLQueryNode child = (SQLQueryNode)this.getChild(i);
                child.getProjectableExpressions(dataSource, exprNodeList, includeList, excludeList);
            }
            return;
        }
        if (this.isProjectable() && this.isSupported(dataSource)) {
            boolean add = true;
            for (int i = 0; i < excludeList.size(); ++i) {
                if (!excludeList.get(i).isAncestor(this)) continue;
                add = false;
                break;
            }
            if (add) {
                exprNodeList.add(this);
                return;
            }
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            child.getProjectableExpressions(dataSource, exprNodeList, includeList, excludeList);
        }
    }

    protected void getProjectableExpressionsIncludingAnchorList(IDataSource dataSource, List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> anchorList) {
        if (anchorList.contains(this)) {
            exprNodeList.add(this);
            return;
        }
        if (this.isProjectable() && this.isSupported(dataSource)) {
            exprNodeList.add(this);
            return;
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            child.getProjectableExpressionsIncludingAnchorList(dataSource, exprNodeList, anchorList);
        }
    }

    protected void getProjectableExpressionsIncludingAnchorList(List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> anchorList) {
        if (anchorList.contains(this)) {
            exprNodeList.add(this);
            return;
        }
        if (this.isProjectable() && this.getNumberChildren() == 0) {
            exprNodeList.add(this);
            return;
        }
        if (this.getNodeType() == 301033 && ((SQLFunction)this).isDBOnly()) {
            exprNodeList.add(this);
            return;
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() == 301004) continue;
            child.getProjectableExpressionsIncludingAnchorList(exprNodeList, anchorList);
        }
    }

    protected void getProjectableExpressionsExcludingAnchorList(IDataSource dataSource, List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> anchorList) {
        if (!anchorList.contains(this) && this.isProjectable() && this.isSupported(dataSource)) {
            boolean add = true;
            for (int i = 0; i < anchorList.size(); ++i) {
                if (!anchorList.get(i).isAncestor(this)) continue;
                add = false;
                break;
            }
            if (add) {
                exprNodeList.add(this);
                return;
            }
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() == 301004) continue;
            child.getProjectableExpressionsExcludingAnchorList(dataSource, exprNodeList, anchorList);
        }
    }

    protected void getProjectableExpressionsExcludingAnchorList(List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> anchorList, IPlanningEnvironment environment) {
        FoldConstants foldConstants = new FoldConstants();
        this.getProjectableExpressionsExcludingAnchorList(exprNodeList, anchorList, environment, foldConstants);
    }

    private void getProjectableExpressionsExcludingAnchorList(List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> anchorList, IPlanningEnvironment environment, Transformation foldConstants) {
        int i;
        if (anchorList.contains(this)) {
            for (int i2 = 0; i2 < this.getNumberChildren(); ++i2) {
                SQLQueryNode child = (SQLQueryNode)this.getChild(i2);
                if (child.getType() == 301004) continue;
                child.getProjectableExpressionsExcludingAnchorList(exprNodeList, anchorList, environment);
            }
            return;
        }
        for (i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() != 301025 || !foldConstants.passesNodeCondition((IXQEQueryNode)child, environment)) continue;
            foldConstants.apply((IXQEQueryNode)child, environment);
        }
        if (this.isProjectable()) {
            boolean add = true;
            for (int i3 = 0; i3 < anchorList.size(); ++i3) {
                if (!anchorList.get(i3).isAncestor(this)) continue;
                add = false;
                break;
            }
            if (add) {
                exprNodeList.add(this);
                return;
            }
        }
        for (i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() == 301004) continue;
            child.getProjectableExpressionsExcludingAnchorList(exprNodeList, anchorList, environment, foldConstants);
        }
    }

    public List<SQLFid> getFieldIdentifiers(IXQEQueryNode anchorNode, BitSet mask) {
        ArrayList<SQLFid> fidList = new ArrayList<SQLFid>();
        this.getFieldIdentifiers(fidList, anchorNode, mask);
        return fidList;
    }

    protected void getFieldIdentifiers(List<SQLFid> fidList, IXQEQueryNode anchorNode, BitSet mask) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (child == anchorNode || ArrayUtil.contains(ANCHOR_TYPES, child.getType())) continue;
            ((SQLQueryNode)child).getFieldIdentifiers(fidList, anchorNode, mask);
        }
    }

    public List<SQLFid> getFieldIdentifiers() {
        return this.getFieldIdentifiers(ANCHOR_TYPES);
    }

    public List<SQLFid> getFieldIdentifiers(int[] anchorTypes) {
        ArrayList<SQLFid> fidList = new ArrayList<SQLFid>();
        this.getFieldIdentifiers(fidList, anchorTypes);
        return fidList;
    }

    protected void getFieldIdentifiers(List<SQLFid> fidList, int[] anchorTypes) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (ArrayUtil.contains(anchorTypes, child.getType())) continue;
            ((SQLQueryNode)child).getFieldIdentifiers(fidList, anchorTypes);
        }
    }

    public List<SQLFid> getFieldIdentifiers(INodeCondition anchorCondition) {
        ArrayList<SQLFid> fidList = new ArrayList<SQLFid>();
        this.getFieldIdentifiers(fidList, anchorCondition);
        return fidList;
    }

    protected void getFieldIdentifiers(List<SQLFid> fidList, INodeCondition anchorCondition) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (anchorCondition.applies(child) || ArrayUtil.contains(ANCHOR_TYPES, child.getType())) continue;
            ((SQLQueryNode)child).getFieldIdentifiers(fidList, anchorCondition);
        }
    }

    @Override
    public SQLQueryItemList getBaseQueryItemList() {
        return ((ISQLQueryNode)this.getChild(0)).getBaseQueryItemList();
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        return ((ISQLQueryNode)this.getChild(0)).getQueryItemList();
    }

    public void setQueryItemList(SQLQueryItemList queryItemList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLValueList getOutputList() {
        if (this.getNumberChildren() == 1 || this.getType() == 301018 || this.getType() == 301019 || this.getType() == 301060) {
            return ((IOutputList)((Object)this.getChild(0))).getOutputList();
        }
        return null;
    }

    public List<String> getColumnNames() {
        if (this.getNumberChildren() == 1) {
            return ((SQLQueryNode)this.getChild(0)).getColumnNames();
        }
        return null;
    }

    public IXQEQueryNode getFilterNode() {
        return null;
    }

    public int getNumberOfLeafNodes() {
        return 1;
    }

    public IXQEQueryNode getLeafNodeForPredicatePushdown(IXQEQueryNode predicate) {
        throw new UnsupportedOperationException();
    }

    public IDataSource getDataSource() {
        if (!(this.getChild(0) instanceof SQLQueryNode)) {
            return null;
        }
        return ((SQLQueryNode)this.getChild(0)).getDataSource();
    }

    public void getDataSourceList(Collection<IDataSource> dataSourcesFromContext, ArrayList<IDataSource> outDataSources) {
        if (this.getType() == 301059) {
            return;
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            ((SQLQueryNode)this.getChild(i)).getDataSourceList(dataSourcesFromContext, outDataSources);
        }
    }

    public Collection<IDataSource> getDataSourceList(ArrayList<IDataSource> outDataSources) {
        if (this.getType() != 301059 && !(this instanceof SQLExpression)) {
            for (int i = 0; i < this.getNumberChildren(); ++i) {
                ((SQLQueryNode)this.getChild(i)).getDataSourceList(outDataSources);
            }
        }
        return outDataSources;
    }

    static void addDatasource(ArrayList<IDataSource> dataSources, IDataSource dataSource) {
        if (dataSource.isRelational()) {
            int indexToReplace = -1;
            boolean foundSameCMDatasource = false;
            for (int i = 0; i < dataSources.size(); ++i) {
                IDataSource ds = dataSources.get(i);
                if (!ds.getCMDataSourceName().equals(dataSource.getCMDataSourceName())) continue;
                foundSameCMDatasource = true;
                if (dataSource.getName().compareTo(ds.getName()) >= 0) break;
                indexToReplace = i;
                break;
            }
            if (indexToReplace >= 0) {
                dataSources.set(indexToReplace, dataSource);
            }
            if (!foundSameCMDatasource) {
                dataSources.add(dataSource);
            }
        } else {
            dataSources.add(dataSource);
        }
    }

    @Override
    public int getNumberColumns() {
        return -1;
    }

    public SQLQueryBlock getParentQueryBlock() {
        return (SQLQueryBlock)this.getAncestorOfType(301004);
    }

    public void setSupported(boolean isSupported) {
        this.setPropertyValue(PROP_BOOLEAN_SUPPORTED, isSupported);
    }

    public void setUnsupportedReason(String reason) {
        this.setPropertyValue(PROP_STRING_UNSUPPORTED_REASON, reason);
    }

    public String getNote() {
        return (String)this.getPropertyValue(PROP_STRING_NOTE);
    }

    public void getCognosSQL(IDataSourceCapabilities capabilities, QueryFormatter formatter) {
        this.accept(formatter, capabilities);
    }

    @Override
    public double getCardinality() {
        int nRows = 1;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            nRows = (int)((double)nRows * ((ISQLQueryNode)this.getChild(i)).getCardinality());
        }
        return nRows;
    }

    public int getMaximumChildren() {
        return this.getNumberChildren();
    }

    public int getContextNo() {
        Integer contextNo = (Integer)this.getPropertyValue(PROP_INTEGER_CONTEXTNO);
        if (contextNo == null) {
            return 0;
        }
        return contextNo;
    }

    public void setContextNo(int contextNo) {
        this.setPropertyValue(PROP_INTEGER_CONTEXTNO, contextNo);
    }

    public void setHints(Map<String, Object> hints) {
        this.setPropertyValue(PROP_MAP_HINTS, hints);
    }

    public Map<String, Object> getHints() {
        return (Map)this.getPropertyValue(PROP_MAP_HINTS);
    }

    public Object getHint(String key) {
        Map<String, Object> hints = this.getHints();
        if (hints == null) {
            return null;
        }
        return hints.get(key);
    }

    public Map<String, Object> getOrAddHints() {
        Map<String, Object> hints = this.getHints();
        if (hints == null) {
            hints = new HashMap<String, Object>();
            this.setHints(hints);
        }
        return hints;
    }

    public void removeHint(String key) {
        Map<String, Object> hints = this.getHints();
        if (hints == null) {
            return;
        }
        hints.remove(key);
    }

    public void invalidateSupportCache() {
        this.removeProperty(PROP_BOOLEAN_SUPPORTED);
        boolean supported = true;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)this.getAncestorOfType(301004);
        if (pQueryBlock == null) {
            return;
        }
        IDataSource dataSource = pQueryBlock.getDataSource();
        if (dataSource == null) {
            return;
        }
        supported = this.isSupported(dataSource);
        if (supported) {
            this.setSupported(true);
        }
        SQLQueryNode parent = (SQLQueryNode)this.getParent();
        while (supported && parent instanceof SQLAbstractFunction) {
            parent.removeProperty(PROP_BOOLEAN_SUPPORTED);
            supported = parent.isSupported(dataSource);
            if (supported) {
                parent.setSupported(true);
            }
            parent = (SQLQueryNode)parent.getParent();
        }
        while (parent instanceof SQLAbstractFunction || parent instanceof SQLWhen || parent instanceof SQLSearchedCase || parent instanceof SQLValueList) {
            parent.removeProperty(PROP_BOOLEAN_SUPPORTED);
            parent = (SQLQueryNode)parent.getParent();
        }
    }

    public boolean containRecursiveRelation() {
        if (this.getBooleanPropertyValue(PROP_BOOLEAN_RECURSIVE_RELATION) != null) {
            return this.getBooleanPropertyValue(PROP_BOOLEAN_RECURSIVE_RELATION);
        }
        boolean containRecursiveRelation = false;
        List<IXQEQueryNode> relationNodes = this.getDescendantsOfTypeOrdered(301016, true);
        for (IXQEQueryNode child : relationNodes) {
            if (!((SQLRelation)child).isRecursive()) continue;
            containRecursiveRelation = true;
            break;
        }
        this.setPropertyValue(PROP_BOOLEAN_RECURSIVE_RELATION, containRecursiveRelation);
        return containRecursiveRelation;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return ((IVectorContext)((Object)this.getChild(0))).getVectorizationContext();
    }
}

