/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IPhysicalIndex;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SQLRelation
extends SQLIdentifier {
    public static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_OBJECT_INDEXES = "indexes";
    public static final String PROP_OBJECT_DATASOURCE = "dataSource";
    public static final String PROP_STRING_QUEUE_NAME = "queueName";
    public static final String PROP_BOOLEAN_ISRECURSIVE = "isRecursive";
    public static final String PROP_BOOLEAN_ISWITHCLAUSEQUERYREF = "isWithClauseQueryRef";
    public static final String PROP_DOUBLE_CARDINALITY = "cardinality";
    public static final String PROP_STRING_EXTERNAL_NAME = "externalName";
    public static final String PROP_MAP_METADATA_PROPERTIES = "properties";
    public static final String PROP_PROJECTED_ITEMS = "projectedItems";
    public static final String PROP_FULL_QS_NAME = "fullQSName";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLRelation.create(p, jjtid, 301016);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    public void setDataSource(IDataSource dataSource) {
        this.setPropertyValue(PROP_OBJECT_DATASOURCE, dataSource);
    }

    @Override
    public IDataSource getDataSource() {
        return (IDataSource)this.getPropertyValue(PROP_OBJECT_DATASOURCE);
    }

    @Override
    public void getDataSourceList(Collection<IDataSource> dataSourcesFromContext, ArrayList<IDataSource> dataSources) {
        IDataSource dataSource = this.getDataSource();
        if (this.isWithClauseQueryRef()) {
            SQLQueryBlock qBlock = null;
            IXQEQueryNode withSpec = this.getAncestorOfType(301022);
            if (withSpec != null) {
                for (int i = 0; i < withSpec.getNumberChildren() - 1 && !(qBlock = (SQLQueryBlock)withSpec.getChild(i)).getName().equals(this.getName()); ++i) {
                }
                if (qBlock != null) {
                    Collection<IDataSource> dsList = qBlock.getDataSourceList();
                    if (dsList == null) {
                        return;
                    }
                    for (IDataSource ds : dsList) {
                        SQLRelation.addDatasource(dataSources, ds);
                    }
                }
            }
        } else if (dataSource != null) {
            SQLRelation.addDatasource(dataSources, dataSource);
        }
    }

    @Override
    public Collection<IDataSource> getDataSourceList(ArrayList<IDataSource> outDataSources) {
        this.getDataSourceList(null, outDataSources);
        return outDataSources;
    }

    @Override
    public int getType() {
        return 301016;
    }

    @Override
    public int getNumberColumns() {
        int nColumns = -1;
        SQLQueryItemList queryItems = this.getQueryItemList();
        if (queryItems != null) {
            nColumns = queryItems.size();
        }
        return nColumns;
    }

    @Override
    public void setQueryItemList(SQLQueryItemList qItemList) {
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, qItemList);
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
    }

    @Override
    public SQLQueryItemList getBaseQueryItemList() {
        return this.getQueryItemList();
    }

    public void setIndexes(List<IPhysicalIndex> indexes) {
        this.setPropertyValue(PROP_OBJECT_INDEXES, indexes);
    }

    public List<IPhysicalIndex> getIndexes() {
        return (List)this.getPropertyValue(PROP_OBJECT_INDEXES);
    }

    public void setRecursive(boolean isRecursive) {
        this.setPropertyValue(PROP_BOOLEAN_ISRECURSIVE, isRecursive);
    }

    public boolean isRecursive() {
        return this.getPropertyValue(PROP_BOOLEAN_ISRECURSIVE) == Boolean.TRUE;
    }

    public void setQueueName(String name) {
        this.setPropertyValue(PROP_STRING_QUEUE_NAME, name);
    }

    public String getQueueName() {
        return (String)this.getPropertyValue(PROP_STRING_QUEUE_NAME);
    }

    public void setWithClauseQueryRef(boolean isWithClauseQueryRef) {
        this.setPropertyValue(PROP_BOOLEAN_ISWITHCLAUSEQUERYREF, isWithClauseQueryRef);
    }

    public boolean isWithClauseQueryRef() {
        return this.getPropertyValue(PROP_BOOLEAN_ISWITHCLAUSEQUERYREF) == Boolean.TRUE;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        if (this.isRecursive()) {
            return dataSource.getCapabilities().getBooleanValue("supports.recursiveWithClause");
        }
        boolean result = true;
        if (this.isWithClauseQueryRef()) {
            boolean found = false;
            for (IXQEQueryNode withSpec = this.getAncestorOfType(301022); withSpec != null && !found; withSpec = withSpec.getAncestorOfType(301022)) {
                for (int i = 0; i < withSpec.getNumberChildren() - 1 && !found; ++i) {
                    IXQEQueryNode child = withSpec.getChild(i);
                    if (child.getType() == 301004) {
                        SQLQueryBlock qBlock = (SQLQueryBlock)child;
                        if (!this.getName().equals(qBlock.getName())) continue;
                        IDataSource ds = qBlock.getDataSource();
                        result = qBlock.isSupported(ds, ul);
                        found = true;
                        continue;
                    }
                    if (child.getType() != 301007) continue;
                    SQLRangeVar rangeVar = (SQLRangeVar)child;
                    if (!this.getName().equals(rangeVar.getName())) continue;
                    result = child.isSupported(dataSource);
                    found = true;
                }
            }
            if (!result) {
                SQLRelation.addUnsupportedReason(ul, "Unsupported common query expression", this);
            }
        }
        return result;
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    public void setCardinality(double nRows) {
        this.setPropertyValue(PROP_DOUBLE_CARDINALITY, nRows);
    }

    @Override
    public double getCardinality() {
        Double cardinality = (Double)this.getPropertyValue(PROP_DOUBLE_CARDINALITY);
        if (cardinality != null) {
            return cardinality;
        }
        return 1000.0;
    }

    public void setExternalName(String externalName) {
        this.setPropertyValue(PROP_STRING_EXTERNAL_NAME, externalName);
    }

    public String getExternalName() {
        return (String)this.getPropertyValue(PROP_STRING_EXTERNAL_NAME);
    }

    public void setMetadataProperties(Map<String, Object> properties) {
        this.setPropertyValue(PROP_MAP_METADATA_PROPERTIES, properties);
    }

    public Map<String, Object> getMetadataProperties() {
        return (Map)this.getPropertyValue(PROP_MAP_METADATA_PROPERTIES);
    }

    public Map<String, String> getProjectedItems() {
        return (Map)this.getPropertyValue(PROP_PROJECTED_ITEMS);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node.getType() == this.getType()) {
            SQLRelation relation = (SQLRelation)node;
            if (this.getName().equals(relation.getName())) {
                return true;
            }
        }
        return false;
    }

    public boolean isDatabaseTable() {
        return this.getDatabaseName() != null || this.getExternalName() != null;
    }

    public boolean isEligibleForRenaming(IXQEQueryNode node) {
        String currentFullQSName = (String)this.getPropertyValue(PROP_FULL_QS_NAME);
        String providedFullQSName = (String)node.getPropertyValue(PROP_FULL_QS_NAME);
        if (currentFullQSName == null && providedFullQSName == null) {
            return true;
        }
        if (currentFullQSName != null) {
            return currentFullQSName.equals(providedFullQSName);
        }
        return false;
    }
}

