/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLDataFlowNode;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLSetOperator
extends SQLDataFlowNode {
    public static final String PROPERTY_BOOLEAN_ALL = "all";
    public static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_BOOLEAN_ISBOUND = "isBound";
    public static final String PROP_ENUM_SUBTYPE = "subType";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLSetOperator.create(p, jjtid, 301018);
    }

    public SQLSetOperator() {
        this.setPropertyValue(PROPERTY_BOOLEAN_ALL, Boolean.FALSE);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301018;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    public void setAll(boolean all) {
        this.setPropertyValue(PROPERTY_BOOLEAN_ALL, all);
    }

    public boolean getAll() {
        Boolean b = (Boolean)this.getPropertyValue(PROPERTY_BOOLEAN_ALL);
        return b;
    }

    @Override
    public void setQueryItemList(SQLQueryItemList queryItems) {
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, queryItems);
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
    }

    public void setIsBound(boolean flag) {
        this.setPropertyValue(PROP_BOOLEAN_ISBOUND, flag);
    }

    public boolean isBound() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_ISBOUND, false);
    }

    @Override
    public int getNumberColumns() {
        return ((SQLQueryNode)this.getChild(0)).getNumberColumns();
    }

    public int getNestedLevel() {
        int nestedLevel = 0;
        for (SQLQueryNode node = (SQLQueryNode)this.getChild(0); node != null && node.getType() == 301018; node = (SQLQueryNode)node.getChild(0)) {
            ++nestedLevel;
        }
        return nestedLevel;
    }

    public String getSetOperatorName() {
        SubType setOperatorSubType = (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
        switch (setOperatorSubType) {
            case UNION: {
                if (this.getAll()) {
                    return "UNION ALL";
                }
                return "UNION";
            }
            case EXCEPT: {
                if (this.getAll()) {
                    return "EXCEPT ALL";
                }
                return "EXCEPT";
            }
            case INTERSECT: {
                if (this.getAll()) {
                    return "INTERSECT ALL";
                }
                return "INTERSECT";
            }
        }
        return null;
    }

    @Override
    protected String getKey() {
        StringBuilder key = new StringBuilder();
        key.append("operators.set.").append(this.getSubType().key());
        if (this.getAll()) {
            key.append(".").append(PROPERTY_BOOLEAN_ALL);
        }
        return key.toString();
    }

    public void alignColumnNames(List<SQLAlias> aliasList) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (child.getType() == 301018) {
                ((SQLSetOperator)child).alignColumnNames(aliasList);
                continue;
            }
            SQLValueList projectList = ((SQLQueryNode)child).getOutputList();
            List<SQLAlias> currentAliasList = projectList.getAliasList();
            if (currentAliasList != null && currentAliasList == aliasList) continue;
            projectList.setAliasList(aliasList);
        }
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static enum SubType {
        UNION("Union", 2),
        EXCEPT("Except", 2),
        INTERSECT("Intersect", 1);

        private String key;
        private int precedence;

        private SubType(String theKey, int thePrecedence) {
            this.key = theKey;
            this.precedence = thePrecedence;
        }

        public String key() {
            return this.key;
        }

        public int precedence() {
            return this.precedence;
        }
    }
}

