/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLDataFlowNode;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLTop;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import java.util.List;

public class SQLSort
extends SQLDataFlowNode {
    private static final String CAPABILITY_KEY = "clauses.OrderBy";
    public static final String NULLS_ARE_SORTED_AT_START = "general.nullsAreSortedAtStart";
    public static final String NULLS_ARE_SORTED_AT_END = "general.nullsAreSortedAtEnd";
    public static final String NULLS_ARE_SORTED_HIGH = "general.nullsAreSortedHigh";
    public static final String NULLS_ARE_SORTED_LOW = "general.nullsAreSortedLow";
    public static final String NULLS_ORDERING = "general.nullsOrdering";
    public static final String NULLS_ORDERING_IN_WINDOW_SPECIFICATION = "general.nullsOrderingInWindowSpecification";
    private static final String SPACE = " ";
    public static final String EXPRESSIONS_IN_ORDER_BY = "supports.expressionsInOrderBy";
    public static final String EXPRESSIONS_IN_ORDER_BY_ON_GROUPED_QUERY = "supports.expressionsInOrderByOnGroupedQuery";
    public static final String ALIAS_IN_ORDER_BY_EXP = "supports.aliasInOrderByExpression";
    public static final String ORDER_BY_ALIAS = "supports.orderByAlias";
    public static final String ORDER_BY_NAME = "supports.orderByName";
    public static final String ORDER_BY_ORDINAL = "supports.orderByOrdinal";
    public static final String ORDER_BY_UNRELATED = "supports.orderByUnrelated";
    private static final String REQUIRED_COLLATION_ID = "requiredCollationID";
    private static final String PROP_BOOLEAN_PUSHABLE = "pushable";
    private static final String PROP_BOOLEAN_DISTINCT = "distinct";
    public static final String PROP_BOOLEAN_WINDOW_AGGREGATE = "window.aggregate";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLSort.create(p, jjtid, 301019);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301019;
    }

    @Override
    public void getCognosSQL(IDataSourceCapabilities capabilities, QueryFormatter formatter) {
        formatter.setCurrentNodeIndentationLevel(0);
        formatter.addNewLineAndIndentation();
        formatter.addText(this.getPattern(capabilities));
        formatter.addText(SPACE);
        for (int i = 1; i < this.getNumberChildren(); ++i) {
            if (i > 1) {
                formatter.addText(", ");
            }
            ((SQLQueryNode)this.getChild(i)).accept(formatter, capabilities);
        }
    }

    @Override
    public SQLValueList getOutputList() {
        return ((SQLQueryNode)this.getChild(0)).getOutputList();
    }

    public SQLSortKeyList getSortKeyList() {
        return (SQLSortKeyList)this.getChild(1);
    }

    @Override
    public IXQEQueryNode getFilterNode() {
        return ((SQLQueryNode)this.getChild(0)).getFilterNode();
    }

    @Override
    public int getNumberColumns() {
        return ((SQLQueryNode)this.getChild(0)).getNumberColumns();
    }

    public void setPushable(boolean pushable) {
        this.setPropertyValue(PROP_BOOLEAN_PUSHABLE, pushable);
    }

    public boolean isPushable() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_PUSHABLE, true);
    }

    public void setDistinct(boolean distinct) {
        this.setPropertyValue(PROP_BOOLEAN_DISTINCT, distinct);
    }

    public boolean isDistinct() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_DISTINCT, false);
    }

    public void setCollationIdRequired(boolean required) {
        this.setPropertyValue(REQUIRED_COLLATION_ID, required);
    }

    public boolean isCollationIdRequired() {
        return this.getBooleanPropertyValue(REQUIRED_COLLATION_ID, false);
    }

    @Override
    protected String getKey() {
        return CAPABILITY_KEY;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result) {
            result = dataSource.getCapabilities().getBooleanValue("supports.orderByInDerivedTable");
            boolean bl = result = result || this.isImmediateSupportedTopDescendant(dataSource);
        }
        if (result) {
            result = !this.getSortKeyList().containNotSupportedNullOrdering(dataSource);
        }
        return result;
    }

    private boolean isImmediateSupportedTopDescendant(IDataSource dataSource) {
        IXQEQueryNode ancestor = this.getParent();
        if (ancestor.getType() == 301004) {
            ancestor = ancestor.getParent();
        }
        return ancestor.getType() == 301060 && ((SQLTop)ancestor).isFeatureSupported(dataSource);
    }

    public boolean isNullOrderingConvertableToCase(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        boolean result = SQLSearchedCase.isFeatureSupported(capabilities);
        result = result && capabilities.getBooleanValue(EXPRESSIONS_IN_ORDER_BY);
        boolean bl = result = result && (capabilities.getBooleanValue(ORDER_BY_ALIAS) || capabilities.getBooleanValue(ORDER_BY_NAME));
        if (result) {
            IXQEQueryNode desc = this.getChild(0);
            if (desc.getType() == 301004) {
                desc = desc.getChild(0);
            }
            result = desc.getType() == 301015 || desc.getType() == 301010 && capabilities.getBooleanValue(EXPRESSIONS_IN_ORDER_BY_ON_GROUPED_QUERY);
        }
        return result;
    }

    public static boolean isFeatureSupported(IDataSourceCapabilities capabilities) {
        String pattern = capabilities.getStringValue(CAPABILITY_KEY, null);
        return pattern != null && pattern.length() > 0;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        return ((ISQLQueryNode)this.getChild(0)).isVectorizable(ul);
    }
}

