/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLOrdinal;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.List;

public class SQLSortKey
extends SQLExpression {
    public static final String PROPERTY_BOOLEAN_IS_ASCENDING = "isAscending";
    public static final String PROPERTY_BOOLEAN_IS_UNRELATED = "isUnrelated";
    public static final String PROPERTY_ENUM_NULL_ORDERING = "nullOrdering";
    public static final String PROPERTY_ENUM_NULL_ORDERING_IN_WINDOWS_AGGREGATE = "nullOrderingInWindowsAggregate";
    public static final String PROPERTY_GENERATED_BY_TRANSFORMATION = "isGenerated";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLSortKey.create(p, jjtid, 301020);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301020;
    }

    public int getColumnNo() {
        IXQEQueryNode child = this.getChild(0);
        if (child.getType() == 301032) {
            return ((SQLFid)child).getVirtualColumnNo();
        }
        return ((SQLOrdinal)child).getValue() - 1;
    }

    public void setAscending(boolean ascending) {
        this.setPropertyValue(PROPERTY_BOOLEAN_IS_ASCENDING, ascending);
    }

    public void setGenerated(boolean generated) {
        this.setPropertyValue(PROPERTY_GENERATED_BY_TRANSFORMATION, generated);
    }

    public boolean isAscending() {
        Boolean pValue = this.getBooleanPropertyValue(PROPERTY_BOOLEAN_IS_ASCENDING);
        if (pValue == null) {
            return true;
        }
        return pValue;
    }

    public boolean isGenerated() {
        Boolean pValue = this.getBooleanPropertyValue(PROPERTY_GENERATED_BY_TRANSFORMATION);
        if (pValue == null) {
            return false;
        }
        return pValue;
    }

    public NullOrdering getNullOrder() {
        NullOrdering pValue = (NullOrdering)((Object)this.getPropertyValue(PROPERTY_ENUM_NULL_ORDERING));
        if (pValue == null) {
            return NullOrdering.UNSPECIFIED;
        }
        return pValue;
    }

    public void setNullOrder(NullOrdering theNullOrder) {
        this.setPropertyValue(PROPERTY_ENUM_NULL_ORDERING, (Object)theNullOrder);
    }

    public void setUnrelated(boolean isUnrelated) {
        this.setPropertyValue(PROPERTY_BOOLEAN_IS_UNRELATED, isUnrelated);
    }

    public boolean isUnrelated() {
        Boolean pValue = this.getBooleanPropertyValue(PROPERTY_BOOLEAN_IS_UNRELATED);
        if (pValue == null) {
            return false;
        }
        return pValue;
    }

    @Override
    public IDataType getDataType() {
        return ((SQLQueryNode)this.getChild(0)).getDataType();
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result) {
            IXQEQueryNode child;
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            IDataType dType = this.getDataType();
            if (dType != null) {
                boolean bl = result = !dType.isBlob() || capabilities.getBooleanValue("supports.blobsInOrderBy");
                if (!result) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_GroupByNotAllowed);
                }
            }
            if ((child = this.getChild(0)).getType() == 301032) {
                SQLFid fid = (SQLFid)child;
                if (fid.getName() == null) {
                    result = capabilities.getBooleanValue("supports.orderByAlias") || capabilities.getBooleanValue("supports.orderByOrdinal") || capabilities.getBooleanValue("supports.orderByName");
                }
                IXQEQueryNode grandParent = this.getGrandParent();
                if (result && grandParent.getType() == 301019) {
                    boolean bl = result = !this.isUnrelated() || capabilities.getBooleanValue("supports.orderByUnrelated");
                }
            }
            if (!result) {
                SQLSortKey.addUnsupportedReason(ul, "Unsupported Order by alias or ordinal", this);
            }
        }
        return result;
    }

    public boolean isNullOrderingSupported(IDataSource dataSource) {
        boolean result = false;
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        NullOrdering nullOrdering = this.getNullOrder();
        boolean bl = result = capabilities.isSupported("general.nullsOrdering") || nullOrdering == NullOrdering.UNSPECIFIED;
        if (!result) {
            if (nullOrdering == NullOrdering.NULLS_FIRST) {
                boolean bl2 = result = capabilities.isSupported("general.nullsAreSortedAtStart") || capabilities.isSupported("general.nullsAreSortedHigh") && !this.isAscending() || capabilities.isSupported("general.nullsAreSortedLow") && this.isAscending();
            }
            if (nullOrdering == NullOrdering.NULLS_LAST) {
                result = capabilities.isSupported("general.nullsAreSortedAtEnd") || capabilities.isSupported("general.nullsAreSortedHigh") && this.isAscending() || capabilities.isSupported("general.nullsAreSortedLow") && !this.isAscending();
            }
        }
        return result;
    }

    public boolean isNullOrderingSupportedInWindowSpecification(IDataSource dataSource) {
        boolean result = false;
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        NullOrdering nullOrdering = this.getNullOrder();
        boolean bl = result = capabilities.isSupported("general.nullsOrderingInWindowSpecification") || nullOrdering == NullOrdering.UNSPECIFIED;
        if (!result) {
            if (nullOrdering == NullOrdering.NULLS_FIRST) {
                boolean bl2 = result = capabilities.isSupported("general.nullsAreSortedAtStart") || capabilities.isSupported("general.nullsAreSortedHigh") && !this.isAscending() || capabilities.isSupported("general.nullsAreSortedLow") && this.isAscending();
            }
            if (nullOrdering == NullOrdering.NULLS_LAST) {
                result = capabilities.isSupported("general.nullsAreSortedAtEnd") || capabilities.isSupported("general.nullsAreSortedHigh") && this.isAscending() || capabilities.isSupported("general.nullsAreSortedLow") && !this.isAscending();
            }
        }
        return result;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        boolean status = super.isSameExpression(node, compareCalcDefiniton);
        if (status) {
            status = this.isAscending() == ((SQLSortKey)node).isAscending() && this.getNullOrder() == ((SQLSortKey)node).getNullOrder();
        }
        return status;
    }

    public static enum NullOrdering {
        UNSPECIFIED,
        NULLS_FIRST,
        NULLS_LAST;

    }
}

