/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLDataFlowNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLTableSample
extends SQLDataFlowNode {
    public static final String PROP_ENUM_SUBTYPE = "subType";
    private static final String CAPABILITY_PREFIX = "clauses.TableSample";
    private static final String IS_TABLESAMPLE_BEFORE_ALIAS = "clauses.TableSampleBeforeAlias";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLTableSample.create(p, jjtid, 301092);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301092;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    @Override
    protected String getKey() {
        return CAPABILITY_PREFIX + this.getSubType().key();
    }

    public static String getPattern(IDataSourceCapabilities capabilities, SubType subType) {
        String key = CAPABILITY_PREFIX + subType.key();
        String pattern = capabilities.getStringValue(key, null);
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        return pattern;
    }

    public static boolean isTableSampleBeforeAlias(IDataSourceCapabilities capabilities) {
        return capabilities.getBooleanValue(IS_TABLESAMPLE_BEFORE_ALIAS, false);
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static enum SubType {
        SYSTEM("System"),
        BERNOULLI("Bernoulli");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        public String key() {
            return this.key;
        }
    }
}

