/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.ICorrelationName;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLArrayValueConstructor;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLCoalesce;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLColumnStar;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLComputeBreak;
import com.cognos.xqe.ast.sql.SQLCube;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLDistinct;
import com.cognos.xqe.ast.sql.SQLElementRef;
import com.cognos.xqe.ast.sql.SQLExists;
import com.cognos.xqe.ast.sql.SQLExtract;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFieldRef;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLForSystemTime;
import com.cognos.xqe.ast.sql.SQLFormat;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLGroupingSets;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLateral;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLMultisetValueConstructor;
import com.cognos.xqe.ast.sql.SQLNativeSQLValueExpression;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLNull;
import com.cognos.xqe.ast.sql.SQLNullArgument;
import com.cognos.xqe.ast.sql.SQLNullIf;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.ast.sql.SQLOrdinal;
import com.cognos.xqe.ast.sql.SQLOverlaps;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLParameterMapper;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLPeriodValueConstructor;
import com.cognos.xqe.ast.sql.SQLProduct;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLRollup;
import com.cognos.xqe.ast.sql.SQLRowValueConstructor;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLSelect;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLSimilar;
import com.cognos.xqe.ast.sql.SQLSimpleCase;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLSparqlQuery;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLSummaryFilter;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLTableSample;
import com.cognos.xqe.ast.sql.SQLTableValueConstructor;
import com.cognos.xqe.ast.sql.SQLTop;
import com.cognos.xqe.ast.sql.SQLTrim;
import com.cognos.xqe.ast.sql.SQLUser;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.sql.SQLWindowList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.ast.sql.util.SQLAbstractFormattedQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLPatternFormatParser;
import com.cognos.xqe.ast.sql.util.SQLPrettyPrintQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLQueryText;
import com.cognos.xqe.ast.sql.util.SQLQueryTextFactory;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class SQLAbstractUnformattedQueryFormatter
extends QueryFormatter {
    private static final String TWO_SINGLE_QUOTES = "''";
    private static final String SINGLE_QUOTE = "'";
    private static final String SUPPORTS_SCHEMAS_IN_DATA_MANIPULATION = "supports.schemasInDataManipulation";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String USE_NATIVE_SQL_SYNTAX = "UseNativeSQLSyntax";
    public static final String KEYWORD_OVER = "OVER";
    public static final String KEYWORD_ASC = " ASC";
    public static final String KEYWORD_DESC = " DESC";
    public static final String KEYWORD_ORDER_BY = "ORDER BY";
    public static final String KEYWORD_PARTITION_BY = "PARTITION BY";
    public static final String KEYWORD_CASE = "CASE";
    public static final String KEYWORD_WHEN = "WHEN";
    public static final String KEYWORD_THEN = "THEN";
    public static final String KEYWORD_ELSE = "ELSE";
    public static final String KEYWORD_END = "END";
    public static final String KEYWORD_AS = "AS";
    public static final String KEYWORD_NULLS_LAST = " NULLS LAST";
    public static final String KEYWORD_NULLS_FIRST = " NULLS FIRST";
    public static final String KEYWORD_NULL = "NULL";
    public static final String KEYWORD_WITHIN_GROUP = "WITHIN GROUP";
    public static final String KEYWORD_FROM = "FROM";
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_FILTER = "FILTER";
    public static final String KEYWORD_TOP = " TOP ";
    public static final String KEYWORD_WITH = "WITH ";
    public static final String KEYWORD_AT = "AT";
    public static final String KEYWORD_CALL = "CALL ";
    public static final String KEYWORD_PASSING = "PASSING";
    public static final String KEYWORD_LATERAL = "LATERAL";
    public static final String OPEN_BRACKET = "[";
    public static final String CLOSE_BRACKET = "]";
    public static final String QUOTE = "'";
    public static final String ACCESS_MODE = "accessMode";
    public static final String STOREDPROCEDURE_CONTEXT = ".procedure";
    public static final String PROPERTY_PRINT_DB_NAME = "printDbName";
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_NATIVESQL = "nativeSQL";
    public static final String PROPERTY_QUERYSPECIFICATIONSQL = "querySQL";
    public static final String XML_ESCAPE_CHARACTER = "XMLEscapeCharacter";
    public static final String PREFERRED_DELIMITER = "preferredDelimiter";
    private boolean selectKeywordIsAlreadyGenerated = false;
    private boolean forPlanning = false;
    protected Properties builderProps = null;
    private boolean useSQLWithCLause = true;

    public SQLAbstractUnformattedQueryFormatter() {
    }

    public SQLAbstractUnformattedQueryFormatter(Properties props) {
        this.builderProps = props;
        this.addComment();
    }

    public SQLAbstractUnformattedQueryFormatter(SQLAbstractUnformattedQueryFormatter anotherBuilder) {
        this(anotherBuilder.getProps());
        this.setForPlanning(anotherBuilder.forPlanning);
        this.buffer = new StringBuilder();
    }

    public void setForPlanning(boolean setting) {
        this.forPlanning = setting;
    }

    public boolean forPlanning() {
        return this.forPlanning;
    }

    public abstract QueryFormatter copyFormatter();

    public Properties getProps() {
        return this.builderProps;
    }

    @Override
    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setSelectKeywordIsAlreadyGenerated(boolean value) {
        this.selectKeywordIsAlreadyGenerated = value;
    }

    public boolean selectKeywordIsAlreadyGenerated() {
        return this.selectKeywordIsAlreadyGenerated;
    }

    protected SQLQueryText formatPattern(String pattern, SQLQueryText[] args) {
        SQLPatternFormatParser parser = new SQLPatternFormatParser();
        SQLQueryText result = parser.execute(pattern, args);
        return result;
    }

    protected SQLQueryText[] convertArgValues(Object[] values) {
        SQLQueryText[] sqlQueryTexts = new SQLQueryText[values.length];
        SQLQueryTextFactory factory = new SQLQueryTextFactory(false);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            SQLQueryText sqlQueryText = factory.getSqlQueryText();
            sqlQueryText.prependString(values[i].toString());
            sqlQueryTexts[i] = sqlQueryText;
        }
        return sqlQueryTexts;
    }

    protected String abstractFuncFormat(String pattern, Object[] values) {
        pattern = SQLAbstractFunction.refinePattern(pattern, values);
        return this.formatPattern(pattern, this.convertArgValues(values)).toString();
    }

    protected void addComment() {
        String comment;
        if (this.builderProps != null && null != (comment = this.builderProps.getProperty(PROPERTY_COMMENT))) {
            this.addText(comment);
        }
    }

    public void addFromKeyword() {
        this.addSpace();
        this.addText(KEYWORD_FROM);
        this.addSpace();
    }

    public void addSelectKeyword(String aDBHint) {
        this.addText(KEYWORD_SELECT);
        this.addSpace();
        if (aDBHint != null && !aDBHint.isEmpty()) {
            this.addText(aDBHint);
            this.addSpace();
        }
        this.setSelectKeywordIsAlreadyGenerated(true);
    }

    public void addOverKeyword() {
        this.addSpace();
        this.addText(KEYWORD_OVER);
    }

    public void addATKeyword() {
    }

    public void addOrderByKeyword() {
        this.addSpace();
        this.addText(KEYWORD_ORDER_BY);
        this.addSpace();
    }

    public void addPartitionByKeyword() {
        this.addSpace();
        this.addText(KEYWORD_PARTITION_BY);
        this.addSpace();
    }

    public void addCaseKeyword() {
        this.addText(KEYWORD_CASE);
        this.addSpace();
    }

    public void addWhenKeyword() {
        this.addSpace();
        this.addText(KEYWORD_WHEN);
        this.addSpace();
    }

    public void addThenKeyword() {
        this.addSpace();
        this.addText(KEYWORD_THEN);
        this.addSpace();
    }

    public void addElseKeyword() {
        this.addSpace();
        this.addText(KEYWORD_ELSE);
        this.addSpace();
    }

    public void addEndKeyword() {
        this.addSpace();
        this.addText(KEYWORD_END);
    }

    public void addCoalesceKeyword() {
        this.addText("COALESCE( ");
    }

    public void addFilterKeyword() {
        this.addSpace();
        this.addText(KEYWORD_FILTER);
        this.addSpace();
    }

    @Override
    public void addOpenParenthesis() {
        this.addSpace();
        this.addText("(");
        this.addSpace();
    }

    @Override
    public void addCloseParenthesis() {
        this.addSpace();
        this.addText(")");
        this.addSpace();
    }

    public void addAliasKeyword(IDataSourceCapabilities capabilities) {
        this.buffer.append(" ");
        String aliasKeyword = capabilities.getColumnAliasKeyword();
        if (aliasKeyword != null && aliasKeyword.length() != 0) {
            this.buffer.append(aliasKeyword);
            this.buffer.append(" ");
        }
    }

    @Override
    public String bufferToString() {
        if (this.buffer.length() == 0) {
            return null;
        }
        return this.buffer.toString();
    }

    @Override
    public String buildFormattedPatternForJoin(String pattern, String joinKeyword, int indentation) {
        return pattern;
    }

    @Override
    public String buildFormattedPatternForSetOperator(String pattern, String setOperatorName, int indentation) {
        return pattern;
    }

    @Override
    public String buildFormattedPatternForLogicalOperator(String pattern, String logicalOperatorName) {
        return pattern;
    }

    @Override
    public String buildFormattedPatternPercentile(String pattern, String percentileTypeName) {
        return pattern;
    }

    @Override
    public void addNewLineAndIndentation() {
        this.addSpace();
    }

    @Override
    public void increaseCurrentBlockIndentationLevel() {
    }

    @Override
    public void decreaseCurrentBlockIndentationLevel() {
    }

    @Override
    public void increaseCurrentNodeIndentationLevel() {
    }

    @Override
    public void decreaseCurrentNodeIndentationLevel() {
    }

    @Override
    public void setCurrentNodeIndentationLevel(int indentationLevel) {
    }

    public void setWithClauseGovernor(boolean setting) {
        this.useSQLWithCLause = setting;
    }

    public boolean getWithClauseGovernor() {
        return this.useSQLWithCLause;
    }

    private String[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities) {
        return this.dumpChildren(node, capabilities, node.getNumberChildren());
    }

    private String[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities, int nArgs) {
        return this.dumpChildren(node, capabilities, 0, nArgs);
    }

    private String[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities, int start, int nArgs) {
        int maxArgs = node.getMaximumChildren() - start;
        String[] argValues = new String[Math.max(nArgs - start, maxArgs)];
        int j = 0;
        for (int i = start; i < nArgs; ++i) {
            QueryFormatter tmpFormatter = this.copyFormatter();
            ((SQLQueryNode)node.getChild(i)).accept(tmpFormatter, capabilities);
            argValues[j++] = tmpFormatter.bufferToString();
        }
        while (j < maxArgs) {
            argValues[j++] = null;
        }
        return argValues;
    }

    private void dumpHints(SQLQueryNode node) {
        Map<String, Object> hints = node.getHints();
        if (hints == null || hints.isEmpty()) {
            return;
        }
        this.addSpace();
        this.addText("/*+ ");
        Iterator<Map.Entry<String, Object>> it = hints.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                this.addText(", ");
            }
            Map.Entry<String, Object> entry = it.next();
            this.addText(entry.getKey());
            this.addText("=");
            this.addText(entry.getValue());
            ++i;
        }
        this.addText(" +*/");
    }

    @Override
    public void visit(SQLAbstractFunction node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        if (node.getType() == 301026 && this.builderProps != null && this.builderProps.getProperty(XML_ESCAPE_CHARACTER) == TRUE) {
            pattern = XMLEscCharacter.escapeString(pattern);
        }
        Object[] argValues = this.dumpChildren(node, capabilities);
        if (pattern != null) {
            boolean bNeedWrap;
            boolean bl = bNeedWrap = node.getType() == 301026 && node.getParent().getType() == 301027 && ((SQLLogical)node.getParent()).getSubType() == SQLLogical.SubType.IS;
            if (bNeedWrap) {
                this.addText("(");
            }
            this.addText(SQLAbstractFunction.format(pattern, argValues));
            if (bNeedWrap) {
                this.addText(")");
            }
            this.dumpHints(node);
        } else {
            IFunction function = node.getFunction();
            if (function != null) {
                this.addText(function.getNativeName());
            } else {
                this.addText(node.getFunctionName());
            }
            this.addText("(");
            for (int i = 0; i < argValues.length; ++i) {
                if (i > 0) {
                    this.addText(", ");
                }
                this.addText((String)argValues[i]);
            }
            this.addText(")");
            this.addSpace();
        }
    }

    @Override
    public void visit(SQLAggregate node, IDataSourceCapabilities capabilities) {
        SQLAggregate.SubType aggrSubType;
        boolean isPercentile;
        int nChildren = node.getNumberChildren();
        String pattern = node.getPattern(capabilities);
        SQLQueryNode window = (SQLQueryNode)node.getFirstChildByType(301041);
        if (window != null) {
            --nChildren;
        }
        boolean bl = isPercentile = (aggrSubType = node.getSubType()).equals((Object)SQLAggregate.SubType.PERCENTILE_CONT) || aggrSubType.equals((Object)SQLAggregate.SubType.PERCENTILE_DISC);
        if (isPercentile) {
            pattern = this.buildFormattedPatternPercentile(pattern, aggrSubType.toString());
            this.increaseCurrentNodeIndentationLevel();
            this.increaseCurrentNodeIndentationLevel();
        }
        Object[] argValues = this.dumpChildren(node, capabilities, nChildren);
        String sqlStr = this.abstractFuncFormat(pattern, argValues);
        this.addText(sqlStr);
        if (isPercentile) {
            this.decreaseCurrentNodeIndentationLevel();
            this.decreaseCurrentNodeIndentationLevel();
        }
        if (window != null) {
            window.accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLArrayValueConstructor node, IDataSourceCapabilities capabilities) {
        this.addText("ARRAY");
        this.addText(OPEN_BRACKET);
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.addText(CLOSE_BRACKET);
    }

    @Override
    public void visit(SQLAlias node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addAliasKeyword(capabilities);
        StringBuilder builder = new StringBuilder();
        SQLIdentifier.delimitName(builder, node.getName(), capabilities.getColumnDelimiter(), this.forPlanning());
        this.addText(builder.toString());
    }

    @Override
    public void visit(SQLBetween node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLCall node, IDataSourceCapabilities capabilities) {
        this.addText(KEYWORD_CALL);
        this.visit((SQLIdentifier)node, capabilities);
        int nChildren = node.getNumberChildren();
        if (nChildren > 0) {
            this.addSpace();
            this.addText("(");
            this.increaseCurrentNodeIndentationLevel();
            for (int i = 0; i < nChildren; ++i) {
                if (i > 0) {
                    this.addText(", ");
                }
                this.addNewLineAndIndentation();
                ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
            }
            this.decreaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLCast node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        Object[] argValues = new Object[5];
        QueryFormatter tmpFormatter = this.copyFormatter();
        ((SQLQueryNode)node.getChild(0)).accept(tmpFormatter, capabilities);
        argValues[0] = tmpFormatter.bufferToString();
        argValues[1] = node.getDataType().getSQLText();
        argValues[2] = node.getDataType().hasPrecision() ? Integer.valueOf(node.getDataType().getPrecision()) : Integer.valueOf(0);
        argValues[3] = node.getDataType().hasScale() ? Integer.valueOf(node.getDataType().getScale()) : Integer.valueOf(0);
        String sqlStr = this.formatPattern(pattern, this.convertArgValues(argValues)).toString();
        this.addText(sqlStr);
    }

    @Override
    public void visit(SQLCoalesce node, IDataSourceCapabilities capabilities) {
        QueryFormatter tmpFormatter = this.copyFormatter();
        tmpFormatter.visit((SQLAbstractFunction)node, capabilities);
        this.addText(tmpFormatter.bufferToString());
    }

    @Override
    public void visit(SQLColumn node, IDataSourceCapabilities capabilities) {
        this.visit((SQLIdentifier)node, capabilities);
    }

    @Override
    public void visit(SQLColumnStar node, IDataSourceCapabilities capabilities) {
        String table = node.getTableName();
        if (table != null) {
            StringBuilder builder = new StringBuilder();
            SQLIdentifier.delimitName(builder, table, capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(builder.toString());
            this.addText(".");
        }
        this.addText("*");
    }

    @Override
    public void visit(SQLComparison node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLComputeBreak node, IDataSourceCapabilities capabilities) {
        this.addATKeyword();
        this.increaseCurrentNodeIndentationLevel();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            this.addNewLineAndIndentation();
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLCube node, IDataSourceCapabilities capabilities) {
        this.addText(node.getPattern(capabilities));
        this.addText("(");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.addText(")");
    }

    @Override
    public void visit(SQLDataType node, IDataSourceCapabilities capabilities) {
        this.addText(node.getDataType().getSQLText());
    }

    @Override
    public void visit(SQLFormat node, IDataSourceCapabilities capabilities) {
        this.addText("FORMAT");
        this.addSpace();
        this.addText("'");
        this.addText(node.getFormat());
        this.addText("'");
    }

    protected String getDBHintFromSQLRangeVarProperty(IXQEQueryNode node) {
        IXQEQueryNode rangeVar = node.getAncestorOfType(301007);
        if (rangeVar != null) {
            return (String)rangeVar.getPropertyValue("dbHint");
        }
        return null;
    }

    @Override
    public void visit(SQLDistinct node, IDataSourceCapabilities capabilities) {
        if (!this.selectKeywordIsAlreadyGenerated()) {
            String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
            this.addSelectKeyword(aDBHint);
        }
        this.addText(node.getPattern(capabilities));
        this.addSpace();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLElementRef node, IDataSourceCapabilities capabilities) {
        Object[] argValues = this.dumpChildren(node, capabilities, 2);
        String pattern = node.getPattern(capabilities);
        if (pattern == null) {
            pattern = "%s[%s]";
        }
        this.addText(String.format(pattern, argValues));
    }

    @Override
    public void visit(SQLExists node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLExtract node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLFieldRef node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addText(".");
        this.addText(node.getName());
    }

    @Override
    public void visit(SQLFid node, IDataSourceCapabilities capabilities) {
        if (node.getNumberChildren() > 0) {
            ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
            this.addText(".");
        }
        this.visit((SQLIdentifier)node, capabilities);
    }

    @Override
    public void visit(SQLFilter node, IDataSourceCapabilities capabilities) {
        if (node.getChild(0).getType() == 301016) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addSpace();
        node.getCognosSQL(capabilities, this);
    }

    @Override
    public void visit(SQLForSystemTime node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        Object[] argValues = this.dumpChildren(node, capabilities, 1, node.getNumberChildren());
        String pattern = node.getPattern(capabilities);
        String sqlStr = SQLAbstractFunction.format(pattern, argValues);
        this.addSpace();
        this.addText(sqlStr);
    }

    @Override
    public void visit(SQLFunction node, IDataSourceCapabilities capabilities) {
        String pattern = null;
        if (capabilities != null) {
            pattern = node.getPattern(capabilities);
        }
        int nArgs = node.getNumberChildren();
        SQLFunction.SubType subType = node.getSubType();
        if (this instanceof SQLAbstractFormattedQueryFormatter && (subType == SQLFunction.SubType.XMLQUERY || subType == SQLFunction.SubType.XMLEXISTS)) {
            this.addText(node.getFunctionName());
            this.addText("(");
            this.increaseCurrentBlockIndentationLevel();
            this.addNewLineAndIndentation();
            ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
            if (nArgs > 2 || nArgs > 1 && subType == SQLFunction.SubType.XMLEXISTS) {
                this.addNewLineAndIndentation();
                this.addText("PASSING ");
                ((SQLQueryNode)node.getChild(nArgs - 1)).accept(this, capabilities);
            }
            if (subType == SQLFunction.SubType.XMLQUERY) {
                this.addNewLineAndIndentation();
                ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
                this.decreaseCurrentBlockIndentationLevel();
            }
            this.decreaseCurrentBlockIndentationLevel();
            this.addNewLineAndIndentation();
            this.addText(")");
        } else if (nArgs > 0 || subType != SQLFunction.SubType.XMLATTRIBUTES && subType != SQLFunction.SubType.XMLNAMESPACES) {
            Object[] argValues = this.dumpChildren(node, capabilities);
            if (pattern != null) {
                String formattedPattern = pattern;
                String sqlStr = this.abstractFuncFormat(formattedPattern, argValues);
                this.addText(sqlStr);
            } else {
                if (node.isDBOnly()) {
                    IFunction function = node.getFunction();
                    if (function != null) {
                        if (function.isUDFunction()) {
                            this.addText(function.getMangledName());
                        } else {
                            this.addText(function.getNativeName());
                        }
                    } else {
                        String[] parts = node.parseFunctionName(node.getFunctionName());
                        if (parts.length > 1) {
                            StringBuilder builder = new StringBuilder();
                            node.delimitName(capabilities, builder, parts[parts.length - 2]);
                            this.addText(builder.toString());
                            this.addText(".");
                        }
                        this.addText(parts[parts.length - 1]);
                    }
                } else {
                    this.addText(node.getFunctionName());
                }
                this.addText("(");
                for (int i = 0; i < nArgs; ++i) {
                    if (i > 0) {
                        this.addText(", ");
                    }
                    this.addText((String)argValues[i]);
                }
                this.addText(")");
            }
        }
    }

    @Override
    public void visit(SQLGroupBy node, IDataSourceCapabilities capabilities) {
        SQLWindowList windowList;
        if (!this.selectKeywordIsAlreadyGenerated()) {
            String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
            this.addSelectKeyword(aDBHint);
        }
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
        this.addFromKeyword();
        SQLQueryNode firstChild = (SQLQueryNode)node.getChild(0);
        if (firstChild.getType() == 301016 || firstChild.getType() == 301092) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        firstChild.accept(this, capabilities);
        this.setCurrentNodeIndentationLevel(0);
        SQLGroupByList groupByList = node.getGroupByList();
        if (groupByList != null) {
            groupByList.accept(this, capabilities);
            this.setCurrentNodeIndentationLevel(0);
        }
        this.dumpHints(node);
        SQLHaving havingClause = node.getHavingClause();
        if (havingClause != null) {
            havingClause.accept(this, capabilities);
            this.setCurrentNodeIndentationLevel(0);
        }
        if ((windowList = node.getWindowList()) != null) {
            windowList.accept(this, capabilities);
            this.setCurrentNodeIndentationLevel(0);
        }
    }

    @Override
    public void visit(SQLGroupByList node, IDataSourceCapabilities capabilities) {
        this.addSpace();
        node.getCognosSQL(capabilities, this);
    }

    @Override
    public void visit(SQLGroupingSets node, IDataSourceCapabilities capabilities) {
        this.addText(node.getPattern(capabilities));
        this.addText("(");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            if (node.getChild(i).getType() == 301030) {
                this.addText("(");
                for (int j = 0; j < node.getChild(i).getNumberChildren(); ++j) {
                    if (j > 0) {
                        this.addText(", ");
                    }
                    ((SQLQueryNode)node.getChild(i).getChild(j)).accept(this, capabilities);
                }
                this.addText(")");
                continue;
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.addText(")");
    }

    @Override
    public void visit(SQLHaving node, IDataSourceCapabilities capabilities) {
        this.addNewLineAndIndentation();
        this.addSpace();
        this.addText(node.getPattern(capabilities));
        this.addSpace();
        this.increaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        node.getPredicate().accept(this, capabilities);
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLIdentifier node, IDataSourceCapabilities capabilities) {
        StringBuilder tableName;
        SQLPrettyPrintQueryFormatter sqlFormatter;
        String database = null;
        String catalog = node.getCatalogName();
        String schema = node.getSchemaName();
        if ("null".equals(schema) && !capabilities.isSupported(SUPPORTS_SCHEMAS_IN_DATA_MANIPULATION)) {
            schema = null;
        }
        String table = node.getTableName();
        String name = node.getName();
        String extDelimiter = null;
        if (this.builderProps != null) {
            extDelimiter = this.builderProps.getProperty(PREFERRED_DELIMITER);
        }
        String delimiter = capabilities.getIdentifierQuoteString();
        if (this instanceof SQLPrettyPrintQueryFormatter && (sqlFormatter = (SQLPrettyPrintQueryFormatter)this).getReportAsDatasource() && delimiter == null) {
            delimiter = "\"";
        }
        if (this.builderProps != null && this.builderProps.getProperty(PROPERTY_PRINT_DB_NAME) == TRUE) {
            database = node.getDatabaseName();
        }
        if (database != null) {
            StringBuilder databaseName = new StringBuilder();
            SQLIdentifier.delimitName(databaseName, database, this.getDelimiter(delimiter, extDelimiter), this.forPlanning());
            this.addText(databaseName.toString());
            this.addText(".");
        }
        if (catalog != null && !catalog.isEmpty()) {
            StringBuilder catalogName = new StringBuilder();
            SQLIdentifier.delimitName(catalogName, catalog, this.getDelimiter(capabilities.getCatalogDelimiter(), extDelimiter), this.forPlanning());
            this.addText(catalogName.toString());
            this.addText(capabilities.getCatalogSeparator());
        } else if (database != null) {
            this.addText(capabilities.getCatalogSeparator());
        }
        if (schema == null && node instanceof SQLRelation && !((SQLRelation)node).isWithClauseQueryRef()) {
            schema = node.getPlanningEnvironment().getDefaultSchema();
        }
        if (schema != null && !schema.isEmpty()) {
            StringBuilder schemaName = new StringBuilder();
            SQLIdentifier.delimitName(schemaName, schema, this.getDelimiter(capabilities.getSchemaDelimiter(), extDelimiter), this.forPlanning());
            this.addText(schemaName.toString());
            this.addText(".");
        } else if ((database != null || catalog != null && !catalog.isEmpty()) && capabilities.getBooleanValue(SUPPORTS_SCHEMAS_IN_DATA_MANIPULATION)) {
            this.addText(".");
        }
        if (table != null) {
            tableName = new StringBuilder();
            SQLIdentifier.delimitName(tableName, table, this.getDelimiter(capabilities.getTableDelimiter(), extDelimiter), this.forPlanning());
            this.addText(tableName.toString());
            this.addText(".");
        } else if ((database != null || catalog != null && !catalog.isEmpty() || schema != null && !schema.isEmpty()) && (node.getType() == 301005 || node.getType() == 301032)) {
            this.addText(".");
        }
        if (node.getType() == 301005 || node.getType() == 301032) {
            StringBuilder columnName = new StringBuilder();
            String[] identifierChain = node.getIdentifierChain();
            if (identifierChain != null) {
                for (int i = 0; i < identifierChain.length; ++i) {
                    if (identifierChain[i] == null) continue;
                    if (i > 0) {
                        columnName.append(".");
                    }
                    SQLIdentifier.delimitName(columnName, identifierChain[i], capabilities.getIdentifierQuoteString(), this.forPlanning());
                }
            } else {
                SQLIdentifier.delimitName(columnName, name, capabilities.getColumnDelimiter(), this.forPlanning());
            }
            this.addText(columnName.toString());
        } else if (node.getType() == 301033 && name.contains(".")) {
            StringBuilder packageName = new StringBuilder();
            StringBuilder functionName = new StringBuilder();
            String[] s = name.split("\\.");
            SQLIdentifier.delimitName(packageName, s[0], capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(packageName.toString());
            this.addText(".");
            SQLIdentifier.delimitName(functionName, s[1], capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(functionName.toString());
        } else {
            tableName = new StringBuilder();
            SQLIdentifier.delimitName(tableName, name, this.getDelimiter(capabilities.getTableDelimiter(), extDelimiter), this.forPlanning());
            this.addText(tableName.toString());
        }
    }

    private String getDelimiter(String delimiter, String extDelimiter) {
        if (extDelimiter != null) {
            return extDelimiter;
        }
        return delimiter;
    }

    @Override
    public void visit(SQLIn node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLIsDistinctFrom node, IDataSourceCapabilities capabilities) {
        boolean parentIsLogicalOperator;
        boolean bl = parentIsLogicalOperator = node.getParent().getType() == 301027;
        if (parentIsLogicalOperator) {
            this.addText("(");
        }
        this.visit((SQLAbstractFunction)node, capabilities);
        if (parentIsLogicalOperator) {
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLIsNull node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLJoin node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        if (node.getParent().getType() != 301011) {
            this.increaseCurrentNodeIndentationLevel();
        }
        Object[] argValues = this.dumpChildren(node, capabilities);
        String formattedPattern = this.buildFormattedPatternForJoin(pattern, node.getJoinType().joinName(), node.getJoinLevel());
        String sqlStr = this.formatPattern(formattedPattern, this.convertArgValues(argValues)).toString();
        if (node.getParent().getType() == 301011) {
            sqlStr = String.format("( %s )", sqlStr);
        }
        this.addText(sqlStr);
    }

    @Override
    public void visit(SQLLike node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLLateral node, IDataSourceCapabilities capabilities) {
        this.addText(KEYWORD_LATERAL);
    }

    @Override
    public void visit(SQLLiteral node, IDataSourceCapabilities capabilities) {
        Value value = node.getValue();
        if (value != null) {
            String subs = capabilities.getStringValue("SUBSTITUTE_PARAMETERS_WITH_SQLLITERAL", "");
            String literalQuoteEscape = capabilities.getLiteralQuoteEscape();
            boolean isQuotedText = false;
            if (value instanceof TextValue && literalQuoteEscape != null && !literalQuoteEscape.isEmpty()) {
                isQuotedText = true;
            }
            if (!subs.isEmpty()) {
                if (isQuotedText) {
                    this.addText(value.getSQLLiteral(literalQuoteEscape));
                } else {
                    this.addText(value.getSQLLiteral());
                }
                return;
            }
            String formatSpec = node.getAncestorOfType(301061) != null && capabilities.getStringValue("literals.format." + node.getDataType().getCapabilitiesKey() + STOREDPROCEDURE_CONTEXT, null) != null ? capabilities.getStringValue("literals.format." + node.getDataType().getCapabilitiesKey() + STOREDPROCEDURE_CONTEXT, null) : capabilities.getStringValue("literals.format." + node.getDataType().getCapabilitiesKey(), null);
            if (formatSpec != null) {
                if (formatSpec.trim().length() == 0) {
                    throw new XQERuntimeException(XQEMessageKeys.EXE_UnknownLiteralFormat, node.getDataType().getTypeName());
                }
                if (isQuotedText) {
                    this.addText(value.getFormattedLiteral(formatSpec, literalQuoteEscape));
                } else {
                    this.addText(value.getFormattedLiteral(formatSpec));
                }
            } else if (isQuotedText) {
                this.addText(value.getJDBCLiteral(literalQuoteEscape));
            } else {
                this.addText(value.getJDBCLiteral());
            }
        }
    }

    @Override
    public void visit(SQLLogical node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        Object[] argValues = this.dumpChildren(node, capabilities);
        SQLLogical.SubType subType = node.getSubType();
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301027 && (subType == SQLLogical.SubType.OR && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.AND || subType == SQLLogical.SubType.AND && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.OR)) {
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append("(");
            sBuffer.append(this.buildFormattedPatternForLogicalOperator(pattern, node.getFunctionName()));
            sBuffer.append(")");
            pattern = sBuffer.toString();
        } else {
            pattern = this.buildFormattedPatternForLogicalOperator(pattern, node.getFunctionName());
        }
        this.addText(this.formatPattern(pattern, this.convertArgValues(argValues)).toString());
    }

    @Override
    public void visit(SQLMultisetValueConstructor node, IDataSourceCapabilities capabilities) {
        this.addText("MULTISET( ");
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addText(")");
    }

    @Override
    public void visit(SQLNativeSql node, IDataSourceCapabilities capabilities) {
        String flag = capabilities.getStringValue(USE_NATIVE_SQL_SYNTAX, TRUE);
        if (flag == null || flag.equals(FALSE)) {
            this.addText(node.getSqlString());
        } else if (node.isPassThrough()) {
            this.addText("{{" + node.getSqlString() + "}}");
        } else {
            this.addText("{" + node.getSqlString() + "}");
        }
    }

    @Override
    public void visit(SQLNativeSQLValueExpression node, IDataSourceCapabilities capabilities) {
        if (this instanceof SQLAbstractFormattedQueryFormatter) {
            String flag = capabilities.getStringValue(USE_NATIVE_SQL_SYNTAX, TRUE);
            if (flag.equals(FALSE)) {
                this.addText(node.getSqlString());
            } else {
                this.addText("{" + node.getSqlString() + "}");
            }
        } else {
            this.addText(node.getSqlString());
        }
    }

    @Override
    public void visit(SQLNull node, IDataSourceCapabilities capabilities) {
        this.addText(KEYWORD_NULL);
    }

    @Override
    public void visit(SQLNullArgument node, IDataSourceCapabilities capabilities) {
    }

    @Override
    public void visit(SQLNullIf node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLOption node, IDataSourceCapabilities capabilities) {
        this.addText(node.getValue());
    }

    @Override
    public void visit(SQLOrdinal node, IDataSourceCapabilities capabilities) {
        this.addText(Integer.toString(node.getValue()));
    }

    @Override
    public void visit(SQLOverlaps node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLParameter node, IDataSourceCapabilities capabilities) {
        boolean useParamSQL = node.getUseParameterizedSQL();
        if (useParamSQL) {
            this.addText("?");
        } else {
            this.addText(String.format(":%s:", node.getName().replace(":", "::")));
        }
    }

    @Override
    public void visit(SQLParameterMapper node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLPartition node, IDataSourceCapabilities capabilities) {
        this.addPartitionByKeyword();
        this.increaseCurrentNodeIndentationLevel();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            this.addNewLineAndIndentation();
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLPeriodValueConstructor node, IDataSourceCapabilities capabilities) {
        this.addText("PERIOD(");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.addText(")");
    }

    @Override
    public void visit(SQLProduct node, IDataSourceCapabilities capabilities) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLProject node, IDataSourceCapabilities capabilities) {
        if (!this.selectKeywordIsAlreadyGenerated()) {
            String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
            this.addSelectKeyword(aDBHint);
        }
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
        this.addFromKeyword();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        int childType = child.getType();
        if (childType == 301016 || childType == 301092) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        child.accept(this, capabilities);
        if (node.getNumberChildren() > 2) {
            ((SQLQueryNode)node.getChild(2)).accept(this, capabilities);
        }
        if (childType == 301007) {
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    @Override
    public void visit(SQLQuantifier node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        Object[] argValues = this.dumpChildren(node, capabilities);
        if (pattern != null) {
            this.addText(this.formatPattern(pattern, this.convertArgValues(argValues)).toString());
        }
    }

    @Override
    public void visit(SQLQueryBlock node, IDataSourceCapabilities capabilities) {
        String cursorOptions;
        if (node.getName() != null) {
            node.openBlock(this);
        }
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        if (node.getName() != null) {
            node.closeBlock(capabilities, this, this.forPlanning());
        }
        if (!(!node.isForeign() || this.builderProps == null || this.builderProps.get(PROPERTY_NATIVESQL) != TRUE || node.getChild(0).getType() == 301012 && node.getChild(0).getBooleanPropertyValue("passthrough") != null && node.getChild(0).getBooleanPropertyValue("passthrough").booleanValue() || (cursorOptions = capabilities.getStringValue("general.cursorOptions", null)) == null || cursorOptions.isEmpty())) {
            this.addSpace();
            this.addText(cursorOptions);
        }
    }

    @Override
    public void visit(SQLRangeVar node, IDataSourceCapabilities capabilities) {
        SQLQueryNode parent = (SQLQueryNode)node.getParent();
        int parentType = parent.getType();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        int childType = child.getType();
        if (parentType == 301022 && this.getWithClauseGovernor()) {
            child.accept(this, capabilities);
            return;
        }
        if (childType == 301016 || childType == 301038) {
            child.accept(this, capabilities);
            if (parentType != 301092) {
                this.addSpace();
                StringBuilder tableName = new StringBuilder();
                SQLIdentifier.delimitName(tableName, node.getName(), capabilities.getTableDelimiter(), this.forPlanning());
                this.addText(tableName.toString());
            }
            return;
        }
        if (childType == 301092) {
            child.accept(this, capabilities);
            return;
        }
        if (child.getType() == 301080) {
            child.accept(this, capabilities);
        }
        if (node.isLateralDerivedTable()) {
            this.addText(KEYWORD_LATERAL);
            this.increaseCurrentBlockIndentationLevel();
        }
        if (child.getType() != 301080) {
            this.addText("(");
            this.addNewLineAndIndentation();
            child.accept(this, capabilities);
            this.addNewLineAndIndentation();
            this.addText(")");
        }
        if (node.isLateralDerivedTable()) {
            this.decreaseCurrentBlockIndentationLevel();
        }
        this.addSpace();
        StringBuilder tableName = new StringBuilder();
        SQLIdentifier.delimitName(tableName, node.getName(), capabilities.getTableDelimiter(), this.forPlanning());
        this.addText(tableName.toString());
        List<String> nameList = node.getDerivedColumnList();
        List<IDataType> types = node.getDerivedColumnTypes();
        if (nameList != null && !nameList.isEmpty()) {
            this.addText("(");
            for (int i = 0; i < nameList.size(); ++i) {
                if (i > 0) {
                    this.addText(", ");
                }
                StringBuilder columnName = new StringBuilder();
                SQLIdentifier.delimitName(columnName, nameList.get(i), capabilities.getColumnDelimiter(), this.forPlanning());
                this.addText(columnName.toString());
                if (types == null || types.get(i) == null) continue;
                this.addSpace();
                this.addText(types.get(i).getSQLText());
            }
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLRelation node, IDataSourceCapabilities capabilities) {
        this.visit((SQLIdentifier)node, capabilities);
        IPlanningEnvironment planEnv = node.getPlanningEnvironment();
        if (planEnv.isBigSQL() && !node.isWithClauseQueryRef() && capabilities.isSupported("supports.hints")) {
            SQLQueryBlock qBlock;
            StringBuilder sBuilder = new StringBuilder();
            SQLQueryItemList queryItems = node.getQueryItemList();
            int j = 0;
            for (int i = 0; i < queryItems.size(); ++i) {
                SQLQueryItem qItem = (SQLQueryItem)queryItems.get(i);
                if (!qItem.isReferenced()) continue;
                if (j++ > 0) {
                    sBuilder.append(",");
                }
                SQLIdentifier.delimitName(sBuilder, SQLIdentifier.escapeSingleQuotes(qItem.getName()), capabilities.getIdentifierQuoteString(), this.forPlanning());
            }
            Map<String, Object> hints = node.getHints();
            if (hints == null) {
                hints = new HashMap<String, Object>();
                node.setHints(hints);
            }
            if ((qBlock = (SQLQueryBlock)node.getAncestorOfType(301004)).isSimple()) {
                boolean keyFound = false;
                Set<String> keySet = hints.keySet();
                for (String key : keySet) {
                    if (!key.equalsIgnoreCase(ACCESS_MODE)) continue;
                    keyFound = true;
                    break;
                }
                if (!keyFound) {
                    hints.put(ACCESS_MODE, "'local'");
                }
            }
            String columnList = sBuilder.length() > 0 ? String.format("'%s'", sBuilder.toString()) : TWO_SINGLE_QUOTES;
            hints.put("Columns", columnList);
        } else if (capabilities.getBooleanValue("supports.hanaInputParameters")) {
            IXQEQueryNode[] parameters = node.getChildrenOfType(301051);
            StringBuilder sb = new StringBuilder();
            boolean comma = false;
            for (int i = 0; i < parameters.length; ++i) {
                SQLParameter p = (SQLParameter)parameters[i];
                if (p.getInValue() == null) continue;
                if (comma) {
                    sb.append(",");
                }
                String value = p.getInValue();
                value = value.replace("'", TWO_SINGLE_QUOTES);
                sb.append(String.format("'PLACEHOLDER'=('$$%s$$','%s')", p.getName(), value));
                comma = true;
            }
            if (sb.length() > 0) {
                sb.insert(0, "(");
                sb.append(")");
                this.addText(sb.toString());
            }
        }
        this.dumpHints(node);
    }

    @Override
    public void visit(SQLRollup node, IDataSourceCapabilities capabilities) {
        this.addText(node.getPattern(capabilities));
        this.addText("(");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.addText(")");
    }

    @Override
    public void visit(SQLRowValueConstructor node, IDataSourceCapabilities capabilities) {
        if (node.getParent().getType() != 301030) {
            this.addNewLineAndIndentation();
        }
        this.addText("(");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.addText(")");
    }

    @Override
    public void visit(SQLSearchedCase node, IDataSourceCapabilities capabilities) {
        int[] types = new int[]{301029, 301021, 301028, 301030, 301009};
        if (!node.isParentOfTypes(types)) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        this.addCaseKeyword();
        this.increaseCurrentNodeIndentationLevel();
        SQLValueList vList = (SQLValueList)node.getChild(0);
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            ((SQLQueryNode)vList.getChild(i)).accept(this, capabilities);
        }
        if (node.getNumberChildren() > 1) {
            this.addElseKeyword();
            ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
        this.addEndKeyword();
        if (!node.isParentOfTypes(types)) {
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    @Override
    public void visit(SQLSelect node, IDataSourceCapabilities capabilities) {
        String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
        this.addSelectKeyword(aDBHint);
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLSetOperator node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        String[] argValues = this.dumpChildren(node, capabilities);
        IXQEQueryNode parent = node.getParent();
        Boolean isNestedSetOperatorNode = false;
        if (parent.getType() == 301018 && node.getSubType().precedence() >= ((SQLSetOperator)parent).getSubType().precedence() && parent.getChild(1).equals(node)) {
            isNestedSetOperatorNode = true;
            this.addText("(");
            this.addNewLineAndIndentation();
        }
        String formattedPattern = this.buildFormattedPatternForSetOperator(pattern, node.getSetOperatorName(), node.getNestedLevel());
        Object[] twoArgs = new Object[2];
        twoArgs[0] = argValues[0];
        String sofar = null;
        for (int i = 1; i < argValues.length; ++i) {
            twoArgs[1] = argValues[i];
            sofar = String.format(formattedPattern, twoArgs);
            twoArgs[0] = sofar;
        }
        this.addText(sofar);
        if (isNestedSetOperatorNode.booleanValue()) {
            this.addNewLineAndIndentation();
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLSimilar node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLSimpleCase node, IDataSourceCapabilities capabilities) {
        int[] types = new int[]{301029, 301021, 301028, 301030, 301009};
        if (!node.isParentOfTypes(types)) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        this.addCaseKeyword();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.increaseCurrentNodeIndentationLevel();
        SQLValueList vList = (SQLValueList)node.getChild(1);
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            ((SQLQueryNode)vList.getChild(i)).accept(this, capabilities);
        }
        if (node.getNumberChildren() > 2) {
            this.addElseKeyword();
            ((SQLQueryNode)node.getChild(2)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
        this.addEndKeyword();
        if (!node.isParentOfTypes(types)) {
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    @Override
    public void visit(SQLSort node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addSpace();
        node.getCognosSQL(capabilities, this);
        this.dumpHints(node);
    }

    @Override
    public void visit(SQLSortKey node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        if (!node.isGenerated()) {
            if (node.isAscending()) {
                this.addText(KEYWORD_ASC);
            } else {
                this.addText(KEYWORD_DESC);
            }
            if (capabilities.isSupported("general.nullsOrdering") || node.getParent().getParent() != null && node.getParent().getParent().getNodeType() == 301041 && capabilities.isSupported("general.nullsOrderingInWindowSpecification")) {
                SQLSortKey.NullOrdering nullOrdering = node.getNullOrder();
                if (nullOrdering == SQLSortKey.NullOrdering.NULLS_FIRST) {
                    this.addText(KEYWORD_NULLS_FIRST);
                } else if (nullOrdering == SQLSortKey.NullOrdering.NULLS_LAST) {
                    this.addText(KEYWORD_NULLS_LAST);
                }
            }
        }
    }

    @Override
    public void visit(SQLSparqlQuery node, IDataSourceCapabilities capabilities) {
        String flag = capabilities.getStringValue(USE_NATIVE_SQL_SYNTAX, TRUE);
        if (flag == null || flag.equals(FALSE)) {
            this.addText(node.getQuery());
        } else {
            this.addText(String.format("SPARQL( %s )", node.getQuery()));
        }
    }

    @Override
    public void visit(SQLSortKeyList node, IDataSourceCapabilities capabilities) {
        this.increaseCurrentNodeIndentationLevel();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            this.addNewLineAndIndentation();
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLSubQuery node, IDataSourceCapabilities capabilities) {
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        this.increaseCurrentBlockIndentationLevel();
        boolean needParenthesis = true;
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301076) {
            needParenthesis = false;
        }
        if (needParenthesis) {
            this.addOpenParenthesis();
        }
        this.dumpHints(node);
        this.addSpace();
        child.accept(this, capabilities);
        if (needParenthesis) {
            this.addCloseParenthesis();
        }
        this.decreaseCurrentBlockIndentationLevel();
    }

    @Override
    public void visit(SQLSummaryFilter node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addFilterKeyword();
        this.increaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLTableFunction node, IDataSourceCapabilities capabilities) {
        if (node.getSubType() == SQLTableFunction.SubType.XMLTABLE || node.getSubType() == SQLTableFunction.SubType.JSON_TABLE) {
            RowType rowType = (RowType)node.getDataType();
            int nColumns = rowType.getNumberColumns();
            int nArgs = 0;
            for (int i = 0; i < node.getNumberChildren(); ++i) {
                IXQEQueryNode childNode = node.getChild(i);
                if (childNode instanceof SQLTableFunction && ((SQLTableFunction)childNode).getSubType() == SQLTableFunction.SubType.JSON_TABLE) {
                    nArgs += ((RowType)((SQLTableFunction)childNode).getDataType()).getNumberColumns();
                    continue;
                }
                ++nArgs;
            }
            int baseIndex = nArgs - nColumns;
            int numOfChilds = node.getNumberChildren() - baseIndex;
            if (node.getSubType() == SQLTableFunction.SubType.XMLTABLE) {
                this.addText("XMLTABLE");
                this.addText("(");
            } else if (!node.isNested()) {
                this.addText("JSON_TABLE");
                this.addText("(");
            }
            if (node.getSubType() == SQLTableFunction.SubType.XMLTABLE) {
                if (node.getChild(0).getType() != 301070) {
                    this.increaseCurrentBlockIndentationLevel();
                    this.addNewLineAndIndentation();
                    ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
                    this.addText(", ");
                    this.addNewLineAndIndentation();
                }
                this.increaseCurrentBlockIndentationLevel();
                this.addNewLineAndIndentation();
                ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
                this.addNewLineAndIndentation();
                if (baseIndex > 2) {
                    this.addText(KEYWORD_PASSING);
                    this.increaseCurrentBlockIndentationLevel();
                    ((SQLQueryNode)node.getChild(2)).accept(this, capabilities);
                    this.addNewLineAndIndentation();
                }
            } else {
                this.increaseCurrentBlockIndentationLevel();
                this.addNewLineAndIndentation();
                ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
                if (!node.isNested()) {
                    this.addText(",");
                    this.addNewLineAndIndentation();
                }
                if (!node.isNested()) {
                    this.addSpace();
                    ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
                    if (node.hasOnErrorPolicyBeenSet()) {
                        this.addSpace();
                        if (node.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                            this.addText(" ERROR ON ERROR ");
                        } else {
                            this.addText(" NULL ON ERROR ");
                        }
                    }
                }
                this.addNewLineAndIndentation();
            }
            this.addText("COLUMNS");
            if (node.getSubType() == SQLTableFunction.SubType.JSON_TABLE) {
                this.addText("(");
            }
            this.increaseCurrentBlockIndentationLevel();
            this.addNewLineAndIndentation();
            for (int i = 0; i < numOfChilds; ++i) {
                if (i > 0) {
                    this.addText(",");
                    this.addNewLineAndIndentation();
                }
                if (node.getChild(baseIndex + i) instanceof SQLTableFunction) {
                    this.addText("NESTED PATH ");
                    ((SQLTableFunction)node.getChild(baseIndex + i)).accept(this, capabilities);
                    continue;
                }
                String pattern = capabilities.getIdentifierQuoteString();
                if (pattern != null && pattern.length() != 0) {
                    this.addText(pattern);
                    this.addText(rowType.getFieldName(i));
                    this.addText(pattern);
                } else {
                    this.addText(rowType.getFieldName(i));
                }
                this.addSpace();
                SQLQueryNode currentChild = (SQLQueryNode)node.getChild(baseIndex + i);
                if (currentChild instanceof SQLLiteral && ((SQLLiteral)currentChild).getValue().toString().equalsIgnoreCase("FOR ORDINALITY")) {
                    this.addText(" FOR ORDINALITY");
                    continue;
                }
                this.addText(rowType.getFieldDataType(i).getSQLText());
                this.addText(" PATH ");
                currentChild.accept(this, capabilities);
            }
            if (node.getSubType() == SQLTableFunction.SubType.JSON_TABLE && !node.isNested()) {
                this.decreaseCurrentBlockIndentationLevel();
                this.addNewLineAndIndentation();
                this.addText(")");
            }
            this.decreaseCurrentBlockIndentationLevel();
            this.addNewLineAndIndentation();
            this.addText(")");
            if (node.isNested()) {
                this.decreaseCurrentBlockIndentationLevel();
            }
        } else {
            this.addText("TABLE");
            this.addText("(");
            this.addSpace();
            this.visit((SQLAbstractFunction)node, capabilities);
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLTableSample node, IDataSourceCapabilities capabilities) {
        SQLQueryNode firstChild = (SQLQueryNode)node.getChild(0);
        firstChild.accept(this, capabilities);
        ICorrelationName corrName = null;
        if (firstChild instanceof ICorrelationName) {
            corrName = (ICorrelationName)((Object)firstChild);
        } else {
            IXQEQueryNode corrNode = node.getParent();
            if (corrNode instanceof ICorrelationName) {
                corrName = (ICorrelationName)((Object)corrNode);
            }
        }
        boolean sampleBeforeAlias = SQLTableSample.isTableSampleBeforeAlias(capabilities);
        if (!sampleBeforeAlias && corrName != null) {
            this.addSpace();
            StringBuilder tableName = new StringBuilder();
            SQLIdentifier.delimitName(tableName, corrName.getCorrelationName(), capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(tableName.toString());
        }
        String pattern = node.getPattern(capabilities);
        Object[] argValues = this.dumpChildren(node, capabilities, 1, node.getNumberChildren());
        this.addSpace();
        this.addText(SQLAbstractFunction.format(pattern, argValues));
        if (sampleBeforeAlias && corrName != null) {
            this.addSpace();
            StringBuilder tableName = new StringBuilder();
            SQLIdentifier.delimitName(tableName, corrName.getCorrelationName(), capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(tableName.toString());
        }
    }

    @Override
    public void visit(SQLTableValueConstructor node, IDataSourceCapabilities capabilities) {
        this.addText("VALUES ");
        this.increaseCurrentBlockIndentationLevel();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.decreaseCurrentBlockIndentationLevel();
    }

    @Override
    public void visit(SQLTop node, IDataSourceCapabilities capabilities) {
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301019) {
            child = child.getChild(0);
        }
        if (!this.selectKeywordIsAlreadyGenerated() && child.getType() != 301018) {
            String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
            this.addSelectKeyword(aDBHint);
        }
        SQLQueryNode subTree = (SQLQueryNode)node.getChild(0);
        Value value = ((SQLLiteral)node.getChild(1)).getValue();
        int nRows = value.getInteger();
        String pattern = node.getPattern(capabilities);
        if (capabilities.getStringValue("clauses.Top.Position", "standard").contains("top")) {
            this.addSpace();
            if (subTree.getType() != 301018) {
                this.addText(String.format(pattern, nRows));
            }
            this.addSpace();
            subTree.accept(this, capabilities);
        } else {
            subTree.accept(this, capabilities);
            this.addSpace();
            this.addText(String.format(pattern, nRows));
        }
    }

    @Override
    public void visit(SQLTrim node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLUser node, IDataSourceCapabilities capabilities) {
        this.addText(node.getName());
    }

    @Override
    public void visit(SQLValueExpression node, IDataSourceCapabilities capabilities) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301025 && node.getSubType().precedence() >= ((SQLValueExpression)parent).getSubType().precedence()) {
            this.addText("(");
            this.visit((SQLAbstractFunction)node, capabilities);
            this.addText(")");
        } else {
            this.visit((SQLAbstractFunction)node, capabilities);
        }
    }

    @Override
    public void visit(SQLValueList node, IDataSourceCapabilities capabilities) {
        List<SQLAlias> aliasList = node.getAliasList();
        this.increaseCurrentNodeIndentationLevel();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            this.addNewLineAndIndentation();
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
            if (aliasList == null || aliasList.get(i) == null) continue;
            this.addAliasKeyword(capabilities);
            StringBuilder aliasName = new StringBuilder();
            SQLIdentifier.delimitName(aliasName, aliasList.get(i).getName(), capabilities.getColumnDelimiter(), this.forPlanning());
            this.addText(aliasName.toString());
        }
        this.decreaseCurrentNodeIndentationLevel();
        this.setSelectKeywordIsAlreadyGenerated(false);
    }

    @Override
    public void visit(SQLXid node, IDataSourceCapabilities capabilities) {
        if (node.getNumberChildren() > 0) {
            ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
            this.addText(".");
        }
        this.visit((SQLIdentifier)node, capabilities);
    }

    @Override
    public void visit(SQLWhen node, IDataSourceCapabilities capabilities) {
        this.addWhenKeyword();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addThenKeyword();
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLWindow node, IDataSourceCapabilities capabilities) {
        this.increaseCurrentNodeIndentationLevel();
        if (node.getParent().getType() != 301065) {
            this.addOverKeyword();
        }
        this.addText("(");
        if (node.getReferenceName() != null) {
            this.addSpaceAndText(node.getReferenceName());
        }
        this.increaseCurrentNodeIndentationLevel();
        IXQEQueryNode child = node.getComputeBreak();
        if (child != null) {
            ((SQLQueryNode)child).accept(this, capabilities);
        }
        if ((child = node.getPartitionBy()) != null) {
            ((SQLQueryNode)child).accept(this, capabilities);
        }
        if ((child = node.getOrderBy()) != null) {
            this.addOrderByKeyword();
            ((SQLQueryNode)child).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
        Integer lower = node.getWindowFrameLowerBound();
        if (lower != null) {
            int x;
            this.addNewLineAndIndentation();
            this.addSpaceAndText(node.getWindowFrameUnits());
            Integer upper = node.getWindowFrameUpperBound();
            if (upper != null) {
                this.addSpaceAndText("BETWEEN");
            }
            if (lower == Integer.MIN_VALUE) {
                this.addText(" UNBOUNDED");
                this.addText(" PRECEDING");
            } else {
                x = lower;
                if (x < 0) {
                    this.addSpaceAndText(Integer.toString(-x));
                    this.addText(" PRECEDING");
                } else if (x == 0) {
                    this.addText(" CURRENT ROW");
                } else {
                    this.addSpaceAndText(Integer.toString(x));
                    this.addText(" FOLLOWING");
                }
            }
            if (upper != null) {
                this.addSpaceAndText("AND");
                if (upper == Integer.MAX_VALUE) {
                    this.addText(" UNBOUNDED");
                    this.addText(" FOLLOWING");
                } else {
                    x = upper;
                    if (x < 0) {
                        this.addSpaceAndText(Integer.toString(-x));
                        this.addText(" PRECEDING");
                    } else if (x == 0) {
                        this.addText(" CURRENT ROW");
                    } else {
                        this.addSpaceAndText(Integer.toString(x));
                        this.addText(" FOLLOWING");
                    }
                }
            }
        }
        if (node.isSamplingScope() && capabilities.isSupported("supports.sqlserverWindowBehaviour")) {
            this.addText(" ORDER BY ( SELECT NULL ) ");
        }
        this.addNewLineAndIndentation();
        this.addText(")");
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLWindowList node, IDataSourceCapabilities capabilities) {
        this.addNewLineAndIndentation();
        this.addSpace();
        this.addText(node.getPattern(capabilities));
        this.addSpace();
        this.increaseCurrentNodeIndentationLevel();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            SQLWindow window = (SQLWindow)node.getChild(i);
            if (i > 0) {
                this.addText(", ");
            }
            this.addNewLineAndIndentation();
            this.addText(window.getName());
            this.addSpace();
            this.addText(KEYWORD_AS);
            this.addSpace();
            window.accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLWith node, IDataSourceCapabilities capabilities) {
        int nChildren = node.getNumberChildren();
        this.addNewLineAndIndentation();
        this.addText(KEYWORD_WITH);
        for (int i = 0; i < nChildren - 1; ++i) {
            List<String> nameList;
            String tableCommonExprName;
            SQLQueryNode child;
            if (i > 0) {
                this.addText(", ");
            }
            if ((child = (SQLQueryNode)node.getChild(i)).getType() == 301007) {
                tableCommonExprName = ((SQLRangeVar)child).getName();
                nameList = ((SQLRangeVar)child).getDerivedColumnList();
            } else {
                tableCommonExprName = ((SQLQueryBlock)child).getName();
                nameList = ((SQLQueryBlock)child).getDerivedColumnList();
            }
            this.addNewLineAndIndentation();
            StringBuilder tableName = new StringBuilder();
            SQLIdentifier.delimitName(tableName, tableCommonExprName, capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(tableName.toString());
            if (nameList != null && !nameList.isEmpty()) {
                this.addText("(");
                for (int j = 0; j < nameList.size(); ++j) {
                    if (j > 0) {
                        this.addText(", ");
                    }
                    StringBuilder columnName = new StringBuilder();
                    SQLIdentifier.delimitName(columnName, nameList.get(j), capabilities.getColumnDelimiter(), this.forPlanning());
                    this.addText(columnName.toString());
                }
                this.addText(")");
            }
            this.addSpace();
            this.addText(KEYWORD_AS);
            this.addSpace();
            this.increaseCurrentBlockIndentationLevel();
            this.addOpenParenthesis();
            child.accept(this, capabilities);
            this.addCloseParenthesis();
            this.decreaseCurrentBlockIndentationLevel();
        }
        ((SQLQueryNode)node.getChild(nChildren - 1)).accept(this, capabilities);
    }
}

