/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.util;

import com.cognos.xqe.ast.sql.util.SQLPatternFormatInstruction;
import com.cognos.xqe.ast.sql.util.SQLPatternFormatOpcode;
import com.cognos.xqe.ast.sql.util.SQLQueryText;
import com.cognos.xqe.ast.sql.util.SQLQueryTextFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLPatternFormatParser {
    private static final String BACKSLASH = "\\";
    private static final String LOWERCASE_N = "n";
    private static final String LOWERCASE_T = "t";
    private static final String UPPERCASE_T = "T";
    private static final String LOWERCASE_D = "d";
    private static final String LOWERCASE_S = "s";
    private static final String PERCENT = "%";
    private static final String DOUBLE_PERCENT = "%%";
    private static final String DOLLAR = "$";
    private static final String TOKEN_NEWLINE = "\\n";
    private static final String TOKEN_TAB_INCREMENT = "\\t";
    private static final String TOKEN_TAB_DECREMENT = "\\T";
    private static final String TOKEN_ARGUMENT_S = "%\\d\\$s";
    private static final String TOKEN_ARGUMENT_D = "%\\d\\$d";
    private static final String TOKEN_ARGUMENT_S_VALUES = "%\\d\\$s\\{.*\\}?";
    private static final int THREE = 3;
    private int baseIndentation;
    private int indentation;

    public SQLPatternFormatParser() {
        this.baseIndentation = 0;
        this.indentation = 0;
    }

    public SQLPatternFormatParser(int baseIndent) {
        this.baseIndentation = baseIndent;
        this.indentation = 0;
    }

    public SQLQueryText execute(String pattern, SQLQueryText[] arguments) {
        String temp = this.removePercentEscapeCharacters(pattern);
        List<SQLPatternFormatInstruction> listOfInstructions = this.getListOfInstructions(temp);
        return this.getSQLQueryText(listOfInstructions, arguments);
    }

    public SQLQueryText executeForJoin(String pattern, SQLQueryText[] arguments) {
        List<SQLPatternFormatInstruction> listOfInstructions = this.getListOfInstructions(pattern);
        return this.getSQLQueryTextForJoin(listOfInstructions, arguments);
    }

    private List<SQLPatternFormatInstruction> getListOfInstructions(String pattern) {
        ArrayList<SQLPatternFormatInstruction> listOfInstructions = new ArrayList<SQLPatternFormatInstruction>();
        String regex = "(\\\\[ntT])|(%\\d\\$[sd](\\{.*\\})?)";
        Pattern compiledPattern = Pattern.compile(regex);
        Matcher matcher = compiledPattern.matcher(pattern);
        boolean noMatchFound = true;
        int lastIndex = 0;
        while (matcher.find()) {
            noMatchFound = false;
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastIndex) {
                String text = pattern.substring(lastIndex, startIndex);
                SQLPatternFormatInstruction addTextInstruction = this.getAddTextInstruction(text);
                listOfInstructions.add(addTextInstruction);
            }
            String token = matcher.group();
            SQLPatternFormatInstruction tokenInstruction = this.getInstruction(token);
            listOfInstructions.add(tokenInstruction);
            lastIndex = endIndex;
        }
        if (lastIndex > 0 && lastIndex < pattern.length()) {
            String remainingText = pattern.substring(lastIndex);
            SQLPatternFormatInstruction addTextInstruction = this.getAddTextInstruction(remainingText);
            listOfInstructions.add(addTextInstruction);
        }
        if (noMatchFound) {
            listOfInstructions.add(this.getAddTextInstruction(pattern));
        }
        return listOfInstructions;
    }

    private SQLPatternFormatOpcode getOpcode(String token) {
        if (token.equals(TOKEN_NEWLINE)) {
            return SQLPatternFormatOpcode.ADD_NEWLINE;
        }
        if (token.equals(TOKEN_TAB_INCREMENT)) {
            return SQLPatternFormatOpcode.INDENT_INCREMENT;
        }
        if (token.equals(TOKEN_TAB_DECREMENT)) {
            return SQLPatternFormatOpcode.INDENT_DECRMENT;
        }
        if (token.matches(TOKEN_ARGUMENT_S) || token.matches(TOKEN_ARGUMENT_D)) {
            return SQLPatternFormatOpcode.ADD_ARGUMENT;
        }
        if (token.matches(TOKEN_ARGUMENT_S_VALUES)) {
            return SQLPatternFormatOpcode.ADD_ARGUMENT_FROM_VALUES;
        }
        return SQLPatternFormatOpcode.ADD_TEXT;
    }

    private String getArgumentNumber(String argument) {
        String argumentNumber = null;
        Integer percentIndex = null;
        Integer dollarIndex = null;
        char[] charArray = argument.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '%') {
                percentIndex = i;
            }
            if (charArray[i] != '$') continue;
            dollarIndex = i;
        }
        if (percentIndex != null && dollarIndex != null) {
            argumentNumber = argument.substring(percentIndex + 1, dollarIndex);
        }
        return argumentNumber;
    }

    private String[] getArgumentMap(String argument) {
        String mapStr = argument.substring(argument.indexOf("{") + 1, argument.indexOf("}"));
        String[] map = mapStr.split(",");
        return map;
    }

    private SQLPatternFormatInstruction getInstruction(String token) {
        SQLPatternFormatOpcode opcode = this.getOpcode(token);
        String value = null;
        String[] map = null;
        if (opcode.equals((Object)SQLPatternFormatOpcode.INDENT_INCREMENT) || opcode.equals((Object)SQLPatternFormatOpcode.INDENT_DECRMENT)) {
            value = "1";
        } else if (opcode.equals((Object)SQLPatternFormatOpcode.ADD_ARGUMENT) || opcode.equals((Object)SQLPatternFormatOpcode.ADD_ARGUMENT_FROM_VALUES)) {
            value = this.getArgumentNumber(token);
            if (opcode.equals((Object)SQLPatternFormatOpcode.ADD_ARGUMENT_FROM_VALUES)) {
                map = this.getArgumentMap(token);
            }
        }
        return new SQLPatternFormatInstruction(opcode, value, map);
    }

    private SQLPatternFormatInstruction getAddTextInstruction(String text) {
        SQLPatternFormatOpcode opcode = SQLPatternFormatOpcode.ADD_TEXT;
        return new SQLPatternFormatInstruction(opcode, text);
    }

    private SQLQueryText getSQLQueryText(List<SQLPatternFormatInstruction> listOfInstructions, SQLQueryText[] arguments) {
        SQLQueryText sqlQueryText = new SQLQueryTextFactory(true).getSqlQueryText();
        for (int i = 0; i < listOfInstructions.size(); ++i) {
            Integer argumentNumber;
            SQLQueryText argument;
            SQLPatternFormatInstruction instruction = listOfInstructions.get(i);
            SQLPatternFormatOpcode opcode = instruction.getOpcode();
            String value = instruction.getValue();
            if (opcode.equals((Object)SQLPatternFormatOpcode.ADD_NEWLINE)) {
                if (sqlQueryText.getNumberOfLines() == 0) {
                    sqlQueryText.addLine();
                }
                sqlQueryText.addLine();
                sqlQueryText.getLastLine().setIndentLevelLine(this.indentation);
                continue;
            }
            if (opcode.equals((Object)SQLPatternFormatOpcode.INDENT_INCREMENT)) {
                ++this.indentation;
                continue;
            }
            if (opcode.equals((Object)SQLPatternFormatOpcode.INDENT_DECRMENT)) {
                --this.indentation;
                continue;
            }
            if (opcode.equals((Object)SQLPatternFormatOpcode.ADD_TEXT)) {
                sqlQueryText.appendString(value);
                continue;
            }
            if (opcode.equals((Object)SQLPatternFormatOpcode.ADD_ARGUMENT)) {
                if (arguments == null || (argument = arguments[(argumentNumber = Integer.valueOf(value)) - 1]) == null) continue;
                if ((argument = argument.copy()).getNumberOfLines() > 1) {
                    sqlQueryText.addTextButAppendFirstLine(this.indentation, argument);
                    continue;
                }
                sqlQueryText.appendString(argument.toString());
                continue;
            }
            if (!opcode.equals((Object)SQLPatternFormatOpcode.ADD_ARGUMENT_FROM_VALUES) || arguments == null || (argument = arguments[(argumentNumber = Integer.valueOf(value)) - 1]) == null) continue;
            String[] map = instruction.getValueMap();
            int index = Integer.valueOf(argument.toString());
            sqlQueryText.appendString(map[index]);
        }
        return sqlQueryText;
    }

    private SQLQueryText getSQLQueryTextForJoin(List<SQLPatternFormatInstruction> listOfInstructions, SQLQueryText[] arguments) {
        SQLQueryText sqlQueryText = new SQLQueryTextFactory(true).getSqlQueryText();
        for (int i = 0; i < listOfInstructions.size(); ++i) {
            SQLPatternFormatInstruction instruction = listOfInstructions.get(i);
            SQLPatternFormatOpcode opcode = instruction.getOpcode();
            String value = instruction.getValue();
            if (opcode.equals((Object)SQLPatternFormatOpcode.ADD_NEWLINE)) {
                if (sqlQueryText.getNumberOfLines() == 0) {
                    sqlQueryText.addLine();
                }
                sqlQueryText.addLine();
                sqlQueryText.getLastLine().setIndentLevelLine(this.baseIndentation + this.indentation);
                continue;
            }
            if (opcode.equals((Object)SQLPatternFormatOpcode.INDENT_INCREMENT)) {
                ++this.indentation;
                continue;
            }
            if (opcode.equals((Object)SQLPatternFormatOpcode.INDENT_DECRMENT)) {
                --this.indentation;
                continue;
            }
            if (opcode.equals((Object)SQLPatternFormatOpcode.ADD_TEXT)) {
                sqlQueryText.appendString(value);
                continue;
            }
            if (!opcode.equals((Object)SQLPatternFormatOpcode.ADD_ARGUMENT) || arguments == null) continue;
            int argumentNumber = Integer.valueOf(value);
            SQLQueryText argument = arguments[argumentNumber - 1];
            argument = argument.copy();
            if (argumentNumber == 1) {
                sqlQueryText.addText(0, argument);
                continue;
            }
            if (argumentNumber == 2) {
                if (argument.getNumberOfLines() > 1) {
                    sqlQueryText.addText(this.baseIndentation + this.indentation, argument);
                    continue;
                }
                sqlQueryText.appendString(argument.toString());
                continue;
            }
            if (argumentNumber != 3) continue;
            if (argument.getNumberOfLines() > 1) {
                ++this.indentation;
                sqlQueryText.addText(this.baseIndentation + this.indentation, argument);
                --this.indentation;
                continue;
            }
            sqlQueryText.appendString(argument.toString());
        }
        return sqlQueryText;
    }

    public String replaceTokensWithSpaces(String formattedPattern) {
        StringBuilder unformattedPattern = new StringBuilder();
        String regex = "(\\\\[ntT])+";
        Pattern compiledPattern = Pattern.compile(regex);
        Matcher matcher = compiledPattern.matcher(formattedPattern);
        boolean noMatchFound = true;
        int lastIndex = 0;
        while (matcher.find()) {
            noMatchFound = false;
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastIndex) {
                String text = formattedPattern.substring(lastIndex, startIndex);
                unformattedPattern.append(text);
            }
            unformattedPattern.append(" ");
            lastIndex = endIndex;
        }
        if (lastIndex > 0 && lastIndex < formattedPattern.length()) {
            String remainingText = formattedPattern.substring(lastIndex);
            unformattedPattern.append(remainingText);
        }
        if (noMatchFound) {
            unformattedPattern.append(formattedPattern);
        }
        return unformattedPattern.toString();
    }

    private String removePercentEscapeCharacters(String pattern) {
        return pattern.replaceAll(DOUBLE_PERCENT, PERCENT);
    }
}

