/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLCoalesce;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLDistinct;
import com.cognos.xqe.ast.sql.SQLExists;
import com.cognos.xqe.ast.sql.SQLExtract;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLFormat;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLateral;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLNullIf;
import com.cognos.xqe.ast.sql.SQLOverlaps;
import com.cognos.xqe.ast.sql.SQLPeriodPredicate;
import com.cognos.xqe.ast.sql.SQLProduct;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLSelect;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLSimilar;
import com.cognos.xqe.ast.sql.SQLSimpleCase;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLSparqlQuery;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLTrim;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.sql.SQLWindowList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.ast.sql.util.SQLAbstractFormattedQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLPatternFormatParser;
import com.cognos.xqe.ast.sql.util.SQLQueryLine;
import com.cognos.xqe.ast.sql.util.SQLQueryText;
import com.cognos.xqe.ast.sql.util.SQLQueryTextFactory;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.SQLCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class SQLPrettyPrintQueryFormatter
extends SQLAbstractFormattedQueryFormatter {
    public static final String SPACE_IS_SPACE = " IS ";
    public static final String SPACE_ESCAPE_SPACE = " ESCAPE ";
    public static final String DISTINCT = "DISTINCT";
    public static final String ZERO = "0";
    protected SQLQueryText textBlock;
    private boolean reportAsDatasource = false;
    private static HashMap<String, String> formattedPattern = SQLPrettyPrintQueryFormatter.loadFormattedPattern();
    protected SQLQueryTextFactory factory;

    private static HashMap<String, String> loadFormattedPattern() {
        HashMap<String, String> map = new HashMap<String, String>();
        String key = null;
        String value = null;
        key = "%1$s UNION %2$s";
        value = "%1$s\\n\\nUNION\\n\\n%2$s";
        map.put(key, value);
        key = "%1$s UNION ALL %2$s";
        value = "%1$s\\n\\nUNION ALL\\n\\n%2$s";
        map.put(key, value);
        key = "%1$s INTERSECT %2$s";
        value = "%1$s\\n\\nINTERSECT\\n\\n%2$s";
        map.put(key, value);
        key = "%1$s INTERSECT ALL %2$s";
        value = "%1$s\\n\\nINTERSECT ALL\\n\\n%2$s";
        map.put(key, value);
        key = "%1$s EXCEPT %2$s";
        value = "%1$s\\n\\nEXCEPT\\n\\n%2$s";
        map.put(key, value);
        key = "%1$s EXCEPT ALL %2$s";
        value = "%1$s\\n\\nEXCEPT ALL\\n\\n%2$s";
        map.put(key, value);
        key = "%1$s CROSS JOIN %2$s";
        value = "%1$s\\t\\nCROSS JOIN %2$s";
        map.put(key, value);
        key = "%1$s INNER JOIN %2$s ON %3$s";
        value = "%1$s\\t\\nINNER JOIN %2$s\\nON %3$s";
        map.put(key, value);
        key = "%1$s LEFT OUTER JOIN %2$s ON %3$s";
        value = "%1$s\\t\\nLEFT OUTER JOIN %2$s\\nON %3$s";
        map.put(key, value);
        key = "%1$s RIGHT OUTER JOIN %2$s ON %3$s";
        value = "%1$s\\t\\nRIGHT OUTER JOIN %2$s\\nON %3$s";
        map.put(key, value);
        key = "%1$s FULL OUTER JOIN %2$s ON %3$s";
        value = "%1$s\\t\\nFULL OUTER JOIN %2$s\\nON %3$s";
        map.put(key, value);
        key = "%1$s AND %2$s";
        value = "%1$s AND\\n%2$s";
        map.put(key, value);
        key = "%1$s OR %2$s";
        value = "%1$s OR\\n%2$s";
        map.put(key, value);
        key = "PERCENTILE_CONT(%1$s) WITHIN GROUP (ORDER BY %2$s)";
        value = "PERCENTILE_CONT(%1$s)\\t\\nWITHIN GROUP(\\t\\nORDER BY\\t\\n%2$s\\T\\T\\n)";
        map.put(key, value);
        key = "PERCENTILE_DISC(%1$s) WITHIN GROUP (ORDER BY %2$s)";
        value = "PERCENTILE_DISC(%1$s)\\t\\nWITHIN GROUP(\\t\\nORDER BY\\t\\n%2$s\\T\\T\\n)";
        map.put(key, value);
        key = "%1$s IN ( %2$s )";
        value = "%1$s IN ( \\t\\n%2$s )";
        map.put(key, value);
        key = "COALESCE(%1$s)";
        value = "COALESCE(\\t\\n%1$s)";
        map.put(key, value);
        key = "XMLEXISTS(%1$s PASSING %2$s)";
        value = "XMLEXISTS(\\t\\n%1$s\\nPASSING %2$s\\T\\n)";
        map.put(key, value);
        key = "XMLQUERY(%1$s PASSING %3$s %2$s)";
        value = "XMLQUERY(\\t\\n%1$s\\nPASSING %3$s\\n%2$s\\T\\n)";
        map.put(key, value);
        key = "XMLELEMENT(NAME %1$s, %5$s)";
        value = "XMLELEMENT(\\t\\nNAME %1$s,\\n%5$s\\T\\n)";
        map.put(key, value);
        key = "XMLELEMENT(NAME %1$s, %2$s, %5$s)";
        value = "XMLELEMENT(\\t\\nNAME %1$s,\\n%2$s,\\n%5$s\\T\\n)";
        map.put(key, value);
        key = "XMLELEMENT(NAME %1$s, %2$s, %3$s, %5$s)";
        value = "XMLELEMENT(\\t\\nNAME %1$s,\\n%2$s,\\n%3$s\\n,\\n%5$s\\T\\n)";
        map.put(key, value);
        key = "XMLELEMENT(NAME %1$s, %5$s OPTION %4$s)";
        value = "XMLELEMENT(\\t\\nNAME %1$s,\\n%5$s\\nOPTION %4$s\\T\\n)";
        map.put(key, value);
        key = "XMLELEMENT(NAME %1$s, %2$s, %5$s OPTION %4$s)";
        value = "XMLELEMENT(\\t\\nNAME %1$s,\\n%2$s,\\n%5$s\\nOPTION %4$s\\T\\n)";
        map.put(key, value);
        key = "XMLELEMENT(NAME %1$s, %2$s, %3$s, %5$s OPTION %4$s)";
        value = "XMLELEMENT(\\t\\nNAME %1$s,\\n%2$s,\\n%3$s\\n,\\n%5$s\\nOPTION %4$s\\T\\n)";
        map.put(key, value);
        key = "XMLFOREST(%2$s)";
        value = "XMLFOREST(\\t\\n%2$s\\T\\n)";
        map.put(key, value);
        key = "XMLFOREST(%1$s, %2$s)";
        value = "XMLFOREST(\\t\\n%1$s,\\n%2$s\\n)";
        map.put(key, value);
        key = "XMLAGG(%1$s ORDER BY %2$s)";
        value = "XMLAGG(\\t\\n%1$s\\nORDER BY %2$s\\T\\n)";
        map.put(key, value);
        key = "JSON_ARRAY(%2$s)";
        value = "JSON_ARRAY(\\t\\n%2$s\\T\\n)";
        map.put(key, value);
        key = "JSON_ARRAY(%1$s %2$s)";
        value = "JSON_ARRAY(\\t\\n%2$s \\n%1$s\\n)";
        map.put(key, value);
        key = "JSON_ARRAYAGG(%1$s ORDER BY %2$s)";
        value = "JSON_ARRAYAGG(\\t\\n%1$s\\nORDER BY %2$s\\T\\n)";
        map.put(key, value);
        key = "JSON_OBJECT(%2$s)";
        value = "JSON_OBJECT(\\t\\n%2$s\\T\\n)";
        map.put(key, value);
        key = "JSON_OBJECT(%1$s %2$s)";
        value = "JSON_OBJECT(\\t\\n%2$s \\n%1$s\\n)";
        map.put(key, value);
        return map;
    }

    protected String getFormattedPattern(String pattern) {
        String format = formattedPattern.get(pattern);
        if (format != null) {
            return format;
        }
        return pattern;
    }

    public SQLPrettyPrintQueryFormatter() {
        if (this.factory == null) {
            this.factory = new SQLQueryTextFactory(true);
        }
        this.textBlock = this.factory.getSqlQueryText();
    }

    public SQLPrettyPrintQueryFormatter(Properties props) {
        super(props);
    }

    private SQLPrettyPrintQueryFormatter(SQLPrettyPrintQueryFormatter anotherFormatter) {
        super(anotherFormatter.getProps());
        this.textBlock = this.factory.getSqlQueryText();
        this.setWithClauseGovernor(anotherFormatter.getWithClauseGovernor());
        this.setForPlanning(anotherFormatter.forPlanning());
        this.reportAsDatasource = anotherFormatter.getReportAsDatasource();
    }

    @Override
    public QueryFormatter copyFormatter() {
        return new SQLPrettyPrintQueryFormatter(this);
    }

    public SQLQueryText getTextBlock() {
        return this.textBlock;
    }

    @Override
    protected void addComment() {
        if (this.factory == null) {
            this.factory = new SQLQueryTextFactory(true);
        }
        this.textBlock = this.factory.getSqlQueryText();
        String comment = this.builderProps.getProperty("comment");
        if (null != comment) {
            this.addText(comment);
            this.textBlock.addLine();
        }
    }

    @Override
    public void addText(String text) {
        this.textBlock.appendString(text);
    }

    public void addTextBlock(SQLQueryText text) {
        this.textBlock.addText(this.getTotalIndentation(), text);
    }

    public void addTextButAppendFirstLine(SQLQueryText text) {
        this.textBlock.addTextButAppendFirstLine(this.getTotalIndentation(), text);
    }

    @Override
    public void addSpaceAndText(String text) {
        this.textBlock.appendString(" ");
        this.textBlock.appendString(text);
    }

    @Override
    public void addSpace() {
        this.textBlock.appendString(" ");
    }

    protected int getTotalIndentation() {
        return this.getCurrentNodeIndentationLevel() + this.getCurrentBlockIndentationLevel();
    }

    private void addNativePassThroughSQL(String sql) {
        this.textBlock.appendString(sql);
        this.textBlock.getLastLine().setIsNativeSQL(true);
    }

    @Override
    public void addNewLineAndIndentation() {
        this.textBlock.addLine();
        this.textBlock.getLastLine().setIndentLevelLine(this.getTotalIndentation());
    }

    public void addAsKeyword() {
        this.textBlock.appendString(" ");
        this.textBlock.appendString("AS");
        this.textBlock.appendString(" ");
    }

    @Override
    public void addAliasKeyword(IDataSourceCapabilities capabilities) {
        this.textBlock.appendString(" ");
        this.textBlock.appendString("AS");
        this.textBlock.appendString(" ");
    }

    @Override
    public void addSelectKeyword(String aDBHint) {
        this.addText("SELECT");
        if (aDBHint != null && !aDBHint.isEmpty()) {
            this.addSpace();
            this.addText(aDBHint);
        }
        this.setSelectKeywordIsAlreadyGenerated(true);
    }

    public void setReportAsDatasource(boolean setting) {
        this.reportAsDatasource = setting;
    }

    public boolean getReportAsDatasource() {
        return this.reportAsDatasource;
    }

    private SQLQueryText[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities) {
        return this.dumpChildren(node, capabilities, node.getNumberChildren());
    }

    private SQLQueryText[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities, int nArgs) {
        SQLQueryText[] argValues = new SQLQueryText[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            SQLQueryNode child = (SQLQueryNode)node.getChild(i);
            if (child.getType() == 301070) {
                argValues[i] = null;
                continue;
            }
            SQLPrettyPrintQueryFormatter tmpFormatter = new SQLPrettyPrintQueryFormatter(this);
            child.accept(tmpFormatter, capabilities);
            argValues[i] = tmpFormatter.textBlock;
        }
        return argValues;
    }

    public SQLQueryText buildFormattedPatternForJoin(String pattern, SQLQueryText[] args, int indentation) {
        String format = this.getFormattedPattern(pattern);
        SQLPatternFormatParser parser = new SQLPatternFormatParser(indentation);
        SQLQueryText result = parser.executeForJoin(format, args);
        return result;
    }

    public SQLQueryText buildFormattedPatternForSetOperator(String pattern, SQLQueryText[] args, int indentation) {
        String format = this.getFormattedPattern(pattern);
        return this.formatPattern(format, args);
    }

    public SQLQueryText buildFormattedPatternForLogicalOperator(String pattern, SQLQueryText[] args) {
        String format = this.getFormattedPattern(pattern);
        return this.formatPattern(format, args);
    }

    public SQLQueryText buildFormattedPatternForLogicalNOTOperator(String pattern, SQLQueryText[] args, String logicalOperatorName) {
        SQLQueryText firstArg = args[0];
        SQLPrettyPrintQueryFormatter tmpFormatter = new SQLPrettyPrintQueryFormatter(this);
        tmpFormatter.addText(logicalOperatorName.toUpperCase());
        tmpFormatter.addSpace();
        tmpFormatter.addText("(");
        tmpFormatter.addSpace();
        tmpFormatter.addTextButAppendFirstLine(firstArg);
        tmpFormatter.addSpace();
        tmpFormatter.addText(")");
        return tmpFormatter.textBlock;
    }

    @Override
    public void visit(SQLAggregate node, IDataSourceCapabilities capabilities) {
        int nChildren = node.getNumberChildren();
        String pattern = node.getPattern(capabilities);
        SQLQueryNode window = (SQLQueryNode)node.getFirstChildByType(301041);
        if (window != null) {
            --nChildren;
        }
        Object[] argValues = this.dumpChildren(node, capabilities, nChildren);
        SQLAggregate.SubType aggrSubType = node.getSubType();
        if (pattern != null) {
            String format = SQLAbstractFunction.refinePattern(this.getFormattedPattern(pattern), argValues);
            SQLQueryText formattedText = this.formatPattern(format, (SQLQueryText[])argValues);
            this.addTextButAppendFirstLine(formattedText);
        } else {
            SQLPrettyPrintQueryFormatter tmpFormatter = new SQLPrettyPrintQueryFormatter(this);
            tmpFormatter.addText(aggrSubType.toString());
            tmpFormatter.addText("(");
            if (node.isDistinct()) {
                tmpFormatter.addText(DISTINCT);
                tmpFormatter.addSpace();
            }
            for (int i = 0; i < nChildren; ++i) {
                if (i > 0) {
                    tmpFormatter.addText(",");
                }
                if (((SQLQueryText)argValues[i]).getNumberOfLines() == 1) {
                    tmpFormatter.addText(((SQLQueryText)argValues[i]).toString());
                    continue;
                }
                if (node.getChild(i).getNodeType() == 301073 || node.getChild(i).getNodeType() == 301074) {
                    tmpFormatter.getTextBlock().addText(tmpFormatter.getTotalIndentation(), (SQLQueryText)argValues[i]);
                    continue;
                }
                tmpFormatter.addTextButAppendFirstLine((SQLQueryText)argValues[i]);
            }
            tmpFormatter.addText(")");
            this.addTextButAppendFirstLine(tmpFormatter.textBlock);
        }
        if (window != null) {
            window.accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLBetween node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLCast node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        Object[] argValues = new SQLQueryText[5];
        SQLPrettyPrintQueryFormatter tmpFormatter = new SQLPrettyPrintQueryFormatter(this);
        ((SQLQueryNode)node.getChild(0)).accept(tmpFormatter, capabilities);
        argValues[0] = tmpFormatter.getTextBlock();
        SQLQueryText arg1 = this.factory.getSqlQueryText();
        arg1.appendString(node.getDataType().getSQLText());
        argValues[1] = arg1;
        int precision = 0;
        boolean hasPrecisionValue = true;
        if (node.getDataType().isInterval()) {
            if (((IntervalType)node.getDataType()).hasLeadingPrecision()) {
                precision = ((IntervalType)node.getDataType()).getLeadingPrecision();
            } else {
                hasPrecisionValue = false;
            }
        } else if (node.getDataType().hasPrecision()) {
            precision = node.getDataType().getPrecision();
        }
        if (hasPrecisionValue) {
            SQLQueryText arg2 = this.factory.getSqlQueryText();
            arg2.appendString(new Integer(precision).toString());
            argValues[2] = arg2;
        }
        int scale = 0;
        if (node.getDataType().hasScale()) {
            scale = node.getDataType().getScale();
        }
        SQLQueryText arg3 = this.factory.getSqlQueryText();
        arg3.appendString(Integer.toString(scale));
        argValues[3] = arg3;
        IXQEQueryNode sqlFormatNode = node.getFirstChildByType(301097);
        if (sqlFormatNode != null) {
            tmpFormatter = new SQLPrettyPrintQueryFormatter(this);
            ((SQLFormat)sqlFormatNode).accept(tmpFormatter, capabilities);
            argValues[4] = tmpFormatter.getTextBlock();
        }
        if (node.hasOnErrorPolicyBeenSet()) {
            SQLQueryText errorText;
            SQLQueryText sqlFormatText = argValues[4];
            if (sqlFormatText == null) {
                errorText = new SQLQueryTextFactory(false).getSqlQueryText();
            } else {
                errorText = sqlFormatText;
                errorText.appendString(" ");
            }
            if (node.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                errorText.appendString("ERROR ON ERROR");
            } else {
                errorText.appendString("NULL ON ERROR");
            }
            argValues[4] = errorText;
        }
        pattern = SQLAbstractFunction.refinePattern(pattern, argValues);
        SQLQueryText formattedText = this.formatPattern(pattern, (SQLQueryText[])argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLCoalesce node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        String format = this.getFormattedPattern(pattern);
        SQLQueryText formattedText = this.formatPattern(format, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLComparison node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        if (null == pattern) {
            for (SQLQueryText argValue : argValues) {
                this.addTextButAppendFirstLine(argValue);
            }
        } else {
            SQLQueryText formattedText = this.formatPattern(pattern, argValues);
            this.addTextButAppendFirstLine(formattedText);
        }
    }

    @Override
    public void visit(SQLDistinct node, IDataSourceCapabilities capabilities) {
        if (!this.selectKeywordIsAlreadyGenerated()) {
            String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
            this.addSelectKeyword(aDBHint);
        }
        this.addSpace();
        this.addText(DISTINCT);
        this.addSpace();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLExists node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLExtract node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLFilter node, IDataSourceCapabilities capabilities) {
        SQLQueryNode firstChild = (SQLQueryNode)node.getChild(0);
        firstChild.accept(this, capabilities);
        this.addSpace();
        if (firstChild.getType() == 301009) {
            this.addText("AND");
        } else {
            this.decreaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
            this.addText("WHERE");
            this.addSpace();
            this.increaseCurrentNodeIndentationLevel();
        }
        this.addNewLineAndIndentation();
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLFunction node, IDataSourceCapabilities capabilities) {
        String pattern = null;
        if (capabilities != null) {
            pattern = node.getPattern(capabilities);
        }
        int nArgs = node.getNumberChildren();
        Object[] argValues = this.dumpChildren(node, capabilities);
        if (pattern != null) {
            String format = this.getFormattedPattern(SQLAbstractFunction.refinePattern(pattern, argValues));
            SQLQueryText output = this.formatPattern(format, (SQLQueryText[])argValues);
            this.addTextButAppendFirstLine(output);
        } else {
            String functionName;
            if (node.isDBOnly()) {
                SQLFunction id = node;
                if (id.getSchemaName() != null || id.getCatalogName() != null) {
                    this.visit((SQLIdentifier)id, capabilities);
                } else {
                    String[] parts = node.parseFunctionName(node.getFunctionName());
                    for (int length = parts.length; length > 1; --length) {
                        StringBuilder builder = new StringBuilder();
                        node.delimitName(capabilities, builder, parts[parts.length - length]);
                        this.addText(builder.toString());
                        this.addText(".");
                    }
                    functionName = parts[parts.length - 1];
                    this.addText(functionName);
                }
            } else {
                functionName = node.getFunctionName();
                this.addText(functionName);
            }
            this.addText("(");
            for (int i = 0; i < nArgs; ++i) {
                if (i > 0) {
                    this.addText(", ");
                }
                this.addTextButAppendFirstLine((SQLQueryText)argValues[i]);
            }
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLGroupBy node, IDataSourceCapabilities capabilities) {
        SQLWindowList windowList;
        SQLHaving havingClause;
        if (!this.selectKeywordIsAlreadyGenerated()) {
            String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
            this.addSelectKeyword(aDBHint);
        }
        this.increaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
        this.decreaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        this.addText("FROM");
        this.increaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.decreaseCurrentNodeIndentationLevel();
        SQLGroupByList groupByList = node.getGroupByList();
        if (groupByList != null) {
            groupByList.accept(this, capabilities);
        }
        if ((havingClause = node.getHavingClause()) != null) {
            havingClause.accept(this, capabilities);
        }
        if ((windowList = node.getWindowList()) != null) {
            windowList.accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLIn node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        String format = this.getFormattedPattern(pattern);
        SQLQueryText formattedText = this.formatPattern(format, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLIsDistinctFrom node, IDataSourceCapabilities capabilities) {
        boolean parentIsLogicalOperator;
        boolean bl = parentIsLogicalOperator = node.getParent().getType() == 301027;
        if (parentIsLogicalOperator) {
            this.addText("(");
        }
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
        if (parentIsLogicalOperator) {
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLIsNull node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLJoin node, IDataSourceCapabilities capabilities) {
        String rightNestedPattern;
        boolean encloseJoinInBrackets;
        boolean bl = encloseJoinInBrackets = capabilities.getBooleanValue("joins.Bracket", false) || node.getPropertyValue("bracketInnerJoin") != null && capabilities.getBooleanValue("joins.BracketInner");
        if (encloseJoinInBrackets) {
            this.addText("(");
        }
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.buildFormattedPatternForJoin(pattern, argValues, node.getJoinLevel());
        if (node.getParent().getType() == 301011 && node.getParent().getChild(1) == node && (rightNestedPattern = capabilities.getStringValue("joins.RightNested", null)) != null) {
            SQLQueryText[] newArgValues = new SQLQueryText[]{formattedText};
            formattedText = this.formatPattern(rightNestedPattern, newArgValues);
        }
        this.addTextButAppendFirstLine(formattedText);
        if (encloseJoinInBrackets) {
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLLateral node, IDataSourceCapabilities capabilities) {
        this.addText("LATERAL");
        this.addSpace();
        this.increaseCurrentBlockIndentationLevel();
        this.addText("(");
        this.addNewLineAndIndentation();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addNewLineAndIndentation();
        this.addText(")");
        this.decreaseCurrentBlockIndentationLevel();
        this.addAsKeyword();
    }

    @Override
    public void visit(SQLLike node, IDataSourceCapabilities capabilities) {
        Object[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        pattern = SQLAbstractFunction.refinePattern(pattern, argValues);
        SQLQueryText formattedText = this.formatPattern(pattern, (SQLQueryText[])argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLLogical node, IDataSourceCapabilities capabilities) {
        SQLQueryText formattedText;
        String pattern = node.getPattern(capabilities);
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String fName = node.getFunctionName();
        if (node.getSubType() == SQLLogical.SubType.OR) {
            IXQEQueryNode parent = node.getParent();
            if (parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.AND) {
                formattedText = this.buildFormattedPatternForLogicalOperator(pattern, argValues);
                formattedText.prependString("(");
                formattedText.appendString(")");
            } else {
                formattedText = this.buildFormattedPatternForLogicalOperator(pattern, argValues);
            }
        } else {
            formattedText = node.getSubType() == SQLLogical.SubType.AND ? this.buildFormattedPatternForLogicalOperator(pattern, argValues) : (node.getSubType() == SQLLogical.SubType.NOT ? this.buildFormattedPatternForLogicalNOTOperator(pattern, argValues, fName) : this.formatPattern(pattern, argValues));
        }
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLNativeSql node, IDataSourceCapabilities capabilities) {
        String sqlString = node.getSqlString();
        String flag = capabilities.getStringValue("UseNativeSQLSyntax", "true");
        if (flag == null || flag.equals("false")) {
            this.addNativePassThroughSQL(sqlString);
        } else if (node.isPassThrough()) {
            this.addNativePassThroughSQL("{{" + sqlString + "}}");
        } else {
            this.addNativePassThroughSQL("{" + sqlString + "}");
        }
    }

    @Override
    public void visit(SQLNullIf node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLOverlaps node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLPeriodPredicate node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLProduct node, IDataSourceCapabilities capabilities) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
                this.addNewLineAndIndentation();
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLProject node, IDataSourceCapabilities capabilities) {
        if (!this.selectKeywordIsAlreadyGenerated()) {
            String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
            this.addSelectKeyword(aDBHint);
        }
        this.increaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
        this.decreaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        this.addText("FROM");
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        this.increaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        child.accept(this, capabilities);
        if (child.getType() != 301053) {
            this.decreaseCurrentNodeIndentationLevel();
        }
        if (node.getNumberChildren() > 2) {
            ((SQLQueryNode)node.getChild(2)).accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLQuantifier node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        this.addText(node.getSubType().name());
        this.textBlock.addText(argValues[0]);
    }

    @Override
    public void visit(SQLQueryBlock node, IDataSourceCapabilities capabilities) {
        String cursorOptions;
        IXQEQueryNode parent = node.getParent();
        int parentType = parent.getType();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        int childType = child.getType();
        if (parentType == 301022 && this.getWithClauseGovernor()) {
            child.accept(this, capabilities);
            return;
        }
        if (childType == 301016) {
            child.accept(this, capabilities);
            if (parent.getType() != 301092) {
                this.addSpace();
                StringBuilder tableName = new StringBuilder();
                SQLIdentifier.delimitName(tableName, node.getName(), capabilities.getTableDelimiter(), this.forPlanning());
                this.addText(tableName.toString());
            }
            return;
        }
        if (node.isLateralDerivedTable() && childType != 301038) {
            this.addText("LATERAL");
            this.addSpace();
            this.increaseCurrentBlockIndentationLevel();
        }
        if (node.getName() != null && childType != 301038) {
            this.addText("(");
            this.addNewLineAndIndentation();
        }
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        if (node.getName() != null) {
            if (node.isLateralDerivedTable() && childType != 301038) {
                this.decreaseCurrentBlockIndentationLevel();
            }
            if (childType != 301038) {
                this.addNewLineAndIndentation();
                this.addText(")");
            }
            this.addSpace();
            StringBuilder tableName = new StringBuilder();
            SQLIdentifier.delimitName(tableName, node.getName(), capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(tableName.toString());
            List<String> nameList = node.getDerivedColumnList();
            List<IDataType> types = node.getDerivedColumnTypes();
            if (nameList != null && nameList.size() > 0) {
                this.addText("(");
                for (int i = 0; i < nameList.size(); ++i) {
                    if (i > 0) {
                        this.addText(", ");
                    }
                    StringBuilder columnName = new StringBuilder();
                    SQLIdentifier.delimitName(columnName, nameList.get(i), capabilities.getColumnDelimiter(), this.forPlanning());
                    this.addText(columnName.toString());
                    if (types == null || types.get(i) == null) continue;
                    this.addSpace();
                    this.addText(types.get(i).getSQLText());
                }
                this.addText(")");
            }
        }
        if (!(!node.isForeign() || this.builderProps.get("nativeSQL") != "true" || node.getChild(0).getType() == 301012 && node.getChild(0).getBooleanPropertyValue("passthrough") != null && node.getChild(0).getBooleanPropertyValue("passthrough").booleanValue() || node.getChild(0).getType() == 301061 || (cursorOptions = capabilities.getStringValue("general.cursorOptions", null)) == null || cursorOptions.isEmpty())) {
            this.addSpaceAndText(cursorOptions);
        }
    }

    @Override
    public void visit(SQLRangeVar node, IDataSourceCapabilities capabilities) {
        super.visit(node, capabilities);
    }

    @Override
    public void visit(SQLRelation node, IDataSourceCapabilities capabilities) {
        boolean doDerivedTable;
        IXQEQueryNode sqlWith;
        if (!this.forPlanning()) {
            super.visit(node, capabilities);
            return;
        }
        SQLQueryText commonTableSQL = null;
        if (node.getParent().getType() != 301007 && (sqlWith = node.getAncestorOfType(301022)) != null) {
            for (int i = 0; i < sqlWith.getNumberChildren(); ++i) {
                String name;
                IXQEQueryNode commonTable = sqlWith.getChild(i);
                if (commonTable.getType() == 301007) {
                    if (!((SQLRangeVar)commonTable).getName().equals(node.getName())) continue;
                    commonTableSQL = ((SQLRangeVar)commonTable).getSQLQueryText();
                    break;
                }
                if (commonTable.getType() != 301004 || (name = ((SQLQueryBlock)commonTable).getName()) == null || !name.equals(node.getName())) continue;
                commonTableSQL = ((SQLQueryBlock)commonTable).getSQLQueryText();
                break;
            }
        }
        boolean bl = doDerivedTable = !this.getWithClauseGovernor() && commonTableSQL != null;
        if (doDerivedTable) {
            this.addTextButAppendFirstLine(commonTableSQL.copy());
        } else {
            super.visit(node, capabilities);
        }
    }

    @Override
    public void visit(SQLSearchedCase node, IDataSourceCapabilities capabilities) {
        int[] types = new int[]{301029, 301021, 301028, 301030, 301009, 301042, 301020, 301027, 301048, 301076, 301025, 301026, 301024};
        IXQEQueryNode parent = node.getParent();
        if (!parent.isOfTypes(types)) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
            this.addNewLineAndIndentation();
        }
        this.addCaseKeyword();
        this.increaseCurrentNodeIndentationLevel();
        SQLValueList vList = (SQLValueList)node.getChild(0);
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            ((SQLQueryNode)vList.getChild(i)).accept(this, capabilities);
        }
        if (node.getNumberChildren() > 1) {
            this.addElseKeyword();
            ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
        this.addEndKeyword();
        if (!node.isParentOfTypes(types)) {
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    @Override
    public void visit(SQLSelect node, IDataSourceCapabilities capabilities) {
        String aDBHint = this.getDBHintFromSQLRangeVarProperty(node);
        this.addSelectKeyword(aDBHint);
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLSetOperator node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        IXQEQueryNode parent = node.getParent();
        Boolean isNestedSetOperatorNode = false;
        if (parent.getType() == 301018 && node.getSubType().precedence() >= ((SQLSetOperator)parent).getSubType().precedence() && parent.getChild(1).equals(node) && (node.getSubType() != SQLSetOperator.SubType.UNION || ((SQLSetOperator)parent).getSubType() != SQLSetOperator.SubType.UNION)) {
            isNestedSetOperatorNode = true;
            this.addText("(");
            this.addNewLineAndIndentation();
        }
        SQLQueryText formattedText = this.buildFormattedPatternForSetOperator(pattern, argValues, node.getNestedLevel());
        SQLQueryText[] twoArgs = new SQLQueryText[2];
        twoArgs[0] = argValues[0];
        SQLQueryText sofar = null;
        for (int i = 1; i < argValues.length; ++i) {
            twoArgs[1] = argValues[i];
            twoArgs[0] = sofar = formattedText;
        }
        this.addTextButAppendFirstLine(sofar);
        if (isNestedSetOperatorNode.booleanValue()) {
            this.addNewLineAndIndentation();
            this.addText(")");
        }
    }

    @Override
    public void visit(SQLSimilar node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLSimpleCase node, IDataSourceCapabilities capabilities) {
        int[] types = new int[]{301029, 301021, 301028, 301030, 301009, 301042, 301020, 301027, 301048, 301076, 301025, 301026, 301024};
        IXQEQueryNode parent = node.getParent();
        if (!parent.isOfTypes(types)) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
            this.addNewLineAndIndentation();
        }
        this.addCaseKeyword();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.increaseCurrentNodeIndentationLevel();
        SQLValueList vList = (SQLValueList)node.getChild(1);
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            ((SQLQueryNode)vList.getChild(i)).accept(this, capabilities);
        }
        if (node.getNumberChildren() > 2) {
            this.addElseKeyword();
            ((SQLQueryNode)node.getChild(2)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
        this.addEndKeyword();
        if (!node.isParentOfTypes(types)) {
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    @Override
    public void visit(SQLSort node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addText(" ");
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() != 301007 && (parent.getType() != 301004 || ((SQLQueryBlock)parent).getName() == null)) {
            this.setCurrentNodeIndentationLevel(0);
        }
        this.addNewLineAndIndentation();
        this.addText(node.getPattern(capabilities));
        this.addText(" ");
        this.increaseCurrentNodeIndentationLevel();
        for (int i = 1; i < node.getNumberChildren(); ++i) {
            if (i > 1) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLSortKeyList node, IDataSourceCapabilities capabilities) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            this.addNewLineAndIndentation();
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLSparqlQuery node, IDataSourceCapabilities capabilities) {
        String dbName = node.getDatabaseName();
        if (dbName != null) {
            this.addText(dbName);
            this.addText(".");
        }
        this.addText("SPARQL(");
        this.increaseCurrentBlockIndentationLevel();
        this.addNativePassThroughSQL(node.getQuery());
        this.decreaseCurrentBlockIndentationLevel();
        this.addNewLineAndIndentation();
        this.addText(")");
    }

    @Override
    public void visit(SQLSubQuery node, IDataSourceCapabilities capabilities) {
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        boolean needParenthesis = true;
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301076) {
            needParenthesis = false;
        }
        if (needParenthesis) {
            this.addOpenParenthesis();
            this.addNewLineAndIndentation();
        }
        child.accept(this, capabilities);
        if (needParenthesis) {
            this.addCloseParenthesis();
        }
    }

    @Override
    public void visit(SQLTableFunction node, IDataSourceCapabilities capabilities) {
        if (node.getSubType() == SQLTableFunction.SubType.CURSOR) {
            SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
            this.addText(node.getFunctionName());
            this.addText("(");
            for (int i = 0; i < argValues.length; ++i) {
                if (i > 0) {
                    this.addText(", ");
                }
                this.addTextButAppendFirstLine(argValues[i]);
            }
            this.addText(")");
            return;
        }
        if (node.getSubType() == SQLTableFunction.SubType.UNNEST) {
            SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
            this.addText("UNNEST");
            this.addText("(");
            for (int i = 1; i < argValues.length; ++i) {
                if (i > 1) {
                    this.addText(", ");
                }
                this.addTextButAppendFirstLine(argValues[i]);
            }
            this.addText(")");
            if (!argValues[0].toString().startsWith("WITHOUT")) {
                this.addSpace();
                this.addTextButAppendFirstLine(argValues[0]);
            }
            return;
        }
        super.visit(node, capabilities);
    }

    @Override
    public void visit(SQLTrim node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    private void addValueExpression(SQLValueExpression node, IDataSourceCapabilities capabilities) {
        SQLQueryText[] argValues = this.dumpChildren(node, capabilities);
        String pattern = node.getPattern(capabilities);
        if (pattern == null && node.getAncestorOfType(301033) != null) {
            SQLFunction functionNode = (SQLFunction)node.getAncestorOfType(301033);
            SQLCapabilities generalcapabilities = SQLCapabilities.getInstance();
            node.removeProperty("pattern");
            pattern = node.getPattern(generalcapabilities);
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedExpressionInDBFunction, this.formatPattern(pattern, argValues), (Object)functionNode.getFunctionName());
        }
        SQLQueryText formattedText = this.formatPattern(pattern, argValues);
        this.addTextButAppendFirstLine(formattedText);
    }

    @Override
    public void visit(SQLValueExpression node, IDataSourceCapabilities capabilities) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301025 && node.getSubType().precedence() >= ((SQLValueExpression)parent).getSubType().precedence() && (node.getSubType() != SQLValueExpression.SubType.CONCATENATE || ((SQLValueExpression)parent).getSubType() != SQLValueExpression.SubType.CONCATENATE)) {
            this.addText("(");
            this.addValueExpression(node, capabilities);
            this.addText(")");
        } else {
            this.addValueExpression(node, capabilities);
        }
    }

    @Override
    public void visit(SQLValueList node, IDataSourceCapabilities capabilities) {
        List<SQLAlias> aliasList = node.getAliasList();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
                this.addNewLineAndIndentation();
            }
            SQLQueryNode child = (SQLQueryNode)node.getChild(i);
            child.accept(this, capabilities);
            if (!capabilities.getBooleanValue("supports.columnAliasing") || aliasList == null || aliasList.size() < i + 1 || aliasList.get(i) == null) continue;
            this.addAliasKeyword(capabilities);
            StringBuilder aliasName = new StringBuilder();
            SQLIdentifier.delimitName(aliasName, aliasList.get(i).getName(), capabilities.getColumnDelimiter(), this.forPlanning());
            this.addText(aliasName.toString());
        }
        this.setSelectKeywordIsAlreadyGenerated(false);
    }

    @Override
    public void visit(SQLWhen node, IDataSourceCapabilities capabilities) {
        this.addWhenKeyword();
        SQLPrettyPrintQueryFormatter tmpFormatter = new SQLPrettyPrintQueryFormatter(this);
        ((SQLQueryNode)node.getChild(0)).accept(tmpFormatter, capabilities);
        SQLQueryText whenBlock = tmpFormatter.getTextBlock();
        if (whenBlock.getNumberOfLines() > 1) {
            this.increaseCurrentNodeIndentationLevel();
            this.addTextBlock(whenBlock);
            this.decreaseCurrentNodeIndentationLevel();
        } else {
            this.addTextButAppendFirstLine(whenBlock);
        }
        tmpFormatter = new SQLPrettyPrintQueryFormatter(this);
        ((SQLQueryNode)node.getChild(1)).accept(tmpFormatter, capabilities);
        SQLQueryText thenBlock = tmpFormatter.getTextBlock();
        if (thenBlock.getNumberOfLines() == 1 && whenBlock.getNumberOfLines() == 1) {
            this.addText(" ");
            this.addText("THEN");
            this.addText(" ");
            this.addTextButAppendFirstLine(thenBlock);
        } else {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
            this.addText("THEN");
            this.increaseCurrentNodeIndentationLevel();
            this.addTextBlock(thenBlock);
            this.decreaseCurrentNodeIndentationLevel();
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    @Override
    public void visit(SQLWindow node, IDataSourceCapabilities capabilities) {
        this.increaseCurrentNodeIndentationLevel();
        this.addNewLineAndIndentation();
        this.addText("OVER");
        this.addText("(");
        if (node.getReferenceName() != null) {
            this.addSpaceAndText(node.getReferenceName());
        }
        this.increaseCurrentNodeIndentationLevel();
        IXQEQueryNode child = node.getComputeBreak();
        if (child != null) {
            ((SQLQueryNode)child).accept(this, capabilities);
        }
        if ((child = node.getPartitionBy()) != null) {
            ((SQLQueryNode)child).accept(this, capabilities);
        }
        if ((child = node.getOrderBy()) != null) {
            this.addOrderByKeyword();
            this.increaseCurrentNodeIndentationLevel();
            ((SQLQueryNode)child).accept(this, capabilities);
            this.decreaseCurrentNodeIndentationLevel();
        }
        this.decreaseCurrentNodeIndentationLevel();
        Integer lower = node.getWindowFrameLowerBound();
        if (lower != null) {
            int x;
            this.addNewLineAndIndentation();
            this.addSpaceAndText(node.getWindowFrameUnits());
            Integer upper = node.getWindowFrameUpperBound();
            if (upper != null) {
                this.addSpaceAndText("BETWEEN");
            }
            if (lower == Integer.MIN_VALUE) {
                this.addText(" UNBOUNDED");
                this.addText(" PRECEDING");
            } else {
                x = lower;
                if (x < 0) {
                    this.addSpaceAndText(Integer.toString(-x));
                    this.addText(" PRECEDING");
                } else if (x == 0) {
                    this.addText(" CURRENT ROW");
                } else {
                    this.addSpaceAndText(Integer.toString(x));
                    this.addText(" FOLLOWING");
                }
            }
            if (upper != null) {
                this.addSpaceAndText("AND");
                if (upper == Integer.MAX_VALUE) {
                    this.addText(" UNBOUNDED");
                    this.addText(" FOLLOWING");
                } else {
                    x = upper;
                    if (x < 0) {
                        this.addSpaceAndText(Integer.toString(-x));
                        this.addText(" PRECEDING");
                    } else if (x == 0) {
                        this.addText(" CURRENT ROW");
                    } else {
                        this.addSpaceAndText(Integer.toString(x));
                        this.addText(" FOLLOWING");
                    }
                }
            }
        }
        if (node.isSamplingScope() && capabilities.isSupported("supports.sqlserverWindowBehaviour")) {
            this.increaseCurrentNodeIndentationLevel();
            this.addOrderByKeyword();
            this.addNewLineAndIndentation();
            this.addSpaceAndText("( SELECT NULL )");
            this.decreaseCurrentNodeIndentationLevel();
        }
        this.addNewLineAndIndentation();
        this.addText(")");
        this.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    public void visit(SQLWith node, IDataSourceCapabilities capabilities) {
        if (!this.forPlanning()) {
            this.generateCommonTableExpression(node, capabilities);
            return;
        }
        if (this.getWithClauseGovernor()) {
            this.generateCommonTableExpression(node, capabilities);
            return;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301019) {
            parent = parent.getParent();
        }
        if (parent.getType() != 801041 && node.getPropertyValue("createdForCognosSQL") == null) {
            boolean temp = this.getWithClauseGovernor();
            this.setWithClauseGovernor(true);
            this.generateCommonTableExpression(node, capabilities);
            this.setWithClauseGovernor(temp);
            return;
        }
        this.generateDerivedTableSyntax(node, capabilities);
    }

    private void generateCommonTableExpression(SQLWith node, IDataSourceCapabilities capabilities) {
        this.addText("WITH ");
        int nChildren = node.getNumberChildren();
        for (int i = 0; i < nChildren - 1; ++i) {
            List<String> nameList;
            String tableCommonExprName;
            SQLQueryNode child;
            if (i > 0) {
                this.addText(", ");
            }
            if ((child = (SQLQueryNode)node.getChild(i)).getType() == 301007) {
                tableCommonExprName = ((SQLRangeVar)child).getName();
                nameList = ((SQLRangeVar)child).getDerivedColumnList();
            } else {
                tableCommonExprName = ((SQLQueryBlock)child).getName();
                nameList = ((SQLQueryBlock)child).getDerivedColumnList();
            }
            this.addNewLineAndIndentation();
            StringBuilder tableName = new StringBuilder();
            SQLIdentifier.delimitName(tableName, tableCommonExprName, capabilities.getTableDelimiter(), this.forPlanning());
            this.addText(tableName.toString());
            if (nameList != null && !nameList.isEmpty()) {
                this.addText("(");
                for (int j = 0; j < nameList.size(); ++j) {
                    if (j > 0) {
                        this.addText(", ");
                    }
                    StringBuilder columnName = new StringBuilder();
                    SQLIdentifier.delimitName(columnName, nameList.get(j), capabilities.getColumnDelimiter(), this.forPlanning());
                    this.addText(columnName.toString());
                }
                this.addText(")");
            }
            this.addAsKeyword();
            this.increaseCurrentBlockIndentationLevel();
            this.addOpenParenthesis();
            this.addNewLineAndIndentation();
            child.accept(this, capabilities);
            this.addCloseParenthesis();
            this.decreaseCurrentBlockIndentationLevel();
        }
        this.addNewLineAndIndentation();
        ((SQLQueryNode)node.getChild(nChildren - 1)).accept(this, capabilities);
    }

    private void generateDerivedTableSyntax(SQLWith node, IDataSourceCapabilities capabilities) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            SQLQueryBlock queryBlock;
            SQLPrettyPrintQueryFormatter formatter;
            IXQEQueryNode child = node.getChild(i);
            int childType = child.getType();
            if (childType == 301007) {
                SQLRangeVar rangeVar = (SQLRangeVar)child;
                if (rangeVar.getSQLQueryText() != null) continue;
                formatter = new SQLPrettyPrintQueryFormatter(this);
                rangeVar.accept(formatter, capabilities);
                rangeVar.setSQLQueryText(formatter.getTextBlock());
                continue;
            }
            if (childType != 301004 || (queryBlock = (SQLQueryBlock)child).getSQLQueryText() != null) continue;
            formatter = new SQLPrettyPrintQueryFormatter(this);
            queryBlock.accept(formatter, capabilities);
            queryBlock.setSQLQueryText(formatter.getTextBlock());
        }
        SQLPrettyPrintQueryFormatter formatter = new SQLPrettyPrintQueryFormatter(this);
        SQLQueryNode mainSelect = (SQLQueryNode)node.getChild(node.getNumberChildren() - 1);
        mainSelect.accept(formatter, capabilities);
        this.addTextButAppendFirstLine(formatter.getTextBlock());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.textBlock.toString());
        return this.replaceAllLFWithCRLF(builder);
    }

    @Override
    public String bufferToString() {
        return this.toString();
    }

    public static List<String> findLineEnds(SQLQueryText buffer) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < buffer.getNumberOfLines(); ++i) {
            SQLQueryLine queryLine = buffer.getLines().get(i);
            if (!queryLine.getLine().contains("\n") && !queryLine.getLine().contains("\r")) continue;
            results.add("Found Line End at line " + i);
        }
        return results;
    }
}

