/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.util;

import com.cognos.xqe.ast.sql.util.SQLQueryLine;
import com.cognos.xqe.ast.sql.util.SQLQueryText;

public class SQLQueryTextFactory {
    boolean formatting = true;
    static SQLQueryTextFactory ff = new SQLQueryTextFactory(true);
    static SQLQueryTextFactory nf = new SQLQueryTextFactory(false);

    public SQLQueryTextFactory(boolean theFormatting) {
        this.formatting = theFormatting;
    }

    public SQLQueryText getSqlQueryText() {
        if (this.formatting) {
            return new SQLQueryTextFormatting();
        }
        return new SQLQueryTextPlain();
    }

    static class SQLQueryTextPlain
    extends SQLQueryText {
        private static final char SPACE_CHARACTER = ' ';

        SQLQueryTextPlain() {
        }

        @Override
        public SQLQueryText flatten(int entriesPerLine) {
            return this;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            int numberOfLines = this.getNumberOfLines();
            boolean nativeSQLStatement = false;
            for (int i = 0; i < numberOfLines; ++i) {
                SQLQueryLine queryLine = this.getLines().get(i);
                String line = queryLine.getLine();
                if (line.isEmpty()) continue;
                if (i > 0 && builder.charAt(builder.length() - 1) != ' ' && line.charAt(0) != ' ') {
                    builder.append(" ");
                }
                if (queryLine.isNativeSQL() || nativeSQLStatement) {
                    builder.append("\r\n");
                    if (nativeSQLStatement != queryLine.isNativeSQL()) {
                        nativeSQLStatement = queryLine.isNativeSQL();
                    }
                }
                builder.append(line);
            }
            return builder.toString();
        }

        @Override
        public SQLQueryText copy() {
            SQLQueryText copy = nf.getSqlQueryText();
            for (int i = 0; i < this.getNumberOfLines(); ++i) {
                copy.addLine(((SQLQueryLine)this.lines.get(i)).copy());
            }
            return copy;
        }
    }

    static class SQLQueryTextFormatting
    extends SQLQueryText {
        SQLQueryTextFormatting() {
        }

        @Override
        public SQLQueryText flatten(int entriesPerLine) {
            SQLQueryText temp = ff.getSqlQueryText();
            int entryCount = 0;
            for (int i = 0; i < this.getNumberOfLines(); ++i) {
                if (entryCount < entriesPerLine) {
                    temp.appendString(((SQLQueryLine)this.lines.get(i)).getLine());
                    ++entryCount;
                    continue;
                }
                temp.addLine();
            }
            return temp;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            int numberOfLines = this.getNumberOfLines();
            for (int i = 0; i < numberOfLines; ++i) {
                if (i > 0) {
                    builder.append("\r\n");
                }
                SQLQueryLine queryLine = this.getLines().get(i);
                String line = queryLine.getLine();
                int indent = queryLine.getIndentLevel();
                this.appendIndent(builder, indent);
                builder.append(line);
            }
            return builder.toString();
        }

        protected void appendIndent(StringBuilder builder, int indentLevel) {
            for (int i = 0; i < indentLevel; ++i) {
                builder.append("    ");
            }
        }

        @Override
        public SQLQueryText copy() {
            SQLQueryText copy = ff.getSqlQueryText();
            for (int i = 0; i < this.getNumberOfLines(); ++i) {
                copy.addLine(((SQLQueryLine)this.lines.get(i)).copy());
            }
            return copy;
        }
    }
}

