/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModDataItem
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "ModDataItem";
    public static final String V5_NODE_NAME = "modDataItem";
    private static final String XMLATTRIBUTES = "XMLAttributes";
    public static final String PROP_XMLATTRS = "xmlAttributes";
    private static final String XMLATTRIBUTE = "XMLAttribute";
    private static final String VALUE = "value";
    private static final String MODDATAITEM_TYPE = "modDataItemType";

    @Override
    public int getType() {
        return 101081;
    }

    @Override
    public String getNodeTypeName() {
        return V5_NODE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!attname.equals("name")) {
                throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            }
            this.setStringPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("modDefinition")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals(XMLATTRIBUTES)) {
                List xmlAttrs = child.elements();
                TreeMap<String, String> xmlAttrProp = null;
                for (Element a : xmlAttrs) {
                    String aEleName = a.getName();
                    if (!aEleName.equals(XMLATTRIBUTE)) continue;
                    String nm = a.attributeValue("name");
                    String v = a.attributeValue(VALUE);
                    if (nm == null || v == null) continue;
                    if (xmlAttrProp == null) {
                        xmlAttrProp = new TreeMap<String, String>();
                        this.setPropertyValue(PROP_XMLATTRS, xmlAttrProp);
                    }
                    xmlAttrProp.put(nm, v);
                }
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public ModDataItemType getModDataItemType() {
        ModDataItemType tp = (ModDataItemType)((Object)this.getPropertyValue(MODDATAITEM_TYPE));
        if (tp == null) {
            tp = ModDataItemType.TP_ATTRIBUTE;
            IXQEQueryNode[] def = this.getChildren();
            if (def != null && def.length == 1) {
                int[] measureTypes = new int[]{101084};
                IXQEQueryNode[] measures = def[0].getChildrenOfTypes(measureTypes);
                if (measures != null && measures.length > 0) {
                    tp = ModDataItemType.TP_MEASURE;
                } else {
                    int[] summaryTypes = new int[]{101085, 101086};
                    IXQEQueryNode[] sums = def[0].getChildrenOfTypes(summaryTypes);
                    if (sums != null && sums.length > 0) {
                        tp = ModDataItemType.TP_SUMMARY;
                    }
                }
            }
            this.setPropertyValue(MODDATAITEM_TYPE, (Object)tp);
        }
        return tp;
    }

    public static enum ModDataItemType {
        TP_ATTRIBUTE,
        TP_MEASURE,
        TP_SUMMARY;

    }
}

