/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModFilter
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "ModFilter";
    public static final String V5_NODE_NAME = "modFilter";
    public static final String PROP_STRING_USE = "use";
    public static final String PROP_STRING_CHANGEINADVANCEDVIEWER = "canBeChangedInAdvancedViewer";
    private static final String XMLATTRIBUTES = "XMLAttributes";
    public static final String PROP_XMLATTRS = "xmlAttributes";
    private static final String XMLATTRIBUTE = "XMLAttribute";
    private static final String VALUE = "value";
    public static final Object USE_REQUIRED = "required";
    public static final Object USE_OPTIONAL = "optional";
    public static final Object USE_DISABLED = "disabled";

    @Override
    public int getType() {
        return 101092;
    }

    @Override
    public String getNodeTypeName() {
        return V5_NODE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_USE)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_STRING_CHANGEINADVANCEDVIEWER)) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("modFilterDefinition") && child.elements().size() == 1) {
                childname = (child = (Element)child.elements().get(0)).getName();
                if (childname.equals("modFilterCompare") || childname.equals("modFilterFacets") || childname.equals("modFilterStringCompare") || childname.equals("modFilterRange") || childname.equals("modFilterNulls")) {
                    V5QueryNode node = factory.createV5Node(childname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, child);
                    continue;
                }
                throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
            }
            if (childname.equals(XMLATTRIBUTES)) {
                List xmlAttrs = child.elements();
                TreeMap<String, String> xmlAttrProp = null;
                for (Element a : xmlAttrs) {
                    String aEleName = a.getName();
                    if (!aEleName.equals(XMLATTRIBUTE)) continue;
                    String nm = a.attributeValue("name");
                    String v = a.attributeValue(VALUE);
                    if (nm == null || v == null) continue;
                    if (xmlAttrProp == null) {
                        xmlAttrProp = new TreeMap<String, String>();
                        this.setPropertyValue(PROP_XMLATTRS, xmlAttrProp);
                    }
                    xmlAttrProp.put(nm, v);
                }
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

