/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModFilterRange
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "ModFilterRange";
    public static final String V5_NODE_NAME = "modFilterRange";
    public static final String FILTER_FROM_PROP = "modFilterFrom";
    public static final String FILTER_TO_PROP = "modFilterTo";

    @Override
    public int getType() {
        return 101096;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("refDataItem") || attname.equals("parameterName")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals("includeNulls") || attname.equals("out") || attname.equals("parameterized")) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(FILTER_FROM_PROP)) {
                this.setStringPropertyValue(FILTER_FROM_PROP, child.getText());
                continue;
            }
            if (childname.equals(FILTER_TO_PROP)) {
                this.setStringPropertyValue(FILTER_TO_PROP, child.getText());
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

