/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class V5BaseExpression
extends V5QueryNode {
    public static final String PROP_STRING_EXPRESSION = "expression";
    public static final String PROP_STRING_RID = "rID";

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_RID)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) {
                if (!attname.equals(PROP_STRING_EXPRESSION)) continue;
                this.setStringPropertyValue(PROP_STRING_EXPRESSION, att.getValue());
                continue;
            }
            if (this instanceof V5Expression && attname.equals("metadataContextName")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5MultiPartIdentifier") || childname.equals("V5DataItemReference") || childname.equals("V5InExpression")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
        if (readV5SpecFormat) {
            this.setStringPropertyValue(PROP_STRING_EXPRESSION, inputNode.getText());
        }
    }

    @Override
    public V5QueryNode getEffectiveNodeForMessage() {
        return (V5QueryNode)this.getParent();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        Object prop = this.getPropertyValue(PROP_STRING_EXPRESSION);
        if (prop != null) {
            buffer.append((String)prop);
        } else {
            super.writeFormattedText(buffer);
        }
    }

    public void setExpression(String expr) {
        this.setStringPropertyValue(PROP_STRING_EXPRESSION, expr);
    }

    public String getExpression() {
        return (String)this.getPropertyValue(PROP_STRING_EXPRESSION);
    }
}

