/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5DataItem
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5DataItem";
    public static final String V5_NODE_NAME = "dataItem";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_IS_LABEL_FROM_MODEL = "isLabelFromModel";
    public static final String PROP_STRING_LABEL = "label";
    public static final String PROP_STRING_AGGREGRATE = "aggregate";
    public static final String PROP_STRING_ROLLUP_AGGREGRATE = "rollupAggregate";
    public static final String PROP_STRING_ORG_ROLLUP_AGGREGRATE = "orgRollupAggregate";
    public static final String PROP_STRING_ORG_ID = "orgId";
    public static final String PROP_STRING_SORT = "sort";
    public static final String PROP_STRING_DECOMPOSEFROM = "decomposedFrom";
    public static final String PROP_STRING_DETAIL = "detail";
    public static final String PROP_STRING_CUSTOM_FORMAT = "customFormat";
    public static final String PROP_STRING_CUSTOM_FORMAT_SOLVE_ORDER = "customFormatSolveOrder";
    public static final String PROP_BOOLEAN_UNIQUE_ATTRIBUTE = "uniqueAttribute";
    public static final String PROP_BOOLEAN_NA_IN_CALC_MEMBER_CONTEXT = "naInCalcMemberContext";
    public static final String PROP_INTEGER_SOLVE_ORDER = "solveOrder";
    public static final String PROP_STRING_ON_IN_ACCESSIBLE_MEMBER = "onInaccessibleMember";
    public static final String PROP_BOOLEAN_APPLY_LOWEST_SOLVE_ORDER = "applyLowestSolveOrder";
    private static final String EXPRESSION = "expression";
    private static final String XMLATTRIBUTES = "XMLAttributes";
    public static final String STR_DETAIL_AUTOMATIC = "automatic";
    public static final String STR_DETAIL_SUMMARIZE = "summarize";
    public static final String STR_REGULAR_SUM = "sum";
    public static final String STR_REGULAR_UNKNOWN = "unknown";
    public static final String STR_REGULAR_UNSUPPORTED = "unsupported";
    public static final String STR_CALCULATED = "calculated";
    public static final String STR_TOTAL = "total";
    public static final String STR_NONE = "none";
    public static final String STR_MINIMUM = "minimum";
    public static final String STR_NOT_APPLICABLE = "notApplicable";
    public static final String STR_DETAIL_FALSE = "false";
    public static final String STR_DETAIL_TRUE = "true";
    public static final String STR_DETAIL_AUTOMATIC_FALSE = "automatic_false";
    public static final String STR_DETAIL_AUTOMATIC_TRUE = "automatic_true";
    public static final String PROP_STRING_ORGNAME = "orgName";
    public static final String PROP_AGGREGATE_EXPRESSION = "aggregateExpression";
    public static final String PROP_ROLLUP_EXPRESSION = "rollupExpression";
    public static final String STR_SORT_ASCENDING = "ascending";
    public static final String STR_SORT_DESCENDING = "descending";
    public static final String PROP_IS_PROJECTED = "isProjected";
    public static final String PROP_DETAIL_CONTEXT = "detailContext";
    private static final String PROP_IS_REFERENCED = "isReferenced";
    public static final String PROP_IS_ORIGINAL = "isOriginal";
    private static final String PROP_REFERENCES_WALKED = "referencesWalked";
    public static final String PROP_STRING_ORG_DEFINED = "orgDefined";
    public static final String PROP_STRING_FACTITEM = "factItem";
    public static final String PROP_STRING_REFOTHER = "refOther";
    public static final String PROP_STRING_DISTINCT_MUN = "originalDistinctDataItem";
    public static final String PROP_STRING_ORIGINAL_AGGR = "originalAggregate";
    public static final String PROP_ORIGINAL_V5DATAITEM = "originalV5DataItem";
    public static final String PROP_CURRENCY = "currency";
    public static final String PROP_REFMODELOBJ_NAME = "refModelObjectName";
    public static final String PROP_IS_ERROR_CELL = "errorCell";
    private static final String PROP_PRESERVE_METADATA = "PreserveMetadata";
    public static final String PROP_IS_ROLAP_NAMEDSET_EXPRESSION = "rolapNamedSetExpression";
    public static final String PROP_IS_ROLLUP_EXPRESSION = "isRollupExpression";
    public static final String PROP_OBJECT_CAST_DATATYPE = "castDataType";
    public static final String PROP_XMLATTRS = "xmlAttributes";
    public static final String PROP_LOOKUP = "lookup";
    public static final String PROP_IS_SUBQUERY_DI_REF = "subQueryDataItemRef";
    public static final String PROP_CONTEXT = "context";
    public static final String PROP_SHOW_ALL = "showall";
    public static final String PROP_CONTEXT_IDENTIFIER = "contextIdentifier";
    private static final String PROP_IS_MODULE_CALCULATION = "isModuleCalculation";
    public static final String PROP_MODEL_CALCULATION_ID = "modelCalculationID";
    private static final String PROP_CALCULATION_EXPRESSION = "calculationExpression";
    public static final String PROP_LINK_PARAM = "linkParameter";

    @Override
    public int getType() {
        return 101003;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 101003) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public String getV5ElementName() {
        return V5_NODE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!readV5SpecFormat && attname.equals("id")) {
                this.setStringPropertyValue(PROP_STRING_ORG_ID, att.getValue());
                continue;
            }
            if (attname.equals(PROP_STRING_NAME) || attname.equals(PROP_STRING_LABEL) || attname.equals(PROP_STRING_AGGREGRATE) || attname.equals(PROP_STRING_ROLLUP_AGGREGRATE) || attname.equals(PROP_STRING_SORT) || attname.equals(PROP_STRING_DETAIL) || attname.equals(PROP_STRING_ON_IN_ACCESSIBLE_MEMBER) || attname.equals(PROP_STRING_DECOMPOSEFROM) || attname.equals(PROP_STRING_ORGNAME) || attname.equals("identifier")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_BOOLEAN_NA_IN_CALC_MEMBER_CONTEXT) || attname.equals(PROP_IS_ROLLUP_EXPRESSION) || attname.equals(PROP_BOOLEAN_APPLY_LOWEST_SOLVE_ORDER)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_INTEGER_SOLVE_ORDER)) {
                this.setIntegerPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_BOOLEAN_UNIQUE_ATTRIBUTE) || attname.equals(PROP_STRING_ORG_ROLLUP_AGGREGRATE)) {
                XQEDebugLog.err.println("Invalid V5 attribute: " + attname);
                continue;
            }
            if (attname.equals(PROP_CONTEXT)) {
                String context = att.getValue();
                String[] contextArray = this.parseContextList(context);
                this.setContextProperty(contextArray);
                continue;
            }
            if (attname.equals(PROP_SHOW_ALL)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_IS_REFERENCED)) {
                this.setIsReferenced();
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            V5QueryNode node;
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(EXPRESSION) || childname.equals("V5Expression")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals("V5ValueSummaryFunction")) {
                node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals(XMLATTRIBUTES)) {
                List xmlAttrs = child.elements();
                TreeMap<String, String> xmlAttrProp = null;
                for (Element a : xmlAttrs) {
                    String aEleName = a.getName();
                    if (!aEleName.equals("XMLAttribute")) continue;
                    String nm = a.attributeValue(PROP_STRING_NAME);
                    String v = a.attributeValue("value");
                    if (nm == null || v == null) continue;
                    if (xmlAttrProp == null) {
                        xmlAttrProp = new TreeMap<String, String>();
                        this.setPropertyValue(PROP_XMLATTRS, xmlAttrProp);
                    }
                    xmlAttrProp.put(nm, v);
                }
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public String getRollupAggregateProperty() {
        return (String)this.getPropertyValue(PROP_STRING_ROLLUP_AGGREGRATE);
    }

    public void setRollupAggregateProperty(String rollupAggregate) {
        this.setPropertyValue(PROP_STRING_ROLLUP_AGGREGRATE, rollupAggregate);
    }

    public String getAggregateProperty() {
        return (String)this.getPropertyValue(PROP_STRING_AGGREGRATE);
    }

    public void setAggregateProperty(String aggregate) {
        this.setPropertyValue(PROP_STRING_AGGREGRATE, aggregate);
    }

    public Integer getSolveOrderProperty() {
        Object obj = this.getPropertyValue(PROP_INTEGER_SOLVE_ORDER);
        if (obj != null) {
            return (Integer)obj;
        }
        return null;
    }

    public void setSolveOrderProperty(int solveOrder) {
        this.setPropertyValue(PROP_INTEGER_SOLVE_ORDER, XQEIntegerPool.getInteger(solveOrder));
    }

    public boolean getNaInCalcMemberContextProperty() {
        Boolean bool = this.getBooleanPropertyValue(PROP_BOOLEAN_NA_IN_CALC_MEMBER_CONTEXT);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public IDataType getDataType() {
        IXQEQueryNode child = this.getChild(0);
        while (child.getType() == 101003) {
            child = child.getChild(0);
        }
        if (child.isOfCategory(201120)) {
            return ((V5SimpleNode)child).getDataType();
        }
        return ((V5Expression)child).getDataType();
    }

    public final String getDetailProperty() {
        String detail = STR_DETAIL_AUTOMATIC;
        String sDetail = (String)this.getPropertyValue(PROP_STRING_DETAIL);
        if (sDetail != null && sDetail.equals(STR_DETAIL_FALSE)) {
            detail = STR_DETAIL_FALSE;
        }
        if (sDetail != null && sDetail.equals(STR_DETAIL_AUTOMATIC_FALSE)) {
            detail = STR_DETAIL_AUTOMATIC_FALSE;
        }
        if (sDetail != null && sDetail.equals(STR_DETAIL_TRUE)) {
            detail = STR_DETAIL_TRUE;
        }
        if (sDetail != null && sDetail.equals(STR_DETAIL_AUTOMATIC_TRUE)) {
            detail = STR_DETAIL_AUTOMATIC_TRUE;
        }
        return detail;
    }

    public boolean isAggregate() {
        return !this.isGroupingItem();
    }

    public boolean isAggregate(String aggregateString) {
        String aggregateAttr = this.getAggregateProperty();
        return aggregateAttr != null && aggregateAttr.equals(aggregateString);
    }

    public boolean isGroupingItem() {
        String aggregateAttr = this.getAggregateProperty();
        if (aggregateAttr != null && aggregateAttr.equals(STR_NONE)) {
            return !V5DataItem.expressionHasAggregateWithAutoForClause(this.getChild(0));
        }
        return false;
    }

    private static boolean expressionHasAggregateWithAutoForClause(IXQEQueryNode expr) {
        IXQEQueryNode[] children;
        if ((expr.getType() == 201031 || expr.getType() == 201035) && expr.getFirstChildByType(201037) == null) {
            return true;
        }
        for (IXQEQueryNode child : children = expr.getChildren()) {
            if (!V5DataItem.expressionHasAggregateWithAutoForClause(child)) continue;
            return true;
        }
        return false;
    }

    public void setAggregateExpression(IXQEQueryNode aggregateExpr) {
        this.setPropertyValue(PROP_AGGREGATE_EXPRESSION, aggregateExpr);
    }

    public void setRollupExpression(IXQEQueryNode rollupExpr) {
        this.setPropertyValue(PROP_ROLLUP_EXPRESSION, rollupExpr);
    }

    public void setDetailContext(IXQEQueryNode detailContextExpr) {
        this.setPropertyValue(PROP_DETAIL_CONTEXT, detailContextExpr);
    }

    public IXQEQueryNode getDetailExpression() {
        return this.getChild(0);
    }

    public IXQEQueryNode getRollupExpression() {
        return (IXQEQueryNode)this.getPropertyValue(PROP_ROLLUP_EXPRESSION);
    }

    public IXQEQueryNode getAggregateExpression() {
        return (IXQEQueryNode)this.getPropertyValue(PROP_AGGREGATE_EXPRESSION);
    }

    public IXQEQueryNode getAggregateExpression(PlanningEnvironment environment) {
        V5DataItem originalDataItem;
        IXQEQueryNode aggregateExpr = (IXQEQueryNode)this.getPropertyValue(PROP_AGGREGATE_EXPRESSION);
        if (aggregateExpr != null) {
            IXQEQueryNode[] dataItemRefs;
            for (IXQEQueryNode v5DiRef : dataItemRefs = aggregateExpr.getDescendantsOfType(101015, true)) {
                V5DataItemRef diRef = (V5DataItemRef)v5DiRef;
                if (!diRef.getDataItemRefProperty().equals(this.getNameProperty())) continue;
                diRef.exchange(environment.getNodeFactory().deepCopyNode(this.getChild(0)));
            }
        }
        if (aggregateExpr == null && (originalDataItem = (V5DataItem)this.getPropertyValue(PROP_ORIGINAL_V5DATAITEM)) != null) {
            return originalDataItem.getAggregateExpression(environment);
        }
        return aggregateExpr;
    }

    public IXQEQueryNode getDetailContext(PlanningEnvironment environment) {
        IXQEQueryNode detailContext = (IXQEQueryNode)this.getPropertyValue(PROP_DETAIL_CONTEXT);
        if (detailContext != null) {
            if (detailContext.getType() == 101015 && ((V5DataItemRef)detailContext).getDataItemRefProperty().equals(this.getNameProperty())) {
                detailContext = environment.getNodeFactory().deepCopyNode(this.getDetailExpression());
            }
            return environment.getNodeFactory().deepCopyNode(detailContext);
        }
        V5DataItem originalDataItem = (V5DataItem)this.getPropertyValue(PROP_ORIGINAL_V5DATAITEM);
        if (originalDataItem != null) {
            return originalDataItem.getDetailContext(environment);
        }
        return null;
    }

    @Override
    public String getFormat() {
        String formatString = (String)this.getPropertyValue(PROP_STRING_CUSTOM_FORMAT);
        if (formatString == null) {
            formatString = super.getFormat();
        }
        return formatString;
    }

    @Override
    public void formatForMessage(StringBuilder sb) {
        V5Query v5Query = (V5Query)this.getAncestorOfType(101006);
        v5Query.formatForMessage(sb);
        sb.append(':');
        sb.append(' ');
        super.formatForMessage(sb, this.getV5ElementName(), this.getNameProperty());
        sb.append(':');
        sb.append(' ');
        V5Expression exp = (V5Expression)this.getDetailExpression();
        StringBuilder expSB = new StringBuilder();
        exp.writeFormattedText(expSB);
        XQEMessage.appendQuotedItem(sb, expSB.toString());
    }

    public String getFullName() {
        V5Query v5Query = (V5Query)this.getAncestorOfType(101006);
        if (v5Query != null) {
            return UniqueNameGenerator.createEscapedUniqueName(v5Query.getV5QueryName(), this.getNameProperty());
        }
        return UniqueNameParser.escapeSquareBrackets(this.getNameProperty());
    }

    @Override
    public V5QueryNode getEffectiveNodeForMessage() {
        return this;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode child = this.getChild(0);
        while (!child.isOfCategory(201120)) {
            if (child.getNumberChildren() != 1) {
                this.throwOnInvalidChildCategories();
            }
            child = child.getChild(0);
        }
        child.writeFormattedText(buffer);
    }

    public String getNameProperty() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public void setNameProperty(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    public String getModelCalculationID() {
        return (String)this.getPropertyValue(PROP_MODEL_CALCULATION_ID);
    }

    public void setModelCalculationID(String value) {
        if (value == null || value.isEmpty()) {
            this.removeProperty(PROP_MODEL_CALCULATION_ID);
        }
        this.setPropertyValue(PROP_MODEL_CALCULATION_ID, value);
    }

    public void setIsProjected() {
        this.setPropertyValue(PROP_IS_PROJECTED, true);
    }

    public boolean getIsProjected() {
        return this.getPropertyValue(PROP_IS_PROJECTED) != null;
    }

    public void setIsReferenced() {
        this.setPropertyValue(PROP_IS_REFERENCED, true);
    }

    public void setErrorCell() {
        this.setPropertyValue(PROP_IS_ERROR_CELL, true);
    }

    public void setIsOriginal() {
        this.setPropertyValue(PROP_IS_ORIGINAL, true);
    }

    public void setReferencesWalked() {
        this.setPropertyValue(PROP_REFERENCES_WALKED, Boolean.TRUE);
    }

    public boolean referencesWalked() {
        return this.getBooleanPropertyValue(PROP_REFERENCES_WALKED) == Boolean.TRUE;
    }

    public boolean isReferenced() {
        return this.getBooleanPropertyValue(PROP_IS_REFERENCED) == Boolean.TRUE;
    }

    public boolean isErrorCell() {
        return this.getBooleanPropertyValue(PROP_IS_ERROR_CELL) == Boolean.TRUE;
    }

    public boolean isOriginal() {
        return this.getBooleanPropertyValue(PROP_IS_ORIGINAL) == Boolean.TRUE;
    }

    public String getOriginalDistinctItem() {
        return (String)this.getPropertyValue(PROP_STRING_DISTINCT_MUN);
    }

    public void setOriginalDistinctItem(String nameDataItem) {
        this.setPropertyValue(PROP_STRING_DISTINCT_MUN, nameDataItem);
    }

    public V5DataItem getOriginalV5DataItem() {
        return (V5DataItem)this.getPropertyValue(PROP_ORIGINAL_V5DATAITEM);
    }

    public void setOriginalV5DataItem(V5DataItem originalV5DataItem) {
        this.setPropertyValue(PROP_ORIGINAL_V5DATAITEM, originalV5DataItem);
    }

    @Override
    public MDXLevelInfo getHierarchyLevelInfo(MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        return this.getChildByIndexHierarchyLevelInfo(0, forHierarchy, fncs);
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        if (this.getNumberChildren() >= 1) {
            IXQEQueryNode childNode = this.getChild(0);
            while (childNode.getType() == 101003) {
                childNode = childNode.getChild(0);
            }
            if (childNode.getType() == 101004) {
                childNode = childNode.getChild(0);
            }
            hierInfo = ((V5SimpleNode)childNode).getHierarchyInfo();
        }
        return hierInfo;
    }

    public Boolean getPropPreserveMetadata() {
        return this.getBooleanPropertyValue(PROP_PRESERVE_METADATA, Boolean.FALSE);
    }

    public void setPropPreserveMetadata(Boolean value) {
        this.setPropertyValue(PROP_PRESERVE_METADATA, value);
    }

    public void setPropIsRollupExpression(Boolean value) {
        this.setPropertyValue(PROP_IS_ROLLUP_EXPRESSION, value);
    }

    public boolean getPropIsRollupExpression() {
        Boolean bool = this.getBooleanPropertyValue(PROP_IS_ROLLUP_EXPRESSION);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public V5Expression getExpression() {
        IXQEQueryNode[] expressions = this.getChildrenOfType(101004);
        if (expressions != null && expressions.length > 0) {
            return (V5Expression)expressions[0];
        }
        return null;
    }

    public IXQEQueryNode getExpression(boolean skipV5Expression) {
        IXQEQueryNode child = this.getChild(0);
        if (child.getType() == 101004 && skipV5Expression) {
            child = child.getChild(0);
        }
        return child;
    }

    public IXQEQueryNode getExpr() {
        IXQEQueryNode child = this.getChild(0);
        while (child.getType() == 101003) {
            child = child.getChild(0);
        }
        if (child.getType() == 201060) {
            return ((V5BoundDataItemReference)child).getReferencedExpression();
        }
        if (child.getType() == 101004) {
            return child.getChild(0);
        }
        if (child.isOfCategory(201120)) {
            return child;
        }
        return null;
    }

    public IDataType getCastDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_CAST_DATATYPE);
    }

    public void setCastDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_CAST_DATATYPE, dataType);
    }

    public void setContextProperty(String[] context) {
        if (context != null && context.length > 0) {
            this.setPropertyValue(PROP_CONTEXT, context);
            return;
        }
        this.removeProperty(PROP_CONTEXT);
    }

    public String[] getContextProperty() {
        return (String[])this.getPropertyValue(PROP_CONTEXT);
    }

    public void setShowAllProperty(boolean value) {
        if (!value) {
            this.removeProperty(PROP_SHOW_ALL);
            return;
        }
        this.setPropertyValue(PROP_SHOW_ALL, Boolean.TRUE);
    }

    public Boolean getShowAllProperty() {
        return this.getBooleanPropertyValue(PROP_SHOW_ALL);
    }

    public V5QuerySet getShowAllSubQuerySet() {
        return (V5QuerySet)this.getPropertyValue("subQuerySet");
    }

    public void setShowAllSubQuerySet(V5QuerySet subQuerySet) {
        if (null == subQuerySet) {
            this.removeProperty("subQuerySet");
            return;
        }
        this.setPropertyValue("subQuerySet", subQuerySet);
    }

    private String[] parseContextList(String contextList) {
        ArrayList<String> list = new ArrayList<String>();
        String openBracket = "[";
        String closeBracket = "]";
        String escCloseBracket = "]]";
        String semicolon = ";";
        String dataItemNameList = contextList;
        while (!dataItemNameList.isEmpty()) {
            int start = dataItemNameList.indexOf("[") + 1;
            if (start == -1) {
                throw new IllegalStateException("Missing [ before data item name.");
            }
            int end = dataItemNameList.indexOf("]", start);
            if (end == -1) {
                throw new IllegalStateException("Missing ] after data item name.");
            }
            while (dataItemNameList.length() - 1 > end && dataItemNameList.substring(end + 1, end + 2).equals("]")) {
                ++end;
            }
            if (dataItemNameList.length() - 1 > end && !dataItemNameList.substring(end + 1, end + 2).equals(";")) {
                throw new IllegalStateException("Missing ; delimiter.");
            }
            String dataItemName = dataItemNameList.substring(start, end);
            if (!dataItemName.isEmpty()) {
                dataItemName = dataItemName.replaceAll("]]", "]");
                list.add(dataItemName);
            }
            if (dataItemNameList.length() - 1 == end) break;
            dataItemNameList = dataItemNameList.substring(end + 1);
        }
        return list.toArray(new String[0]);
    }

    public boolean isModuleCalculation() {
        return this.getBooleanPropertyValue(PROP_IS_MODULE_CALCULATION) == Boolean.TRUE;
    }

    public void setModuleCalculation(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_IS_MODULE_CALCULATION, Boolean.TRUE);
        } else {
            this.removeProperty(PROP_IS_MODULE_CALCULATION);
        }
    }

    public void setCalculationExpression() {
        IXQEQueryNode child;
        if (this.getNumberChildren() > 0 && (child = this.getChild(0)).getType() == 101004 && child.getNumberChildren() > 0 && (child = child.getChild(0)).isOfCategory(201125) && !child.isOfCategory(201026)) {
            this.setPropertyValue(PROP_CALCULATION_EXPRESSION, this.environment.getNodeFactory().deepCopyNode(child));
        }
    }

    public IXQEQueryNode getCalculationExpression() {
        return (IXQEQueryNode)this.getPropertyValue(PROP_CALCULATION_EXPRESSION);
    }

    public Boolean isMixedDMRRelational() {
        return (Boolean)this.getPropertyValue("mixedDMRRelational");
    }

    public void setMixedDMRRelational(Boolean mixedDMRRelational) {
        if (mixedDMRRelational == null) {
            this.removeProperty("mixedDMRRelational");
            return;
        }
        this.setPropertyValue("mixedDMRRelational", mixedDMRRelational);
    }
}

