/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5BaseExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5FilterExpression
extends V5BaseExpression {
    public static final String NODE_TYPE_NAME = "V5FilterExpression";
    public static final String V5_NODE_NAME = "filterExpression";

    @Override
    public int getType() {
        return 101013;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!attname.equals("rID")) continue;
            this.setStringPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5LogicalExpression") || childname.equals("V5BetweenExpression") || childname.equals("V5ComparisonExpression") || childname.equals("V5ContainsExpression") || childname.equals("V5InExpression")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
        if (readV5SpecFormat) {
            this.setStringPropertyValue("expression", inputNode.getText());
        }
    }
}

