/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5JoinOperand;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5JoinOperation
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5JoinOperation";
    public static final String V5_NODE_NAME = "joinOperation";
    private static final String JOIN_FILTER = "joinFilter";
    private static final String JOIN_OPERANDS = "joinOperands";
    private static final String JOIN_TYPE = "joinType";
    private static final String APPLY_FILTER_JOIN = "applyFilterJoin";
    private static final String FILTER_TYPE = "filterType";
    public static final String JOIN_FILTER_TYPE = "joinFilterType";
    public static final String FJO_ADVANCED = "fjoAdvanced";

    @Override
    public int getType() {
        return 101019;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        if (inputNode.attributeCount() > 0) {
            Attribute att = inputNode.attribute(0);
            String attname = att.getName();
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(JOIN_FILTER) || childname.equals(JOIN_OPERANDS)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals(APPLY_FILTER_JOIN)) {
                this.setPropertyValue(JOIN_FILTER_TYPE, (Object)this.convertToJoinFilterType(child.attributeValue(FILTER_TYPE)));
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    private IRelationship.JoinFilterType convertToJoinFilterType(String attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            return IRelationship.JoinFilterType.FILTER_TYPE_NONE;
        }
        if ("in".equals(attributeValue) || "IN".equals(attributeValue)) {
            return IRelationship.JoinFilterType.FILTER_TYPE_IN;
        }
        if ("between".equals(attributeValue) || "BETWEEN".equals(attributeValue)) {
            return IRelationship.JoinFilterType.FILTER_TYPE_BETWEEN;
        }
        if ("table".equals(attributeValue) || "TABLE".equals(attributeValue)) {
            return IRelationship.JoinFilterType.FILTER_TYPE_TABLE;
        }
        return IRelationship.JoinFilterType.FILTER_TYPE_NONE;
    }

    public void setJoinType(SQLJoin.SubType type) {
        this.setPropertyValue(JOIN_TYPE, (Object)type);
    }

    public SQLJoin.SubType getJoinType() {
        return (SQLJoin.SubType)((Object)this.getPropertyValue(JOIN_TYPE));
    }

    public Set<String> getJoinOperandNames() {
        List<IXQEQueryNode> joinOperands = this.getDescendantsOfTypeOrdered(101021, false);
        if (joinOperands == null || joinOperands.size() == 0) {
            return null;
        }
        LinkedHashSet<String> joinOperandNames = new LinkedHashSet<String>();
        for (IXQEQueryNode node : joinOperands) {
            String queryRef = ((V5JoinOperand)node).getQueryRef();
            if (queryRef == null || queryRef.isEmpty()) {
                String queryName = ((V5Query)this.getParent().getParent()).getV5QueryName();
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidJoinOperand, queryName);
            }
            joinOperandNames.add(queryRef);
        }
        return joinOperandNames;
    }

    public IXQEQueryNode getJoinFilterExpressionNode() {
        return this.getChild(2);
    }

    public IRelationship.JoinFilterType getJoinFilterType() {
        IRelationship.JoinFilterType joinFilterType = (IRelationship.JoinFilterType)((Object)this.getPropertyValue(JOIN_FILTER_TYPE));
        if (joinFilterType == null) {
            return IRelationship.JoinFilterType.FILTER_TYPE_NONE;
        }
        return joinFilterType;
    }

    public String getFJOAdvancedProperty() {
        return (String)this.getPropertyValue(FJO_ADVANCED);
    }
}

