/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.util.Governors;
import com.cognos.xqemoser.MoserDataSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5Query
extends V5QueryNode {
    public static final String MINIMIZE_LOCAL = "minimizeLocal";
    public static final String DATABASE_ONLY = "databaseOnly";
    public static final String LIMITEDLOCAL = "limitedLocal";
    public static final String NODE_TYPE_NAME = "V5Query";
    public static final String V5_NODE_NAME = "query";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_BOOLEAN_CUBE_IS_REQUIRED = "CubeIsRequired";
    public static final String QUERY_INTENT_METADATA = "metadata";
    public static final String PROP_BOOLEAN_IS_TABULAR = "isTabular";
    public static final String PROP_BOOLEAN_IS_RELSTYLE = "isRelStyle";
    public static final String PROP_BOOLEAN_HAS_OLAP_OPERAND = "hasOlapOperand";
    public static final String PROP_BOOLEAN_IS_DMR = "isDMR";
    public static final String PROP_BOOLEAN_IS_ROLAP = "isROLAP";
    public static final String PROP_BOOLEAN_IS_DMR_TO_RQP = "isDMRtoRQP";
    public static final String PROP_BOOLEAN_IS_DMR_V5_TO_LOAD_MEMBER = "isDMRV5toLoadMember";
    public static final String PROP_BOOLEAN_IS_PARTIAL_QUERYRESULT = "partialQueryResult";
    public static final String PROP_BOOLEAN_SINGLE_QUERY_MASTER_DETAIL = "singleQueryMasterDetail";
    public static final String PROP_ORIGINAL_V5QUERY = "originalV5Query";
    public static final String PROP_STRING_ROOT_QUERY_NAME = "rootQueryName";
    public static final String PROP_BOOLEAN_RELATIONAL_SUBQUERY = "relationalSubquery";
    public static final String PROP_BOOLEAN_SINGLE_CUBE_LOADING = "singleLoadingCubeFromDMR";
    public static final String PROP_ROWSTITCH = "rowStitch";
    public static final String PROP_SKIP_PARAMETERS_VALIDATION = "skipParametersValidation";
    public static final String PROP_STRING_RELATIONAL_SUBQUERY_SOURCE = "relationalSubquerySource";
    public static final String PROP_ALL_JOINS = "allJoins";
    public static final String PROP_PREFERREDMODELITEMS = "preferredModelItems";
    public static final String CURSOR_MODE = "cursorMode";
    private static final String PROP_MODEL_DATA_SOURCE = "dataSource";
    private static final String SOURCE = "source";
    private static final String SELECTION = "selection";
    private static final String XMLATTRIBUTES = "XMLAttributes";
    private static final String SLICER = "slicer";
    private static final String DIMENSION_INFO = "dimensionInfo";
    private static final String DETAIL_FILTERS = "detailFilters";
    private static final String SUMMARY_FILTERS = "summaryFilters";
    private static final String MEMBERSET_STRUCTUTRE = "memberSetStructure";
    public static final String QUERY_HINTS = "queryHints";
    private static final String VALUE = "value";
    public static final String PROP_CONTAINS_QUERY_HINT = "containsQueryHint";
    private static final String PROP_IS_REFERENCED = "isReferenced";
    private static final String PROP_REFERENCES_WALKED = "referencesWalked";
    private static final String PROP_IS_DISTINCT = "isDistinct";
    public static final String PROP_IS_PARSED = "isParsed";
    public static final String PROP_IS_MULTIPARTIDENTIFIER_BOUND = "isBound";
    public static final String PROP_BOOL_REFERENCED_BY_ROOT_QRD = "referencedByRootQRD";
    public static final String PROP_REFERENCE_COUNT = "refCount";
    public static final String PROP_REFERENCE_BY_IN_PREDICATE = "refByInPredicate";
    public static final String PROP_REL_OVER_DMR = "REL_OVER_DMR";
    public static final String PROP_BOOLEAN_MODEL_SECURITY_CHECK_REQUIRED = "modelSecurityCheckRequired";
    public static final String PROP_REFERENCING_ROOT_QRD = "rootQRDName";
    public static final String PROP_ORIGINAL_QUERY_NAME = "originalQueryName";
    public static final String QUERY_USES_BRIDGE = "queryUsesBridge";
    public static final String PROP_TABLE_SAMPLING_TABLE = "tableSamplingTable";
    public static final String PROP_TABLE_SAMPLING_METHOD = "tableSamplingMethod";
    public static final String PROP_TABLE_SAMPLING_PERCENT = "tableSamplingPercent";
    public static final String PROP_TABLE_SAMPLING_ROW_COUNT = "tableSamplingRowCount";
    public static final String PROP_TABLE_SAMPLING_SEED = "tableSamplingSeed";
    public static final String PROP_TABLE_SAMPLING_THROW_ON_SUBQUERY = "tableSamplingThrowOnSubquery";
    public static final String PROP_IS_STATS_QUERY = "isStatsQuery";
    public static final String PROP_BOOLEAN_UNWOUND = "unwound";
    public static final String STR_DYNAMIC_SCOPED_TO_PROP = "DynamicScopedTo";
    public static final String PROP_PREFERRED_JOINS = "preferredJoins";
    public static final String PROP_SOURCE_MODULE = "sourceModule";
    public static final String PROP_BOOL_TESTJOINS = "queryForTestJoin";
    private static final String PROP_QS_TO_JOIN = "qsToJoin";
    public static final String PROP_XMLATTRS = "xmlAttributes";
    public static final String PROP_EXPANDED_CALCS = "expandedCalcs";

    @Override
    public int getType() {
        return 101006;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public String getV5ElementName() {
        return V5_NODE_NAME;
    }

    @Override
    public void formatForMessage(StringBuilder sb) {
        super.formatForMessage(sb, this.getV5ElementName(), this.getV5QueryName());
    }

    @Override
    public V5QueryNode getEffectiveNodeForMessage() {
        return this;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_NAME)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_BOOLEAN_CUBE_IS_REQUIRED)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_BOOL_TESTJOINS)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) {
                if (attname.equals("governors")) {
                    this.captureGovernors(env, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.LOCAL_CACHE.getPropertyName())) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_CONTAINS_QUERY_HINT)) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_BOOLEAN_RELATIONAL_SUBQUERY)) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_STRING_RELATIONAL_SUBQUERY_SOURCE)) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_BOOLEAN_SINGLE_CUBE_LOADING)) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.DASHBOARD.getPropertyName())) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.IGNORE_FILTERS_NOT_APPLICABLE.getPropertyName())) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_BOOLEAN_IS_TABULAR)) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.TREAT_EMPTY_DMR_MUN.getPropertyName())) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_SOURCE_MODULE)) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_IS_REFERENCED)) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.DATA_CACHE_EXPIRY.getPropertyName())) {
                    if ("automatic".equalsIgnoreCase(att.getValue())) continue;
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.DATA_CACHE_USE_POLICY.getPropertyName())) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.TABLE_SAMPLING_METHOD.getPropertyName())) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.TABLE_SAMPLING_ROW_COUNT.getPropertyName())) {
                    this.setIntegerPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.TABLE_SAMPLING_SEED.getPropertyName())) {
                    this.setIntegerPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.TABLE_SAMPLING_PERCENT.getPropertyName())) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.TABLE_SAMPLING_THROW_ON_SUBQUERY.getPropertyName())) {
                    this.setBooleanPropertyValue(attname, att.getValue());
                    continue;
                }
                if (attname.equals(QueryHint.IS_STATS_QUERY.getPropertyName())) {
                    this.setStringPropertyValue(attname, att.getValue());
                    continue;
                }
                if (!attname.equals(QueryHint.USE_SQL_WITH_CLAUSE.getPropertyName())) continue;
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            String grandchildname;
            Element grandchild;
            List grandchildren;
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(DETAIL_FILTERS) || childname.equals(SUMMARY_FILTERS) || childname.equals(MEMBERSET_STRUCTUTRE)) {
                grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    grandchild = (Element)grandchildren.get(j);
                    grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals(SOURCE) || childname.equals(SELECTION) || childname.equals(SLICER) || childname.equals(DIMENSION_INFO) || childname.equals("V5Source") || childname.equals("V5Selection") || childname.equals("V5Slicer") || childname.equals("V5DetailFilter") || childname.equals("V5SummaryFilter") || childname.equals("V5MemberSet")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals(QUERY_HINTS)) {
                grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    List<String> joins;
                    grandchild = (Element)grandchildren.get(j);
                    grandchildname = grandchild.getName();
                    String grandchildValue = grandchild.attributeValue(VALUE);
                    if (grandchildValue == null) {
                        if (grandchildname.equals(QueryHint.ALLJOINS.getPropertyName())) {
                            joins = this.readAllJoins(grandchild);
                            grandchildValue = String.valueOf(joins);
                        } else if (grandchildname.equals(QueryHint.PREFERREDMODELITEMS.getPropertyName())) {
                            List<String> prefQS = this.readPreferredQS(grandchild);
                            grandchildValue = String.valueOf(prefQS);
                        } else {
                            grandchildValue = grandchild.getText();
                        }
                    }
                    TraceLogManager.getInstance().logQueryHint((IRequestEnvironment)this.getPlanningEnvironment().getRequestEnvironment(), grandchild.getName(), grandchildValue);
                    if (grandchildname.equals(QueryHint.USE_FOR_PARAMETER_INFO.getPropertyName()) || grandchildname.equals(QueryHint.USE_V4_INTERPRETATION.getPropertyName())) {
                        if (grandchild.attributeValue(VALUE) == null) {
                            this.setBooleanPropertyValue(grandchildname, Boolean.FALSE.toString());
                        } else {
                            this.setBooleanPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        }
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.AVOID_ZERODIV.getPropertyName()) || grandchildname.equals(QueryHint.USE_SQL_WITH_CLAUSE.getPropertyName()) || grandchildname.equals(QueryHint.LOCAL_CACHE.getPropertyName()) || grandchildname.equals(QueryHint.USE_AGGREGGATE_CACHE.getPropertyName()) || grandchildname.equals(QueryHint.USE_SAP_MUN_AS_BUSINESS_KEY.getPropertyName()) || grandchildname.equals(QueryHint.RELATIONAL_SUBQUERY.getPropertyName()) || grandchildname.equals(QueryHint.IGNORE_FILTERS_NOT_APPLICABLE.getPropertyName()) || grandchildname.equals(QueryHint.REPORT_AS_DATASOURCE.getPropertyName()) || grandchildname.equals(QueryHint.TABLE_SAMPLING_THROW_ON_SUBQUERY.getPropertyName())) {
                        this.setBooleanPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.AUTOSORT.getPropertyName()) || grandchildname.equals(QueryHint.EXECUTION_OPTIMIZATION.getPropertyName()) || grandchildname.equals(QueryHint.QUERY_PROCESSING.getPropertyName()) || grandchildname.equals(QueryHint.OUTERJOIN_ALLOWED.getPropertyName()) || grandchildname.equals(QueryHint.CROSS_PRODUCT_ALLOWED.getPropertyName()) || grandchildname.equals(QueryHint.SUPPRESS.getPropertyName()) || grandchildname.equals(QueryHint.DASHBOARD.getPropertyName()) || grandchildname.equals(QueryHint.ROLLUP_PROCESSING.getPropertyName()) || grandchildname.equals(QueryHint.EXECUTION_METHOD.getPropertyName()) || grandchildname.equals(QueryHint.QUERY_INTENT.getPropertyName()) || grandchildname.equals(QueryHint.MEASURE_REFINER.getPropertyName()) || grandchildname.equals(QueryHint.EXACT_NUMERIC_DIVISION.getPropertyName()) || grandchildname.equals(QueryHint.GROUPBY_OPTIMIZATION.getPropertyName()) || grandchildname.equals(QueryHint.CONTEXT_SENSITIVE_JOIN_SELECTION.getPropertyName()) || grandchildname.equals(QueryHint.CURSORMODE.getPropertyName()) || grandchildname.equals(QueryHint.USE_SQL_PARAMETERS.getPropertyName()) || grandchildname.equals(QueryHint.SUPPRESS_DUPLICATE_MEASURE_VALUES.getPropertyName()) || grandchildname.equals(QueryHint.SQLWINDOWFUNCTION_GENERATION.getPropertyName()) || grandchildname.equals(QueryHint.SUMMARYQUERY_JOIN_OPERATOR.getPropertyName()) || grandchildname.equals(QueryHint.TABLE_SAMPLING_TABLE.getPropertyName()) || grandchildname.equals(QueryHint.TABLE_SAMPLING_METHOD.getPropertyName()) || grandchildname.equals(QueryHint.TABLE_SAMPLING_PERCENT.getPropertyName()) || grandchildname.equals(QueryHint.DATASET_MODULE_TYPE.getPropertyName()) || grandchildname.equals(QueryHint.DATA_CACHE_USE_POLICY.getPropertyName()) || grandchildname.equals(QueryHint.TREAT_EMPTY_DMR_MUN.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.MAX_ROWS_RETRIEVED.getPropertyName()) || grandchildname.equals(QueryHint.MAX_TABLES_PER_QUERY.getPropertyName()) || grandchildname.equals(QueryHint.MAX_QUERY_EXECUTION_TIME.getPropertyName()) || grandchildname.equals(QueryHint.MAX_TEXT_BLOB_CHARACTERS.getPropertyName())) {
                        this.setIntegerPropertyValueWithRules(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.MAX_TABLE_NAME_LENGTH.getPropertyName()) || grandchildname.equals(QueryHint.TABLE_SAMPLING_ROW_COUNT.getPropertyName()) || grandchildname.equals(QueryHint.TABLE_SAMPLING_SEED.getPropertyName()) || grandchildname.equals(QueryHint.FJO_MAX_KEYS.getPropertyName())) {
                        this.setIntegerPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.ALLJOINS.getPropertyName())) {
                        joins = this.readAllJoins(grandchild);
                        this.setPropertyValue(grandchildname, joins);
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.PREFERREDMODELITEMS.getPropertyName())) {
                        List<String> qs = this.readPreferredQS(grandchild);
                        this.setPropertyValue(grandchildname, qs);
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.DATA_CACHE_EXPIRY.getPropertyName())) {
                        if ("automatic".equalsIgnoreCase(grandchild.attributeValue(VALUE))) continue;
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.MAX_OOM_MDX_RESULT.getPropertyName())) {
                        this.setPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.USE_VECTORIZED_QUERY_EXECUTION.getPropertyName())) {
                        this.setPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.GENERATE_SUBQUERY_FOR_CALCS.getPropertyName())) {
                        this.setPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(QueryHint.PROCESS_NULL_CONSUMERS_AFTER_JOIN.getPropertyName())) {
                        this.setPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    V5InvalidElementException e = new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, grandchildname, childname);
                    ExecutionEnvironment ee = (ExecutionEnvironment)env.getExecutionEnvironment();
                    ee.addNag(e.getLocalizedMessage());
                }
                continue;
            }
            if (childname.equals(XMLATTRIBUTES)) {
                List xmlAttrs = child.elements();
                TreeMap<String, String> xmlAttrProp = null;
                for (Element a : xmlAttrs) {
                    String aEleName = a.getName();
                    if (!aEleName.equals("XMLAttribute")) continue;
                    String nm = a.attributeValue(PROP_STRING_NAME);
                    String v = a.attributeValue(VALUE);
                    if (nm == null || v == null) continue;
                    if (xmlAttrProp == null) {
                        xmlAttrProp = new TreeMap<String, String>();
                        this.setPropertyValue(PROP_XMLATTRS, xmlAttrProp);
                    }
                    xmlAttrProp.put(nm, v);
                }
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public void captureGovernors(PlanningEnvironment env, String governors) {
        if (governors.contains("localCache:false")) {
            this.setBooleanPropertyValue(QueryHint.LOCAL_CACHE.getPropertyName(), Boolean.FALSE.toString());
            this.setBooleanPropertyValue(PROP_CONTAINS_QUERY_HINT, Boolean.TRUE.toString());
        }
    }

    public V5Selection getV5Selection() {
        V5Query originalV5Query = (V5Query)this.getPropertyValue(PROP_ORIGINAL_V5QUERY);
        if (originalV5Query != null) {
            return originalV5Query.getV5Selection();
        }
        return (V5Selection)this.getFirstChildByType(101009);
    }

    public V5Source getV5Source() {
        return (V5Source)this.getFirstChildByType(101007);
    }

    public IXQEQueryNode[] getV5SummaryFilters() {
        V5Query originalV5Query = (V5Query)this.getPropertyValue(PROP_ORIGINAL_V5QUERY);
        if (originalV5Query != null) {
            return originalV5Query.getV5SummaryFilters();
        }
        return this.getChildrenOfType(101011);
    }

    public IXQEQueryNode[] getV5DetailFilters() {
        V5Query originalV5Query = (V5Query)this.getPropertyValue(PROP_ORIGINAL_V5QUERY);
        if (originalV5Query != null) {
            return originalV5Query.getV5DetailFilters();
        }
        return this.getChildrenOfType(101008);
    }

    public IXQEQueryNode[] getV5Slicers() {
        V5Query originalV5Query = (V5Query)this.getPropertyValue(PROP_ORIGINAL_V5QUERY);
        if (originalV5Query != null) {
            return originalV5Query.getV5Slicers();
        }
        return this.getChildrenOfType(101010);
    }

    public boolean isTabular() {
        return this.getPropertyValue(PROP_BOOLEAN_IS_TABULAR) == Boolean.TRUE;
    }

    public boolean isMoserDataSource() {
        return this.getModelDataSource() != null && this.getModelDataSource() instanceof MoserDataSource;
    }

    public boolean isRelStyle() {
        return this.getPropertyValue(PROP_BOOLEAN_IS_RELSTYLE) == Boolean.TRUE;
    }

    public boolean isDMR() {
        if (this.getPropertyValue(PROP_BOOLEAN_IS_DMR) == null) {
            return false;
        }
        return this.getPropertyValue(PROP_BOOLEAN_IS_DMR) == Boolean.TRUE;
    }

    public boolean isRelationalSubquery() {
        return this.getPropertyValue(PROP_BOOLEAN_RELATIONAL_SUBQUERY) == Boolean.TRUE;
    }

    public boolean isROLAP() {
        if (this.getPropertyValue(PROP_BOOLEAN_IS_ROLAP) == null) {
            return false;
        }
        return this.getPropertyValue(PROP_BOOLEAN_IS_ROLAP) == Boolean.TRUE;
    }

    public boolean isDMRtoRQP() {
        if (this.getPropertyValue(PROP_BOOLEAN_IS_DMR_TO_RQP) == null) {
            return false;
        }
        return this.getPropertyValue(PROP_BOOLEAN_IS_DMR_TO_RQP) == Boolean.TRUE;
    }

    public boolean isDMRMemberQuery() {
        if (this.getPropertyValue(PROP_BOOLEAN_IS_DMR_V5_TO_LOAD_MEMBER) == null) {
            return false;
        }
        return this.getPropertyValue(PROP_BOOLEAN_IS_DMR_V5_TO_LOAD_MEMBER) == Boolean.TRUE;
    }

    public boolean hasOlapOperand() {
        return this.getPropertyValue(PROP_BOOLEAN_HAS_OLAP_OPERAND) == Boolean.TRUE;
    }

    public String getV5QueryName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public void setV5QueryName(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    public boolean containsQueryHints() {
        Object obj = this.getPropertyValue(PROP_CONTAINS_QUERY_HINT);
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public void setIsReferenced() {
        this.setPropertyValue(PROP_IS_REFERENCED, true);
    }

    public boolean isReferenced() {
        return this.getBooleanPropertyValue(PROP_IS_REFERENCED) == Boolean.TRUE;
    }

    public void setReferencesWalked() {
        this.setPropertyValue(PROP_REFERENCES_WALKED, Boolean.TRUE);
    }

    public boolean referencesWalked() {
        return this.getBooleanPropertyValue(PROP_REFERENCES_WALKED) == Boolean.TRUE;
    }

    public boolean isSingleQueryMasterDetail() {
        return Boolean.TRUE.equals(this.getBooleanPropertyValue(PROP_BOOLEAN_SINGLE_QUERY_MASTER_DETAIL));
    }

    public void setSingleQueryMasterDetail(boolean isSingleQueryMasterDetail) {
        this.setPropertyValue(PROP_BOOLEAN_SINGLE_QUERY_MASTER_DETAIL, isSingleQueryMasterDetail);
    }

    @Override
    public boolean isValueOptionalForProperty(String propName) {
        return propName.equals(QueryHint.MAX_ROWS_RETRIEVED.getPropertyName()) || propName.equals(QueryHint.MAX_TABLES_PER_QUERY.getPropertyName()) || propName.equals(QueryHint.MAX_QUERY_EXECUTION_TIME.getPropertyName()) || propName.equals(QueryHint.MAX_TEXT_BLOB_CHARACTERS.getPropertyName());
    }

    public boolean getDistinct() {
        Boolean b = this.getBooleanPropertyValue(PROP_IS_DISTINCT);
        return b != null && b != false;
    }

    public void setDistinct(boolean b) {
        this.setPropertyValue(PROP_IS_DISTINCT, b);
    }

    public V5Query getOriginalV5Query() {
        V5Query originalV5Query = (V5Query)this.getPropertyValue(PROP_ORIGINAL_V5QUERY);
        if (originalV5Query != null) {
            return originalV5Query;
        }
        return this;
    }

    public void setOriginalV5Query(V5Query originalV5Query) {
        this.setPropertyValue(PROP_ORIGINAL_V5QUERY, originalV5Query);
    }

    public Set<String> getSubQueryNames(PlanningEnvironment environment) {
        IXQEQueryNode queryOperationNode;
        Set<String> joinOperands;
        HashSet<String> subQueryNames = new HashSet<String>();
        V5Source source = this.getV5Source();
        if (source == null) {
            return subQueryNames;
        }
        Set<String> queryRefs = source.getReferencedQueries();
        if (queryRefs != null && queryRefs.size() > 0) {
            subQueryNames.addAll(queryRefs);
        }
        if (source.getNumberChildren() == 0) {
            return subQueryNames;
        }
        IXQEQueryNode joinNode = source.getFirstChildByType(101019);
        if (joinNode != null && (joinOperands = ((V5JoinOperation)joinNode).getJoinOperandNames()) != null) {
            subQueryNames.addAll(joinOperands);
        }
        if ((queryOperationNode = source.getFirstChildByType(101018)) != null) {
            V5Query[] v5QueryRefs;
            for (V5Query query : v5QueryRefs = ((V5QueryOperation)queryOperationNode).getReferencedV5Queries(environment)) {
                subQueryNames.add(query.getV5QueryName());
                query.setRootQueryName(this.getRootQueryName());
            }
        }
        return subQueryNames;
    }

    public void getAllSubQueryNames(Set<String> queryRefs, V5QuerySet querySet, PlanningEnvironment environment) {
        Set<String> newQueryRefs = this.getSubQueryNames(environment);
        for (String subQueryRef : newQueryRefs) {
            if (queryRefs.contains(subQueryRef)) continue;
            queryRefs.add(subQueryRef);
            V5Query subQuery = querySet.getV5Query(subQueryRef);
            if (subQuery == null) continue;
            subQuery.getAllSubQueryNames(queryRefs, querySet, environment);
        }
    }

    public IXQEQueryNode getQueryPlan() {
        IXQEQueryNode[] queryChildren = this.getChildren();
        for (int i = 0; i < queryChildren.length; ++i) {
            IXQEQueryNode queryChild = queryChildren[i];
            if (queryChild.isOfCategory(101064) || queryChild.getType() == 801046) continue;
            return queryChild;
        }
        return null;
    }

    public void initializeCount() {
        this.setPropertyValue(PROP_REFERENCE_COUNT, 0);
    }

    public int getCount() {
        return (Integer)this.getPropertyValue(PROP_REFERENCE_COUNT);
    }

    public void incrementCount() {
        this.setPropertyValue(PROP_REFERENCE_COUNT, this.getCount() + 1);
    }

    public void decrementCount() {
        this.setPropertyValue(PROP_REFERENCE_COUNT, this.getCount() - 1);
    }

    public String getRootQueryName() {
        String queryName = (String)this.getPropertyValue(PROP_STRING_ROOT_QUERY_NAME);
        if (queryName == null) {
            queryName = this.getV5QueryName();
        }
        return queryName;
    }

    public void setRootQueryName(String rootQueryName) {
        this.setPropertyValue(PROP_STRING_ROOT_QUERY_NAME, rootQueryName);
    }

    public IModelDataSource getModelDataSource() {
        return (IModelDataSource)this.getPropertyValue(PROP_MODEL_DATA_SOURCE);
    }

    public void setModelDataSource(IModelDataSource modelDataSource) {
        this.setPropertyValue(PROP_MODEL_DATA_SOURCE, modelDataSource);
    }

    public List<IMetadata> getPropertyAllJoins(PlanningEnvironment planningEnv) {
        Object allJoinsObj = this.getPropertyValue(PROP_ALL_JOINS);
        if (allJoinsObj == null) {
            return null;
        }
        if (!(allJoinsObj instanceof List)) {
            return null;
        }
        MetadataConnection mc = planningEnv.getMetadataConnection();
        ArrayList<IMetadata> output = new ArrayList<IMetadata>();
        List listObject = (List)allJoinsObj;
        try {
            for (Object joinObj : listObject) {
                if (joinObj instanceof IMetadata) {
                    return (List)this.getPropertyValue(PROP_ALL_JOINS);
                }
                if (!(joinObj instanceof String)) {
                    return null;
                }
                IMetadata newJoin = mc.bindMetadataReference((String)joinObj);
                if (newJoin == null) continue;
                output.add(newJoin);
            }
        }
        catch (XQERuntimeException e) {
            return null;
        }
        return output;
    }

    public List<String> readAllJoins(Element allJoins) {
        ArrayList<String> output = new ArrayList<String>();
        List joinList = allJoins.elements();
        for (Element join : joinList) {
            String joinName = (String)join.getData();
            if (joinName == null) continue;
            output.add(joinName);
        }
        return output;
    }

    public List<String> readPreferredQS(Element qsRefs) {
        ArrayList<String> output = new ArrayList<String>();
        List qsRefList = qsRefs.elements();
        for (Element qsRef : qsRefList) {
            String qs = qsRef.attributeValue("refModelItem");
            if (qs == null) continue;
            output.add(qs);
        }
        return output;
    }

    public boolean isModelSecurityCheckRequired() {
        return this.getPropertyValue(PROP_BOOLEAN_MODEL_SECURITY_CHECK_REQUIRED) == Boolean.TRUE;
    }

    public void setModelSecurityCheckRequired(boolean isModelSecurityCheckRequired) {
        if (isModelSecurityCheckRequired) {
            this.setPropertyValue(PROP_BOOLEAN_MODEL_SECURITY_CHECK_REQUIRED, Boolean.TRUE);
        } else {
            this.setPropertyValue(PROP_BOOLEAN_MODEL_SECURITY_CHECK_REQUIRED, Boolean.FALSE);
        }
    }

    public boolean getForcedDMRToRelational() {
        return Boolean.TRUE == this.getBooleanPropertyValue("forceDMRtoRQP");
    }

    public IQuerySubject getDynamicSQS() {
        return (IQuerySubject)this.getPropertyValue("dynamicSQSQuery");
    }

    public TreeSet<IQuerySubject> getReferencedDynamicSQS() {
        return (TreeSet)this.getPropertyValue("referencedDynamicSQS");
    }

    public void setPreferredJoins(List<IMetadata> joins) {
        this.setPropertyValue(PROP_PREFERRED_JOINS, joins);
    }

    public List<IMetadata> getPreferredJoins() {
        return (List)this.getPropertyValue(PROP_PREFERRED_JOINS);
    }

    public String getMetadataPath() {
        return (String)this.getPropertyValue("metadataPath");
    }

    public void setMetadataPath(String path) {
        if (path == null || path.isEmpty()) {
            this.removeProperty("metadataPath");
            return;
        }
        this.setPropertyValue("metadataPath", path);
    }

    public MetadataConnection getMetadataConnectionMetadataPath(PlanningEnvironment environment) {
        String localPath = this.getMetadataPath();
        return environment.getMetadataConnectionMetadataPath(localPath);
    }

    public String getMetadataPathInSource() {
        V5Source src = this.getV5Source();
        if (src == null) {
            return null;
        }
        return (String)src.getPropertyValue("metadataPath");
    }

    public boolean isSqlQuery() {
        V5Source src = this.getV5Source();
        if (src == null) {
            return false;
        }
        return src.getFirstChildByType(101016) != null;
    }

    public void addQSToJoin(IQuerySubject qs) {
        Set<IQuerySubject> qsToJoin = this.getQSToJoin();
        if (qsToJoin == null) {
            qsToJoin = new TreeSet<IQuerySubject>();
            this.setPropertyValue(PROP_QS_TO_JOIN, qsToJoin);
        }
        qsToJoin.add(qs);
    }

    public Set<IQuerySubject> getQSToJoin() {
        return (Set)this.getPropertyValue(PROP_QS_TO_JOIN);
    }

    public void addExpandedCalculation(V5BoundDataItemReference node, IXQEQueryNode expr) {
        if (expr == null) {
            return;
        }
        ArrayList<V5BoundDataItemReference> expandedCalcs = (ArrayList<V5BoundDataItemReference>)this.getPropertyValue(PROP_EXPANDED_CALCS);
        if (expandedCalcs == null) {
            expandedCalcs = new ArrayList<V5BoundDataItemReference>();
            this.setPropertyValue(PROP_EXPANDED_CALCS, expandedCalcs);
        }
        for (IXQEQueryNode iXQEQueryNode : expandedCalcs) {
            if (!iXQEQueryNode.isSameExpression(node, false)) continue;
            ((V5BoundDataItemReference)iXQEQueryNode).incrementNumTimesReferenced();
            return;
        }
        node.incrementNumTimesReferenced();
        IXQEQueryNode refExpr = this.environment.getNodeFactory().deepCopyNode(expr);
        node.setRefDataItemExpression(refExpr);
        expandedCalcs.add(node);
        node.setPropertyValue(PROP_EXPANDED_CALCS, expandedCalcs);
        for (IXQEQueryNode refInExpr : refExpr.getDescendantsOfType(201060, true)) {
            refInExpr.setPropertyValue(PROP_EXPANDED_CALCS, expandedCalcs);
        }
    }

    public List<IXQEQueryNode> getExpandedCalculations() {
        return (List)this.getPropertyValue(PROP_EXPANDED_CALCS);
    }

    public Boolean isMixedDMRRelational() {
        return (Boolean)this.getPropertyValue("mixedDMRRelational");
    }

    public void setMixedDMRRelational(Boolean mixedDMRRelational) {
        if (mixedDMRRelational == null) {
            this.removeProperty("mixedDMRRelational");
            return;
        }
        this.setPropertyValue("mixedDMRRelational", mixedDMRRelational);
    }

    public Boolean getUseModelLabelsForIndirectModelRefs() {
        Boolean useModelLabelsForIndirectModelRefs = Boolean.FALSE;
        if (Governors.DataItemLabelBehaviour.DIRECT_AND_INDIRECT_MODELREFS.equals((Object)this.getGovernors().getDataItemLabelBehaviour())) {
            useModelLabelsForIndirectModelRefs = Boolean.TRUE;
        }
        return useModelLabelsForIndirectModelRefs;
    }

    public static enum RelationalSubquerySource {
        DMR("DMR"),
        XTABREL("XTABREL"),
        ROLAP("ROLAP"),
        REL_DECOMPOSITION_FROM_OLAP("REL_DECOMPOSITION_FROM_OLAP");

        private final String subquerySourceName;

        private RelationalSubquerySource(String name) {
            this.subquerySourceName = name;
        }

        public String getName() {
            return this.subquerySourceName;
        }
    }

    public static enum QueryHint {
        AVOID_ZERODIV("avoidZeroDiv"),
        USE_SQL_WITH_CLAUSE("useSQLWithClause"),
        LOCAL_CACHE("localCache"),
        USE_V4_INTERPRETATION("useV4Interpretation"),
        USE_FOR_PARAMETER_INFO("useForParameterInfo"),
        AUTOSORT("autoSort"),
        EXECUTION_OPTIMIZATION("executionOptimization"),
        QUERY_PROCESSING("queryProcessing"),
        OUTERJOIN_ALLOWED("outerJoinAllowed"),
        CROSS_PRODUCT_ALLOWED("crossProductAllowed"),
        SUPPRESS("suppress"),
        DASHBOARD("dashboard"),
        ROLLUP_PROCESSING("rollupProcessing"),
        REPORT_MEASURE("reportMeasure"),
        EXECUTION_METHOD("executionMethod"),
        QUERY_INTENT("queryIntent"),
        MEASURE_REFINER("measureRefiner"),
        MAX_ROWS_RETRIEVED("maxRowsRetrieved"),
        MAX_TABLES_PER_QUERY("maxTablesPerQuery"),
        MAX_QUERY_EXECUTION_TIME("maxQueryExecutionTime"),
        MAX_TEXT_BLOB_CHARACTERS("maxTextBlobCharacters"),
        USE_SAP_MUN_AS_BUSINESS_KEY("useSAPMUNAsBusinessKey"),
        USE_AGGREGGATE_CACHE("useAggregateCache"),
        EXACT_NUMERIC_DIVISION("exactNumericDivision"),
        GROUPBY_OPTIMIZATION("groupByOptimization"),
        RELATIONAL_SUBQUERY("relationalSubquery"),
        ALLJOINS("allJoins"),
        CURSORMODE("cursorMode"),
        USE_SQL_PARAMETERS("useSQLParameters"),
        SUPPRESS_DUPLICATE_MEASURE_VALUES("suppressDuplicateMeasureValues"),
        CONTEXT_SENSITIVE_JOIN_SELECTION(Governors.AllGovernors.CONTEXT_SENSITIVE_JOIN_SELECTION.getKey()),
        TABLE_SAMPLING_TABLE("tableSamplingTable"),
        TABLE_SAMPLING_METHOD("tableSamplingMethod"),
        TABLE_SAMPLING_PERCENT("tableSamplingPercent"),
        TABLE_SAMPLING_ROW_COUNT("tableSamplingRowCount"),
        TABLE_SAMPLING_SEED("tableSamplingSeed"),
        TABLE_SAMPLING_THROW_ON_SUBQUERY("tableSamplingThrowOnSubquery"),
        IS_STATS_QUERY("isStatsQuery"),
        MAX_OOM_MDX_RESULT(Governors.AllGovernors.MAX_OOM_MDX_RESULT.getKey()),
        REPORT_AS_DATASOURCE("rads"),
        SQLWINDOWFUNCTION_GENERATION(Governors.AllGovernors.SQLWINDOWFUNCTION_GENERATION.getKey()),
        SUMMARYQUERY_JOIN_OPERATOR(Governors.AllGovernors.SUMMARYQUERY_JOIN_OPERATOR.getKey()),
        MAX_TABLE_NAME_LENGTH(Governors.AllGovernors.MAX_TABLE_NAME_LENGTH.getKey()),
        DATASET_MODULE_TYPE(Governors.AllGovernors.DATASET_MODULE_TYPE.getKey()),
        IGNORE_FILTERS_NOT_APPLICABLE(Governors.AllGovernors.IGNORE_FILTERS_NOT_APPLICABLE.getKey()),
        PREFERREDMODELITEMS("preferredModelItems"),
        TREAT_EMPTY_DMR_MUN(Governors.AllGovernors.TREAT_EMPTY_DMR_MUN.getKey()),
        DATA_CACHE_EXPIRY(Governors.AllGovernors.DATA_CACHE_EXPIRY.getKey()),
        DATA_CACHE_USE_POLICY(Governors.AllGovernors.DATA_CACHE_USE_POLICY.getKey()),
        USE_VECTORIZED_QUERY_EXECUTION(Governors.AllGovernors.USE_VECTORIZED_QUERY_EXECUTION.getKey()),
        GENERATE_SUBQUERY_FOR_CALCS(Governors.AllGovernors.GENERATE_SUBQUERY_FOR_CALCS.getKey()),
        PROCESS_NULL_CONSUMERS_AFTER_JOIN(Governors.AllGovernors.PROCESS_NULL_CONSUMERS_AFTER_JOIN.getKey()),
        FJO_MAX_KEYS(Governors.AllGovernors.FJO_MAX_KEYS.getKey());

        private final String propertyName;

        private QueryHint(String propName) {
            this.propertyName = propName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

