/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5QueryOperation
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5QueryOperation";
    public static final String V5_NODE_NAME = "queryOperation";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_SET_OPERATION = "setOperation";
    public static final String PROP_STRING_DUPLICATES = "duplicates";
    private static final String PROJECTION_LIST = "projectionList";
    private static final String QUERY_REFS = "queryRefs";
    public static final String PROP_STRING_MEMBER_COERCED = "member_coerced";
    private static final String PROP_VALUE_DUPLICATES_REMOVE = "remove";
    private static final String PROP_VALUE_DUPLICATES_PRESERVE = "preserve";

    @Override
    public int getType() {
        return 101018;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!(attname.equals(PROP_STRING_NAME) || attname.equals(PROP_STRING_SET_OPERATION) || attname.equals(PROP_STRING_DUPLICATES) || attname.equals(PROJECTION_LIST))) {
                throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            }
            this.setStringPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(QUERY_REFS)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals(PROJECTION_LIST)) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public V5Query[] getReferencedV5Queries(PlanningEnvironment environment) {
        IXQEQueryNode[] qRefs = this.getChildrenOfTypeOrdered(101023);
        V5Query[] refQueries = new V5Query[qRefs.length];
        V5QuerySet rootQuerySet = null;
        for (int i = 0; i < refQueries.length; ++i) {
            V5QueryRef queryRef = (V5QueryRef)qRefs[i];
            if (i == 0) {
                rootQuerySet = V5QuerySet.getRootQuerySet(environment, queryRef);
            }
            if (rootQuerySet == null) continue;
            refQueries[i] = rootQuerySet.getV5Query(queryRef.getRefQuery());
        }
        return refQueries;
    }

    public String getName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public SQLSetOperator.SubType getSQLSubType() {
        String setOperation = (String)this.getPropertyValue(PROP_STRING_SET_OPERATION);
        if (null == setOperation || setOperation.equals("UNION")) {
            return SQLSetOperator.SubType.UNION;
        }
        if (setOperation.equals("INTERSECT")) {
            return SQLSetOperator.SubType.INTERSECT;
        }
        if (setOperation.equals("EXCEPT")) {
            return SQLSetOperator.SubType.EXCEPT;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unknown setOperation attribute value: " + setOperation);
    }

    public boolean isDuplicatesPreserve() {
        String duplicates = (String)this.getPropertyValue(PROP_STRING_DUPLICATES);
        return duplicates != null && duplicates.equals(PROP_VALUE_DUPLICATES_PRESERVE);
    }

    public void setDuplicatesPreserve(boolean preserveDuplicates) {
        if (preserveDuplicates) {
            this.setPropertyValue(PROP_STRING_DUPLICATES, PROP_VALUE_DUPLICATES_PRESERVE);
        } else {
            this.setPropertyValue(PROP_STRING_DUPLICATES, PROP_VALUE_DUPLICATES_REMOVE);
        }
    }
}

