/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5QuerySubject
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5QuerySubject";
    public static final String V5_NODE_NAME = "querySubject";
    private static final String PROP_STRING_NAME = "name";
    private static final String PROP_STRING_TYPE = "type";
    private static final String DEFINITION = "definition";
    public static final String PROP_STRING_MODEL = "model";
    private static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    private static final String PROP_OBJECT_STOREDPROCEDURE = "storedProcedure";

    @Override
    public int getType() {
        return 101074;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!attname.equals(PROP_STRING_TYPE)) {
                throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            }
            this.setStringPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(PROP_STRING_NAME)) {
                String name = child.getText();
                this.setStringPropertyValue(childname, name);
                continue;
            }
            if (childname.equals(DEFINITION)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public String getName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public String getModel() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL);
    }

    public void setModel(String model) {
        this.setPropertyValue(PROP_STRING_MODEL, model);
    }

    public void setQueryItemList(SQLQueryItemList queryItemList) {
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, queryItemList);
    }

    public SQLQueryItemList getQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
    }

    public void setStoredProcedure(String isStoredProcedure) {
        this.setPropertyValue(PROP_OBJECT_STOREDPROCEDURE, isStoredProcedure);
    }

    public boolean isStoredProcedure() {
        String storedProcedure = (String)this.getPropertyValue(PROP_OBJECT_STOREDPROCEDURE);
        return storedProcedure != null && "true".equals(storedProcedure);
    }

    public void execute(XDataContext context) {
        IXQEQueryNode child = this.getChild(0);
        ITabularResultSet result = (ITabularResultSet)((XNode)child).execute(context);
        IRowsetInfo iRowsetInfo = result.getTabularRowsetInfo();
        IColumnInfo[] iColumnInfo = iRowsetInfo.getColumnInfos();
        SQLQueryItemList queryItemList = new SQLQueryItemList();
        for (int i = 0; i < iColumnInfo.length; ++i) {
            SQLQueryItem queryItem = new SQLQueryItem();
            queryItem.setName(iColumnInfo[i].getName());
            queryItemList.add(queryItem);
        }
        this.setQueryItemList(queryItemList);
        result.release();
    }
}

