/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5Selection
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5Selection";
    public static final String V5_NODE_NAME = "selection";
    public static final String PROP_BOOLEAN_AUTO_SUMMARY = "autoSummary";
    public static final String PROP_BOOLEAN_ORIGINAL_AUTO_SUMMARY = "originalAutoSummary";
    private static final String DATAITEM = "dataItem";
    public static final String PROP_ENFORCE_AUTOSAMMARY = "EnforceAutosummary";

    @Override
    public int getType() {
        return 101009;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_BOOLEAN_AUTO_SUMMARY)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(DATAITEM) || childname.equals("V5DataItem")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public V5DataItem getDataItemByRefName(String name) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (!((V5DataItem)this.getChild(i)).getNameProperty().equals(name)) continue;
            return (V5DataItem)this.getChild(i);
        }
        return null;
    }

    public void setAutoSummary(boolean b) {
        this.setPropertyValue(PROP_BOOLEAN_AUTO_SUMMARY, b);
    }

    public boolean getAutoSummary() {
        Boolean b = this.getBooleanPropertyValue(PROP_BOOLEAN_AUTO_SUMMARY);
        if (b == null) {
            return true;
        }
        return b;
    }

    public V5DataItem getDataItemByRefNameFromV5Parameter(String name) {
        IXQEQueryNode[] parameters;
        for (IXQEQueryNode parameter : parameters = this.getDescendantsOfType(201024, false)) {
            if (!((V5Parameter)parameter).getParameterName().equals(name)) continue;
            return (V5DataItem)parameter.getAncestorOfType(101003);
        }
        return null;
    }

    public String getDataItemNameByExpressionStr(String exprString) {
        V5DataItem dataItem = this.getDataItemByExpressionStr(exprString);
        if (dataItem != null) {
            return dataItem.getNameProperty();
        }
        return null;
    }

    public V5DataItem getDataItemByExpressionStr(String exprString) {
        for (IXQEQueryNode di : this.getChildren()) {
            String expr = (String)di.getChild(0).getPropertyValue("expression");
            if (expr == null || !expr.equals(exprString)) continue;
            return (V5DataItem)di;
        }
        return null;
    }

    public V5DataItem getDataItemByExpression(IXQEQueryNode expr) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (!expr.isSameExpression(((V5DataItem)this.getChild(i)).getChild(0), false)) continue;
            return (V5DataItem)this.getChild(i);
        }
        return null;
    }
}

