/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5SlicerMemberSet
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5SlicerMemberSet";
    public static final String V5_NODE_NAME = "slicerMemberSet";
    public static final String PROP_STRING_RID = "rID";
    public static final String PROP_STRING_EXPRESSION = "expression";
    private static final char COLON = ':';
    private static final char SPACE = ' ';

    @Override
    public int getType() {
        return 101014;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public String getV5ElementName() {
        return V5_NODE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!attname.equals(PROP_STRING_RID)) {
                throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            }
            this.setStringPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        if (children.size() > 0) {
            Element child = (Element)children.get(0);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
        this.setStringPropertyValue(PROP_STRING_EXPRESSION, inputNode.getText());
    }

    @Override
    public void formatForMessage(StringBuilder sb) {
        V5Query v5Query = (V5Query)this.getAncestorOfType(101006);
        v5Query.formatForMessage(sb);
        sb.append(':');
        sb.append(' ');
        super.formatForMessage(sb, this.getV5ElementName(), null);
        sb.append(':');
        sb.append(' ');
        String exp = this.getExpression();
        XQEMessage.appendQuotedItem(sb, exp);
    }

    @Override
    public V5SlicerMemberSet getEffectiveNodeForMessage() {
        return this;
    }

    public String getExpression() {
        String expression = (String)this.getPropertyValue(PROP_STRING_EXPRESSION);
        if (expression == null) {
            StringBuilder buffer = new StringBuilder();
            this.writeFormattedText(buffer);
            expression = buffer.toString();
            this.setOriginalExpression(expression);
        }
        return expression;
    }
}

