/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5Source
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5Source";
    public static final String V5_NODE_NAME = "source";
    public static final String PROP_STRING_MODEL = "model";
    public static final String PROP_STRING_MODELTYPE = "modelType";
    private static final String PROP_STRING_QUERY_REF = "queryRef";
    private static final String PROP_REFERENCED_QUERIES = "referencedQueries";
    public static final String PROP_RELATIONAL = "relational";
    private static final String REF_QUERY = "refQuery";
    private static final String SQLQUERY = "sqlQuery";
    private static final String MDXQUERY = "mdxQuery";
    private static final String XMLQUERY = "xmlQuery";
    private static final String QUERY_OPERATION = "queryOperation";
    private static final String JOIN_OPERATION = "joinOperation";
    public static final String PROP_IS_BOUND = "isBound";
    public static final String PROP_BOOL_IS_RESOLVED = "isResolved";

    @Override
    public int getType() {
        return 101007;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_MODEL)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_RELATIONAL)) {
                this.setPropertyValue(PROP_RELATIONAL, true);
                continue;
            }
            if (attname.equals(PROP_STRING_QUERY_REF)) {
                this.setQueryRef(att.getValue().substring(1, att.getValue().length() - 1));
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(SQLQUERY) || childname.equals(MDXQUERY) || childname.equals(XMLQUERY) || childname.equals(QUERY_OPERATION) || childname.equals(JOIN_OPERATION) || childname.equals("V5SqlQuery") || childname.equals("V5MdxQuery") || childname.equals("V5QueryOperation") || childname.equals("V5JoinOperation") || childname.equals("V5XmlQuery")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals(PROP_STRING_MODEL)) {
                this.setStringPropertyValue(childname, child.getText());
                continue;
            }
            if (childname.equals(PROP_STRING_QUERY_REF) || childname.equals("V5QueryRef")) {
                this.setQueryRef(child.attributeValue(REF_QUERY));
                continue;
            }
            if (childname.equals("metadataPath")) {
                String type;
                String path = child.attributeValue("path");
                if (path != null && !path.isEmpty()) {
                    this.setPropertyValue(childname, path);
                }
                if ((type = child.attributeValue("type")) == null || type.isEmpty()) continue;
                this.setPropertyValue(PROP_STRING_MODELTYPE, type);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public String getModel() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL);
    }

    public String getModelType() {
        return (String)this.getPropertyValue(PROP_STRING_MODELTYPE);
    }

    public void setModelType(String modelType) {
        this.setPropertyValue(PROP_STRING_MODELTYPE, modelType);
    }

    public void setModel(String model) {
        if (model == null || model.isEmpty()) {
            this.removeProperty(PROP_STRING_MODEL);
            return;
        }
        this.setPropertyValue(PROP_STRING_MODEL, model);
    }

    public void resetReferencedQueries() {
        this.removeProperty(PROP_REFERENCED_QUERIES);
        this.removeProperty(PROP_STRING_QUERY_REF);
    }

    public boolean isBound() {
        return this.getBooleanPropertyValue(PROP_IS_BOUND) == Boolean.TRUE;
    }

    public void setIsBound() {
        this.setPropertyValue(PROP_IS_BOUND, Boolean.TRUE);
    }

    public boolean needQueryOverTabularStream() {
        return this.getPropertyValue("needTabularStream") == Boolean.TRUE;
    }

    public void setNeedTabularStream() {
        this.setPropertyValue("needTabularStream", Boolean.TRUE);
    }

    public String getQueryRef() {
        return (String)this.getPropertyValue(PROP_STRING_QUERY_REF);
    }

    public void setQueryRef(String value) {
        this.setStringPropertyValue(PROP_STRING_QUERY_REF, value);
        this.removeProperty(PROP_REFERENCED_QUERIES);
        this.addReferencedQuery(value);
    }

    public Set<String> getReferencedQueries() {
        return (Set)this.getPropertyValue(PROP_REFERENCED_QUERIES);
    }

    public void setReferencedQueries(Set<String> referencedQueries) {
        if (this.getQueryRef() != null) {
            throw new UnsupportedOperationException("Cannot set referenced queries when queryRef set");
        }
        this.setPropertyValue(PROP_REFERENCED_QUERIES, referencedQueries);
    }

    public void addReferencedQuery(String query) {
        Set<String> queryRefs = this.getReferencedQueries();
        if (queryRefs == null) {
            queryRefs = new TreeSet<String>();
            this.setPropertyValue(PROP_REFERENCED_QUERIES, queryRefs);
        }
        queryRefs.add(query);
    }

    public boolean removeQueryReference(String query) {
        Set<String> queryRefs = this.getReferencedQueries();
        if (queryRefs != null && queryRefs.contains(query)) {
            queryRefs.remove(query);
            if (queryRefs.isEmpty()) {
                this.removeProperty(PROP_REFERENCED_QUERIES);
            }
            return true;
        }
        return false;
    }

    public boolean isQueryReferencedInQueryOperation(V5Query query) {
        IXQEQueryNode queryOpNode = this.getFirstChildByType(101018);
        if (queryOpNode != null) {
            IXQEQueryNode[] queryRefsOfQueryOp = queryOpNode.getChildrenOfType(101023);
            for (int i = 0; i < queryRefsOfQueryOp.length; ++i) {
                V5QueryRef queryRef = (V5QueryRef)queryRefsOfQueryOp[i];
                if (!queryRef.getRefQuery().equals(query.getV5QueryName())) continue;
                return true;
            }
        }
        return false;
    }
}

