/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5EdgeSuppression
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5EdgeSuppression";
    public static final String V5_NODE_NAME = "edgeSuppression";
    public static final String PROP_BOOLEAN_NULLS = "nulls";
    public static final String PROP_BOOLEAN_NULL = "null";
    public static final String PROP_BOOLEAN_ZERO = "zero";
    public static final String PROP_BOOLEAN_DIVBYZERO = "divByZero";
    public static final String PROP_BOOLEAN_OVERFLOW = "overflow";
    public static final String PROP_BOOLEAN_TRUE = "true";
    public static final String PROP_BOOLEAN_FALSE = "false";

    @Override
    public int getType() {
        return 101066;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_BOOLEAN_NULLS) || attname.equals(PROP_BOOLEAN_ZERO) || attname.equals(PROP_BOOLEAN_DIVBYZERO) || attname.equals(PROP_BOOLEAN_OVERFLOW)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_BOOLEAN_NULL)) {
                this.setBooleanPropertyValue(PROP_BOOLEAN_NULLS, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        if (children.size() > 0) {
            Element child = (Element)children.get(0);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

