/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.result.V5DetailContext;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5MasterDetailLink
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5MasterDetailLink";
    public static final String V5_NODE_NAME = "masterDetailLink";
    private static final String MASTER_CONTEXT = "masterContext";
    private static final String DETAIL_CONTEXT = "detailContext";
    public static final String PROPERTY_MDPROVIDER_LINK = "MDProviderLink";
    public static final String PROPERTY_LINK_PROCESSED = "linkProcessed";
    public static final String PROPERTY_PARAMETER_PARENT_LINK_REPROCESSED = "parameterParentLinkReProcessed";
    public static final String PROPERTY_DETAIL_FILTER_CREATED = "detailMDFilterCreated";
    public static final String PROPERTY_UPDATE_REQUIRED = "updateRequired";
    public static final String PROPERTY_SINGLE_QUERY = "singleQuery";
    public static final String PROPERTY_SINGLE_DATAITEM = "singleDataItem";

    @Override
    public int getType() {
        return 101059;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        if (inputNode.attributeCount() > 0) {
            Attribute att = inputNode.attribute(0);
            String attname = att.getName();
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(MASTER_CONTEXT) || childname.equals(DETAIL_CONTEXT)) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public boolean referencesDetailQRD(String qrdName) {
        boolean result = false;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 101061 || !((V5DetailContext)child).referencesDetailQRD(qrdName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public MasterDetailLink getMDProviderLink() {
        return (MasterDetailLink)this.getPropertyValue(PROPERTY_MDPROVIDER_LINK);
    }

    public void setMDProviderLink(MasterDetailLink link) {
        this.setPropertyValue(PROPERTY_MDPROVIDER_LINK, link);
    }
}

