/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5QueryResultDefinition
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5QueryResultDefinition";
    public static final String V5_NODE_NAME = "queryResultDefinition";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_REF_QUERY = "refQuery";
    public static final String PROP_STRING_ORIG_REF_QUERY = "originalRefQuery";
    public static final String PROP_STRING_SHAPE = "shape";
    public static final String PROP_STRING_CROSSTAB = "crosstab";
    private static final String PROP_EXECUTION_SUPPORTED = "executionSupported";
    private static final String EDGES = "edges";
    private static final String MASTER_DETAIL_LINKS = "masterDetailLinks";
    private static final String PROP_REFERENCES_WALKED = "referencesWalked";
    public static final String PROP_TOPNROWS = "topNRows";
    public static final String PROP_IS_DETAILQUERY = "isDetailQuery";
    private Set<String> queryFeedbacks = null;

    @Override
    public int getType() {
        return 101055;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_NAME) || attname.equals(PROP_STRING_REF_QUERY) || attname.equals(PROP_STRING_SHAPE) || attname.equals(PROP_TOPNROWS) || attname.equals(PROP_STRING_ORIG_REF_QUERY)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(EDGES) || childname.equals(MASTER_DETAIL_LINKS)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals("V5Edge") || childname.equals("V5MasterDetailLink")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
        this.validateRowsetNames();
    }

    public String getRefQueryProperty() {
        return (String)this.getPropertyValue(PROP_STRING_REF_QUERY);
    }

    public void setRefQueryProperty(String name) {
        this.setPropertyValue(PROP_STRING_REF_QUERY, name);
    }

    public String getOriginalRefQueryProperty() {
        return (String)this.getPropertyValue(PROP_STRING_ORIG_REF_QUERY);
    }

    public void setOriginalRefQueryProperty(String name) {
        this.setPropertyValue(PROP_STRING_ORIG_REF_QUERY, name);
    }

    public String getShapeProperty() {
        return (String)this.getPropertyValue(PROP_STRING_SHAPE);
    }

    public void setShapeProperty(String name) {
        this.setPropertyValue(PROP_STRING_SHAPE, name);
    }

    public void setExecutionSupported(boolean isExecutionSupported) {
        this.setPropertyValue(PROP_EXECUTION_SUPPORTED, isExecutionSupported);
    }

    public boolean isExecutionSupported() {
        Boolean isExecutionSupport = (Boolean)this.getPropertyValue(PROP_EXECUTION_SUPPORTED);
        if (isExecutionSupport != null) {
            return isExecutionSupport;
        }
        return true;
    }

    public V5Query getV5Query() {
        V5QuerySet querySet = (V5QuerySet)this.getAncestorOfType(101002);
        return querySet.getV5Query(this.getRefQueryProperty());
    }

    public String getName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public boolean referencesDetailQRD(V5QueryResultDefinition v5QueryResultDefinition) {
        boolean result = false;
        String qrdName = v5QueryResultDefinition.getName();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 101059 || !((V5MasterDetailLink)child).referencesDetailQRD(qrdName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setReferencesWalked() {
        this.setPropertyValue(PROP_REFERENCES_WALKED, Boolean.TRUE);
    }

    public boolean referencesWalked() {
        return this.getBooleanPropertyValue(PROP_REFERENCES_WALKED) == Boolean.TRUE;
    }

    private void validateRowsetNames() {
        IXQEQueryNode[] descendants;
        HashSet<String> rowSetNames = new HashSet<String>();
        int[] nodeTypes = new int[]{101057, 101053, 101052};
        for (IXQEQueryNode child : descendants = this.getDescendantsOfTypes(nodeTypes, false)) {
            String rowsetName = (String)child.getPropertyValue(PROP_STRING_NAME);
            if (rowSetNames.contains(rowsetName)) {
                throw new XQERuntimeException(XQEMessageKeys.V5_NonUniqueRowsetName, rowsetName, this.getName());
            }
            rowSetNames.add(rowsetName);
        }
    }

    public boolean isList() {
        IXQEQueryNode dataset = this.getAncestorOfType(401005);
        if (dataset != null && !((RSAPIDataset)dataset).isInvalidReport()) {
            return ((RSAPIDataset)dataset).isListReport();
        }
        IXQEQueryNode[] edges = this.getChildrenOfType(101049);
        if (PROP_STRING_CROSSTAB.equals(this.getPropertyValue(PROP_STRING_SHAPE))) {
            return false;
        }
        return edges.length == 1;
    }

    public void addQueryFeedback(String feedbackName) {
        if (this.queryFeedbacks == null) {
            this.queryFeedbacks = new HashSet<String>();
        }
        this.queryFeedbacks.add(feedbackName);
    }

    public Set<String> getQueryFeedbacks() {
        return this.queryFeedbacks;
    }

    public void cloneReferencedQuery(PlanningEnvironment environment) {
        String queryNameMarker = "_ForQrd_";
        XQENodeFactory factory = environment.getNodeFactory();
        V5Query query = this.getV5Query();
        V5Query clone = (V5Query)factory.deepCopyNode(query);
        clone.removeProperty("rootQueryName");
        clone.setStringPropertyValue("originalQueryName", query.getV5QueryName());
        clone.setStringPropertyValue(PROP_STRING_NAME, query.getV5QueryName() + "_ForQrd_" + this.getName());
        this.setRefQueryProperty(clone.getV5QueryName());
        this.getParent().addChildBeforeNode(clone, this);
        clone.setStringPropertyValue("rootQRDName", this.getName());
    }

    public Boolean isMixedDMRRelational() {
        return (Boolean)this.getPropertyValue("mixedDMRRelational");
    }

    public void setMixedDMRRelational(Boolean mixedDMRRelational) {
        if (mixedDMRRelational == null) {
            this.removeProperty("mixedDMRRelational");
            return;
        }
        this.setPropertyValue("mixedDMRRelational", mixedDMRRelational);
    }
}

