/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.update;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5InvalidPropertyValueException;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.update.V5UpdateSubject;
import com.cognos.xqe.ast.v5.utils.V5Version;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5UpdateSet
extends XQEQueryNode {
    public static final String NODE_TYPE_NAME = "V5UpdateSet";
    public static final String V5_NODE_NAME = "updateSet";
    public static final String PROP_STRING_MODEL_PATH = "modelPath";
    private static final String PROP_OBJECT_METADATA_CONNECTION = "metadataConnection";
    public static final String V5_VERSION = "v5Version";
    private Parameters parameters = new Parameters();

    @Override
    public int getType() {
        return 101070;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!attname.equals(V5_VERSION)) {
                throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            }
            this.setIntegerPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("updateSubject")) {
                V5UpdateSubject node = (V5UpdateSubject)factory.createNode(101071);
                node.capture(env, child);
                this.addChild(node);
                continue;
            }
            if (childname.equals(PROP_STRING_MODEL_PATH)) {
                String modelPath = child.getText();
                this.setStringPropertyValue(PROP_STRING_MODEL_PATH, modelPath);
                ((RequestEnvironment)env.getRequestEnvironment()).setModelPath(modelPath);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public String getModelPath() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL_PATH);
    }

    public MetadataConnection getMetadataConnection() {
        return (MetadataConnection)this.getPropertyValue(PROP_OBJECT_METADATA_CONNECTION);
    }

    public void setMetadataConnection(MetadataConnection mdConnection) {
        this.setPropertyValue(PROP_OBJECT_METADATA_CONNECTION, mdConnection);
    }

    public void setRequestParameters(Parameters aParameters) {
        this.parameters = aParameters;
    }

    public Parameters getRequestParameters() {
        return this.parameters;
    }

    @Override
    public int isValidPlannedQuery() {
        IXQEQueryNode[] children = this.getChildren();
        if (0 == children.length) {
            return -1;
        }
        return super.isValidPlannedQuery();
    }

    public V5Version getV5Version() {
        Integer version = this.getIntegerPropertyValue(V5_VERSION);
        if (version == null) {
            return V5Version.ONE;
        }
        V5Version v5version = V5Version.valueOf(version);
        if (v5version == V5Version.UNKNOWN) {
            this.throwInternalError("Unknown V5 version number: " + version);
        }
        return v5version;
    }

    public void setIntegerPropertyValue(String name, String value) throws V5InvalidPropertyValueException {
        if (value == null || value.length() == 0) {
            throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, name);
        }
        this.setPropertyValue(name, new Integer(value));
    }

    public void setStringPropertyValue(String name, String value) throws V5InvalidPropertyValueException {
        if (value == null) {
            throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, name);
        }
        this.setPropertyValue(name, value);
    }

    public void execute(XDataContext context) {
        IXQEQueryNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            ITabularResultSet result = (ITabularResultSet)((XNode)children[i]).execute(context);
            if (result == null) continue;
            result.release();
        }
    }

    public boolean isNoDataMode() {
        Boolean isNoDataMode = this.getBooleanPropertyValue(V5QuerySet.RequestHint.NO_DATA_MODE.getPropertyName());
        return isNoDataMode != null && isNoDataMode.equals(Boolean.TRUE);
    }
}

