/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5BoundDataItemReference
extends V5BoundMultiPartIdentifier {
    public static final String NODE_TYPE_NAME = "V5DataItemReference";
    public static final String PROP_OBJECT_REF_DATAITEM = "refDataItem";
    public static final String PROP_STRING_REF_DATAITEM_ID = "refDataItemId";
    public static final String RM_REF_CALC = "rmRefCalc";
    public static final Pattern REF_DATA_ITEM_ID_PATTERN = Pattern.compile("V5DataItem\\(nodeId=(\\d+)\\)$");
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_IS_QUERYREFITEM = "isQueryRefItem";
    private static final String PROP_IS_NESTEDQUERYSETREFITEM = "isNestedQuerySetRefItem";
    private static final String PROP_DIREF_EXPR = "diRefExpression";
    private static final String PROP_NUM_TIMES_REFERENCED = "numReferences";

    public void setRefDataItem(V5DataItem refDataItem) {
        this.setPropertyValue(PROP_OBJECT_REF_DATAITEM, refDataItem);
    }

    public V5DataItem getRefDataItem() {
        return (V5DataItem)this.getPropertyValue(PROP_OBJECT_REF_DATAITEM);
    }

    public V5SimpleNode getReferencedExpression() {
        V5QueryNode referencedExpr = this;
        while (((V5QueryNode)referencedExpr).getType() == 201060) {
            V5DataItem dataItem = referencedExpr.getRefDataItem();
            referencedExpr = (V5QueryNode)dataItem.getChild(0);
        }
        while (!((V5QueryNode)referencedExpr).isOfCategory(201120)) {
            referencedExpr = (V5QueryNode)referencedExpr.getChild(0);
        }
        return referencedExpr;
    }

    public V5SimpleNode getTargetExpression() {
        V5SimpleNode refNode = this.getReferencedExpression();
        while (refNode.getType() == 201060) {
            refNode = ((V5BoundDataItemReference)refNode).getReferencedExpression();
        }
        return refNode;
    }

    @Override
    public IDataType getDataType() {
        IDataType dataType = (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
        if (dataType == null) {
            RMQueryItem rmItem = (RMQueryItem)this.getPropertyValue(RM_REF_CALC);
            if (rmItem != null) {
                IXQEQueryNode node = rmItem.getChild(0);
                return this.getDTFromSimpleOrRefNode(node);
            }
            V5DataItem refDataItem = this.getRefDataItem();
            if (RQPQuery.getRQPQuery(this) == null) {
                return refDataItem.getDataType();
            }
            V5Query query = (V5Query)refDataItem.getAncestorOfType(101006);
            RQPQuery rqpQuery = null;
            if (query != null && (rqpQuery = (RQPQuery)query.getFirstChildByType(801017)) != null && (dataType = this.getDTFromRQPQuery(rqpQuery)) != null) {
                return dataType;
            }
            if (this.isQueryRefItem()) {
                return refDataItem.getDataType();
            }
            rqpQuery = RQPQuery.getRQPQuery(this);
            if (rqpQuery != null && (dataType = this.getDTFromRQPQuery(rqpQuery)) != null) {
                return dataType;
            }
            return refDataItem.getDataType();
        }
        return dataType;
    }

    private IDataType getDTFromRQPQuery(RQPQuery rqpQuery) {
        IXQEQueryNode[] children;
        String name = this.getDataItemName();
        RQPProjectionList projection = rqpQuery.getProjectionList();
        for (IXQEQueryNode child : children = projection.getChildren()) {
            RQPDataItem dataItem = child.getType() == 301028 ? (RQPDataItem)child.getChild(0) : (RQPDataItem)child;
            if (!name.equals(dataItem.getOriginalName())) continue;
            IXQEQueryNode node = dataItem.getChild(0);
            IDataType dt = this.getDTFromSimpleOrRefNode(node);
            if (dt == null) break;
            return dt;
        }
        return null;
    }

    private IDataType getDTFromSimpleOrRefNode(IXQEQueryNode node) {
        if (node.isOfCategory(201120)) {
            V5SimpleNode simpleNode = (V5SimpleNode)node;
            return simpleNode.getDataType();
        }
        if (node.getType() == 801009) {
            RQPDataItemRef ref = (RQPDataItemRef)node;
            RQPDataItem item = ref.getReferencedItem();
            if (item.getChild(0) instanceof V5SimpleNode) {
                V5SimpleNode simpleNode = (V5SimpleNode)item.getChild(0);
                return simpleNode.getDataType();
            }
            if (item.getChild(0) instanceof SQLQueryNode) {
                SQLQueryNode sqlNode = (SQLQueryNode)item.getChild(0);
                return sqlNode.getDataType();
            }
        }
        return null;
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201060) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201060;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        return this.getRefDataItem().getHierarchyInfo();
    }

    @Override
    public MDXLevelInfo getHierarchyLevelInfo(MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        return this.getRefDataItem().getHierarchyLevelInfo(forHierarchy, fncs);
    }

    @Override
    public String getNativeName() {
        return this.getIdentifier();
    }

    public String getDataItemName() {
        int pos = 0;
        if (this.isQueryRefItem()) {
            pos = 1;
        }
        return this.getNameParts()[pos];
    }

    public boolean isQueryRefItem() {
        return this.getBooleanPropertyValue(PROP_IS_QUERYREFITEM) == Boolean.TRUE;
    }

    public void setIsQueryRefItem() {
        this.setPropertyValue(PROP_IS_QUERYREFITEM, Boolean.TRUE);
    }

    public void clearIsQueryRefItem() {
        this.removeProperty(PROP_IS_QUERYREFITEM);
    }

    public boolean isNestedQuerySetRefItem() {
        return this.getBooleanPropertyValue(PROP_IS_NESTEDQUERYSETREFITEM) == Boolean.TRUE;
    }

    public void setIsNestedQuerySetRefItem() {
        this.setPropertyValue(PROP_IS_NESTEDQUERYSETREFITEM, Boolean.TRUE);
    }

    public boolean isExplicitProperty() {
        return this.getBooleanPropertyValue("isExplicitProperty", Boolean.FALSE);
    }

    @Override
    public IMetadata getMetadata() {
        if (this.isQueryRefItem()) {
            return null;
        }
        IXQEQueryNode childNode = this.getRefDataItem().getChild(0);
        while (!childNode.isOfCategory(201120)) {
            childNode = childNode.getChild(0);
        }
        return ((V5SimpleNode)childNode).getMetadata();
    }

    public RQPDataItem getRQPDataITem() {
        IXQEQueryNode[] children;
        V5DataItem refDataItem = this.getRefDataItem();
        V5Query query = (V5Query)refDataItem.getAncestorOfType(101006);
        RQPQuery rqpQuery = (RQPQuery)query.getFirstChildByType(801017);
        if (rqpQuery == null) {
            return null;
        }
        String name = refDataItem.getNameProperty();
        RQPProjectionList projection = rqpQuery.getProjectionList();
        for (IXQEQueryNode child : children = projection.getChildren()) {
            RQPDataItem dataItem = child.getType() == 301028 ? (RQPDataItem)child.getChild(0) : (RQPDataItem)child;
            if (!name.equals(dataItem.getName())) continue;
            return dataItem;
        }
        return null;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_IS_QUERYREFITEM)) {
                this.setIsQueryRefItem();
                continue;
            }
            if (attname.equals("identifier")) {
                this.setIdentifier(att.getValue());
                continue;
            }
            if (attname.equals(PROP_OBJECT_REF_DATAITEM)) {
                Matcher refDIMatcher = REF_DATA_ITEM_ID_PATTERN.matcher(att.getValue());
                if (!refDIMatcher.find()) continue;
                this.setPropertyValue(PROP_STRING_REF_DATAITEM_ID, refDIMatcher.group(1));
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        int i = 0;
        List children = inputNode.elements();
        size = children.size();
        if (i < size) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode that, boolean compareCalcDefiniton) {
        if (that == null) {
            return false;
        }
        if (that.getNodeType() != 201060) {
            return false;
        }
        V5DataItem thisDataItem = this.getRefDataItem();
        if (thisDataItem == null) {
            return false;
        }
        V5DataItem thatDataItem = ((V5BoundDataItemReference)that).getRefDataItem();
        if (thatDataItem == null) {
            return false;
        }
        String thisName = thisDataItem.getNameProperty();
        if (thisName != null && !thisName.equals(thatDataItem.getNameProperty())) {
            return false;
        }
        V5Query thisQuery = (V5Query)thisDataItem.getAncestorOfType(101006);
        V5Query thatQuery = (V5Query)thatDataItem.getAncestorOfType(101006);
        if (thisQuery == null || thatQuery == null) {
            return false;
        }
        String thisQueryName = thisQuery.getV5QueryName();
        if (thisQueryName != null) {
            return thisQueryName.equals(thatQuery.getV5QueryName());
        }
        return false;
    }

    public void setRefDataItemExpression(IXQEQueryNode expr) {
        this.setPropertyValue(PROP_DIREF_EXPR, expr);
    }

    public IXQEQueryNode getRefDataItemExpression() {
        List expandedCalcs = (List)this.getPropertyValue("expandedCalcs");
        for (IXQEQueryNode calc : expandedCalcs) {
            V5BoundDataItemReference ref = (V5BoundDataItemReference)calc;
            if (!this.getDataItemName().equals(ref.getDataItemName())) continue;
            return (IXQEQueryNode)ref.getPropertyValue(PROP_DIREF_EXPR);
        }
        return (IXQEQueryNode)this.getPropertyValue(PROP_DIREF_EXPR);
    }

    public void incrementNumTimesReferenced() {
        Integer numRefs = (Integer)this.getPropertyValue(PROP_NUM_TIMES_REFERENCED);
        if (numRefs == null) {
            numRefs = 0;
        }
        numRefs = numRefs + 1;
        this.setPropertyValue(PROP_NUM_TIMES_REFERENCED, numRefs);
    }

    public int getNumTimesReferenced() {
        Integer numRefs = (Integer)this.getPropertyValue(PROP_NUM_TIMES_REFERENCED);
        if (numRefs == null) {
            return 0;
        }
        return numRefs;
    }
}

