/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.metadata.IQueryItemOfQuerySubject;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5BoundModelIdentifier
extends V5BoundToMetadata {
    public static final String NODE_TYPE_NAME = "V5BoundModelIdentifier";
    private static final String PROP_IS_UNWOUND = "isUnwound";
    private static final String PROP_IS_VALID = "isValid";
    public static final String PROP_IS_DMR_MEMBER_SORT_APPLIED = "isDMRMemberSortApplied";
    public static final String PROP_RESOLVED_QS_NAME = "resolvedQSName";

    public IHierarchy getHierarchy() {
        IMetadata metadataObj = this.getMetadata();
        return V5BoundModelIdentifier.getHierarchyFromIMetadata(metadataObj);
    }

    public static ILevel getLevelFromIMetadata(IMetadata metadataObj) {
        ILevel level = null;
        if (metadataObj != null) {
            switch (metadataObj.getObjectType()) {
                case LEVEL: {
                    level = (ILevel)metadataObj;
                    break;
                }
                case MEMBER: {
                    level = ((IMember)metadataObj).getLevel();
                    break;
                }
                case QUERY_ITEM: {
                    if (!(metadataObj instanceof IQueryItemOfLevel)) break;
                    level = ((IProperty)metadataObj).getLevel();
                    break;
                }
            }
        }
        return level;
    }

    public static IHierarchy getHierarchyFromIMetadata(IMetadata metadataObj) {
        IHierarchy hierarchy = null;
        if (metadataObj != null) {
            MetadataType objectType = metadataObj.getObjectType();
            switch (objectType) {
                case HIERARCHY: {
                    hierarchy = (IHierarchy)metadataObj;
                    break;
                }
                case LEVEL: {
                    hierarchy = ((ILevel)metadataObj).getHierarchy();
                    break;
                }
                case MEMBER: {
                    ILevel level = ((IMember)metadataObj).getLevel();
                    if (level == null) break;
                    hierarchy = level.getHierarchy();
                    break;
                }
                case DIMENSION: {
                    if (!((IDimension)metadataObj).isMeasuresDimension()) break;
                    hierarchy = ((IDimension)metadataObj).getDefaultHierarchy();
                    break;
                }
                case CALCULATION: {
                    if (!((ICalculation)metadataObj).getCalcType().equals("namedSet")) break;
                    hierarchy = ((INamedSet)metadataObj).getHierarchy();
                    break;
                }
                case QUERY_ITEM: {
                    if (metadataObj instanceof IProperty) {
                        hierarchy = ((IProperty)metadataObj).getHierarchy();
                        break;
                    }
                    if (!(metadataObj instanceof IQueryItemOfQuerySubject)) break;
                    hierarchy = ((IQueryItemOfQuerySubject)metadataObj).getHierarchy();
                    break;
                }
                case NAMED_SET: {
                    hierarchy = ((INamedSet)metadataObj).getHierarchy();
                    break;
                }
            }
        }
        return hierarchy;
    }

    @Override
    public IDataType getDataType() {
        return this.getMetadata().getDataType();
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201116) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201116;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public boolean isMeasure() {
        IMetadata mdObject = this.getMetadata();
        if (mdObject != null && mdObject.getObjectType() == MetadataType.MEMBER) {
            return ((IMember)mdObject).isMeasure();
        }
        return false;
    }

    public boolean isQueryItem() {
        IMetadata md = this.getMetadata();
        if (null != md) {
            return md.getObjectType() == MetadataType.QUERY_ITEM;
        }
        return false;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        IHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null) {
            hierInfo.appendProjectedHierarchy(hierarchy);
        }
        return hierInfo;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        IXQEQueryNode expression;
        boolean status = false;
        if (this.getType() == node.getType()) {
            V5BoundModelIdentifier other = (V5BoundModelIdentifier)node;
            IMetadata mdThis = this.getMetadata();
            IMetadata mdOther = other.getMetadata();
            if (mdThis != null && mdOther != null) {
                if (mdThis == mdOther) {
                    return true;
                }
                String idThis = this.getIdentifier();
                String idOther = other.getIdentifier();
                if (idThis != null && idOther != null && idThis.equals(idOther)) {
                    return mdThis.equals(mdOther);
                }
            }
        } else if (node.getType() == 801009) {
            RQPDataItem target = ((RQPDataItemRef)node).getReferencedItem();
            if (target != null) {
                return this.isSameExpression(target, compareCalcDefiniton);
            }
        } else if (node.getType() == 801008 && (expression = ((RQPDataItem)node).getExpression()) != null) {
            return this.isSameExpression(expression, compareCalcDefiniton);
        }
        return status;
    }

    public IQuerySubject getQuerySubject() {
        IMetadata metadataObj = this.getMetadata();
        if (null == metadataObj) {
            return null;
        }
        return V5BoundModelIdentifier.getQuerySubject(metadataObj);
    }

    public static IQuerySubject getQuerySubject(IMetadata metadataObj) {
        if (metadataObj.getObjectType() == MetadataType.QUERY_ITEM) {
            IQueryItem qi = (IQueryItem)metadataObj;
            return qi.getQuerySubject();
        }
        if (metadataObj instanceof IMeasure) {
            IMeasure measure = (IMeasure)metadataObj;
            return measure.getQuerySubject();
        }
        return null;
    }

    public boolean isCalculation() {
        IMetadata mdObj = this.getMetadata();
        if (null == mdObj) {
            return false;
        }
        return mdObj.getObjectType() == MetadataType.CALCULATION;
    }

    public boolean isQueryItemWithDefinedRegularAggregate() {
        IQueryItem queryItem;
        return this.isQueryItem() && V5AggregateEnum.isDefinedRegularAggregate((queryItem = (IQueryItem)this.getMetadata()).getRegularAggregate());
    }

    public boolean isFactQueryItemWithStandardRegularAggregate() {
        IQueryItem queryItem;
        return this.isQueryItem() && (queryItem = (IQueryItem)this.getMetadata()).isFact() && V5AggregateEnum.isStandardAggregate(queryItem.getRegularAggregate());
    }

    public boolean isFactQueryItemWithAutomaticOrCalculatedRegularAggregate() {
        IQueryItem queryItem;
        return this.isQueryItem() && (queryItem = (IQueryItem)this.getMetadata()).isFact() && (queryItem.getRegularAggregate() == "automatic" || queryItem.getRegularAggregate() == "calculated");
    }

    public boolean isFactQueryItemUsingAggregateUDF(PlanningEnvironment env) {
        if (!this.isQueryItem()) {
            return false;
        }
        IQueryItem queryItem = (IQueryItem)this.getMetadata();
        if (!queryItem.isFact()) {
            return false;
        }
        if (queryItem.getRegularAggregate() != "calculated") {
            return false;
        }
        IXQEQueryNode exp = this.getV5ValueExpression(env);
        if (exp == null) {
            return false;
        }
        return V5BoundModelIdentifier.hasUdfAggregate(exp);
    }

    public static boolean hasUdfAggregate(IXQEQueryNode exp) {
        IXQEQueryNode[] aggs;
        for (IXQEQueryNode agg : aggs = ExpressionAnalyzer.getSummaryFunctions(exp)) {
            V5ValueSummaryFunction sf = (V5ValueSummaryFunction)agg;
            if (sf.getSubType() != 43) continue;
            return true;
        }
        return false;
    }

    public boolean isCalculationWithDefinedRegularAggregate() {
        ICalculation calculation;
        return this.isCalculation() && V5AggregateEnum.isDefinedRegularAggregate((calculation = (ICalculation)this.getMetadata()).getRegularAggregate());
    }

    public boolean isFactQueryItem() {
        if (this.isQueryItem()) {
            IQueryItem queryItem = (IQueryItem)this.getMetadata();
            return queryItem.isFact();
        }
        return false;
    }

    public String getRegularAggregate() {
        if (this.isQueryItem()) {
            IQueryItem queryItem = (IQueryItem)this.getMetadata();
            return queryItem.getRegularAggregate();
        }
        if (this.isCalculation()) {
            ICalculation calculation = (ICalculation)this.getMetadata();
            return calculation.getRegularAggregate();
        }
        if (this.isMeasure()) {
            IMeasure measure = (IMeasure)this.getMetadata();
            return measure.getRegularAggregate().getModelName();
        }
        return null;
    }

    @Override
    public String getColumnName() {
        if (this.isQueryItem()) {
            IQueryItem queryItem = (IQueryItem)this.getMetadata();
            String columnName = queryItem.getUniqueName();
            if (columnName == null) {
                columnName = queryItem.getCaption();
            }
            return columnName;
        }
        return super.getColumnName();
    }

    @Override
    public String getNativeName() {
        return this.getIdentifier();
    }

    public String convertRegularAggregateSumToTotal() {
        String regularAggregate = this.getRegularAggregate();
        if (regularAggregate.equals("sum")) {
            regularAggregate = "total";
        }
        return regularAggregate;
    }

    public String getExpression() {
        return this.getExpression(this.getMetadata());
    }

    public String getExpression(IMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        switch (metadata.getObjectType()) {
            case QUERY_ITEM: {
                return ((IQueryItem)metadata).getExpression();
            }
            case CALCULATION: {
                return ((ICalculation)metadata).getExpression();
            }
            case EMBEDDED_FILTER: {
                return ((IEmbeddedFilter)metadata).getExpression();
            }
            case FILTER: {
                return ((IFilter)metadata).getExpression();
            }
            case SHORTCUT: {
                return this.getExpression(((IShortcut)metadata).getTarget());
            }
            case MEMBER: {
                if (metadata instanceof IMeasure) {
                    return ((IMeasure)metadata).getExpression();
                }
                return null;
            }
        }
        return null;
    }

    public IXQEQueryNode getV5ValueExpression(PlanningEnvironment environment) {
        return RQPUtilities.getV5ValueExpression(this.getMetadata(), environment);
    }

    public boolean isUnwound() {
        Boolean isUnwound = (Boolean)this.getPropertyValue(PROP_IS_UNWOUND);
        return isUnwound != null && isUnwound != false;
    }

    public void setIsUnwound() {
        this.setPropertyValue(PROP_IS_UNWOUND, Boolean.TRUE);
    }

    public boolean isValid() {
        return this.getBooleanPropertyValue(PROP_IS_VALID) == Boolean.TRUE;
    }

    public void setIsValid() {
        this.setPropertyValue(PROP_IS_VALID, Boolean.TRUE);
    }

    @Override
    public MDXLevelInfo getHierarchyLevelInfo(MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        IMetadata metadataObj;
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        if (this.getHierarchy().equals(forHierarchy.getHierarchyInfo().getProjectedHierarchy(0)) && (metadataObj = this.getMetadata()) != null) {
            switch (metadataObj.getObjectType()) {
                case HIERARCHY: {
                    levelInfo.addProjectedHierarchy(this.getHierarchy());
                    break;
                }
                case LEVEL: {
                    levelInfo.addProjectedHierarchy((ILevel)metadataObj);
                    break;
                }
                case MEMBER: {
                    levelInfo.addProjectedHierarchy(((IMember)metadataObj).getLevel());
                    break;
                }
                case DIMENSION: {
                    levelInfo.addProjectedHierarchyNoLevels(this.getHierarchy());
                    break;
                }
                case CALCULATION: {
                    if (((ICalculation)metadataObj).getCalcType().equals("namedSet")) {
                        levelInfo.addProjectedLevels(((INamedSet)metadataObj).getLevels());
                        break;
                    }
                    levelInfo.addProjectedHierarchyNoLevels(this.getHierarchy());
                    break;
                }
                case QUERY_ITEM: {
                    if (metadataObj instanceof IQueryItemOfLevel) {
                        levelInfo.addProjectedHierarchy(((IProperty)metadataObj).getLevel());
                        break;
                    }
                    levelInfo.addProjectedHierarchyNoLevels(this.getHierarchy());
                    break;
                }
                case NAMED_SET: {
                    if (metadataObj instanceof INamedSet) {
                        levelInfo.addProjectedLevels(((INamedSet)metadataObj).getLevels());
                        break;
                    }
                    levelInfo.addProjectedHierarchy(this.getHierarchy());
                    break;
                }
                default: {
                    levelInfo.addProjectedHierarchyNoLevels(this.getHierarchy());
                }
            }
        }
        return levelInfo;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.setPropertyValue("identifier", identifier);
    }

    @Override
    public String getIdentifier() {
        String identifier = (String)this.getPropertyValue("identifier");
        if (identifier == null) {
            IMetadata metadata = this.getMetadata();
            if (null == metadata) {
                return null;
            }
            identifier = metadata.getV5UniqueName();
        }
        return identifier;
    }

    public boolean isMeasureWithStandardRegularAggregate() {
        if (this.isMeasure()) {
            IMeasure measure = (IMeasure)this.getMetadata();
            String regAggreagate = "";
            if (measure instanceof MeasureWrapper) {
                regAggreagate = ((MeasureWrapper)measure).getRegularAggregateV5Type();
            }
            if (V5AggregateEnum.isStandardAggregate(regAggreagate)) {
                return true;
            }
        }
        return false;
    }

    public boolean isMeasureAutomaticOrCalculatedRegularAggregate() {
        if (this.isMeasure()) {
            IMeasure measure = (IMeasure)this.getMetadata();
            String regularAggregate = "";
            if (measure instanceof MeasureWrapper) {
                regularAggregate = ((MeasureWrapper)measure).getRegularAggregateV5Type();
            }
            if (regularAggregate.equals("automatic") || regularAggregate.equals("calculated")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLiteral() {
        IMetadata metaData = this.getMetadata();
        if (metaData.getObjectType() == MetadataType.QUERY_ITEM && ((IQueryItem)metaData).getUsage().equals("attribute")) {
            return true;
        }
        if (metaData.getObjectType() == MetadataType.QUERY_ITEM && ((IQueryItem)metaData).isFact()) {
            return true;
        }
        return metaData.getObjectType() == MetadataType.MEMBER && ((IMember)metaData).getDimension().isMeasuresDimension();
    }

    public boolean isExplicitProperty() {
        return this.getBooleanPropertyValue("isExplicitProperty", Boolean.FALSE);
    }

    @Override
    public boolean isNullable() {
        IMetadata metadataObj = this.getMetadata();
        if (metadataObj instanceof IQueryItem) {
            return ((IQueryItem)metadataObj).isNullable();
        }
        return true;
    }

    public static IQuerySubject getQuerySubject(PlanningEnvironment environment, String identifier) {
        V5NameBinding nameBinding = new V5NameBinding(environment);
        IMetadata metadata = nameBinding.bindModelIdentifier(identifier, true);
        return V5BoundModelIdentifier.getQuerySubject(metadata);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int i = 0;
        int size = inputNode.attributeCount();
        if (i < size) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        if (children.size() > 0) {
            Element child = (Element)children.get(0);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public void setResolvedQSName(String value) {
        this.setPropertyValue(PROP_RESOLVED_QS_NAME, value);
    }

    public String getResolvedQSName() {
        return (String)this.getPropertyValue(PROP_RESOLVED_QS_NAME);
    }

    public boolean isFactUsage() {
        if (this.isQueryItem()) {
            return this.isFactQueryItem();
        }
        if (this.isCalculation()) {
            ICalculation calculation = (ICalculation)this.getMetadata();
            return calculation.getUsage().equals("fact");
        }
        return this.isMeasure();
    }
}

