/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5CaptionFunction
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5CaptionFunction";
    private static final String CAPTION = "caption";

    public V5CaptionFunction() {
        this.setNativeName(CAPTION);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201050) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201050;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        return this.getFirstChildHierarchyInfo();
    }

    @Override
    public MDXLevelInfo getHierarchyLevelInfo(MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        return this.getChildByIndexHierarchyLevelInfo(0, forHierarchy, fncs);
    }

    @Override
    public IMetadata getMetadata() {
        IMetadata metadata = null;
        IXQEQueryNode v5BoundIdentifier = this.getFirstDescendantOfTypeOrdered(201116, false);
        if (null != v5BoundIdentifier) {
            metadata = ((V5BoundModelIdentifier)v5BoundIdentifier).getMetadata();
        } else {
            IXQEQueryNode boundDataitemRef = this.getChild(0);
            if (null != boundDataitemRef && boundDataitemRef.isOfCategory(201120)) {
                boundDataitemRef = V5SimpleNode.skipUnrelatedNodes(boundDataitemRef);
                metadata = ((V5SimpleNode)boundDataitemRef).getMetadata();
            }
        }
        return metadata;
    }

    @Override
    public boolean isOLAPConstruct() {
        return true;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5MultiPartIdentifier")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode[] children = this.getChildren();
        buffer.append(this.getNativeName());
        buffer.append("(");
        buffer.append(" ");
        children[0].writeFormattedText(buffer);
        buffer.append(" ");
        buffer.append(")");
    }
}

