/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import java.util.ArrayList;
import java.util.List;

public class V5CaseWhenClause
extends V5SimpleNode {
    public static final String NODE_TYPE_NAME = "V5CaseWhenClause";
    public static final String WHEN = "when";
    public static final String THEN = "then";
    public static final String SPACE = " ";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201019) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201019;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        IXQEQueryNode child = this.getChild(1);
        while (!child.isOfCategory(201120) && child.getNumberChildren() == 1) {
            child = child.getChild(0);
        }
        return V5SimpleNode.getNodeDataType(child);
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        List<IXQEQueryNode> otherSideNodes = this.getV5ParameterChildAtIndexForCaseExpr(index);
        for (IXQEQueryNode otherNode : otherSideNodes) {
            IDataType otherNodeDT;
            if (otherNode.getType() == 201024 || (otherNodeDT = ((V5SimpleNode)otherNode).getDataType()) == null) continue;
            return otherNodeDT;
        }
        return null;
    }

    private List<IXQEQueryNode> getV5ParameterChildAtIndexForCaseExpr(int index) {
        ArrayList<IXQEQueryNode> otherNodes = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode parentNode = this.getParent();
        int firstWhenThenIndex = 0;
        if (parentNode.getType() == 201018 && ((V5CaseExpression)parentNode).getSubType() == 0) {
            firstWhenThenIndex = 1;
        }
        int numberChildren = parentNode.getNumberChildren();
        if (index == 0) {
            if (firstWhenThenIndex == 1) {
                otherNodes.add(V5CaseWhenClause.skipUnrelatedNodes(parentNode.getChild(0)));
            }
            for (int i = firstWhenThenIndex; i < numberChildren; ++i) {
                IXQEQueryNode child = V5CaseWhenClause.skipUnrelatedNodes(parentNode.getChild(i));
                if (child == this || child.getType() != 201019) continue;
                otherNodes.add(V5CaseWhenClause.skipUnrelatedNodes(child.getChild(0)));
            }
        } else {
            for (int i = firstWhenThenIndex; i < numberChildren; ++i) {
                IXQEQueryNode child = V5CaseWhenClause.skipUnrelatedNodes(parentNode.getChild(i));
                if (child == this) continue;
                if (child.getType() == 201019) {
                    otherNodes.add(V5CaseWhenClause.skipUnrelatedNodes(child.getChild(1)));
                    continue;
                }
                otherNodes.add(child);
            }
        }
        return otherNodes;
    }

    @Override
    public boolean isLiteral() {
        IXQEQueryNode thenClause = V5CaseWhenClause.skipUnrelatedNodes(this.getChild(1));
        return ((V5SimpleNode)thenClause).isLiteral();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(SPACE);
        buffer.append(WHEN);
        buffer.append(SPACE);
        IXQEQueryNode[] children = this.getChildren();
        children[0].writeFormattedText(buffer);
        buffer.append(SPACE);
        buffer.append(THEN);
        buffer.append(SPACE);
        children[1].writeFormattedText(buffer);
    }
}

