/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.function.conditional.Coalesce;
import com.cognos.xqe.transformation.decomposition.ValidateV5Expression;
import java.util.ArrayList;

public class V5CoalesceFunction
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5CoalesceFunction";
    private static final String VALUE = "value";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201055) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201055;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return Coalesce.getOutputType(this.getChildDataTypes());
    }

    @Override
    public String getName() {
        return "coalesce";
    }

    @Override
    public ValidateV5Expression.ErrorCode validateExpression(ArrayList<String> parts) {
        IXQEQueryNode[] arguments;
        DataSubType dataSubType = null;
        V5ExpressionTypeEnum expressionType = null;
        for (IXQEQueryNode argument : arguments = this.getChildren()) {
            if (argument instanceof V5SimpleNode) {
                IDataType dataType = ((V5SimpleNode)argument).getDataType();
                expressionType = V5ExpressionCheck.getExpressionType(argument);
                if (dataType != null) {
                    dataSubType = dataType.getSubType();
                }
            }
            if (dataSubType != DataSubType.METADATATYPE) continue;
            V5DataItem v5DataItem = (V5DataItem)this.getAncestorOfType(101003);
            parts.add(String.valueOf(argument.getParent().getPositionOfChild(argument) + 1));
            parts.add(this.getNativeName());
            parts.add(v5DataItem.getNameProperty());
            if (expressionType != V5ExpressionTypeEnum.UNKNOWN) {
                parts.add(expressionType.getExpressionTypeName());
            }
            parts.add(VALUE);
            return ValidateV5Expression.ErrorCode.InvalidCoercion;
        }
        return ValidateV5Expression.ErrorCode.OK;
    }

    @Override
    public boolean isNullable() {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = this.getChildren()) {
            V5SimpleNode aSimpleNode;
            if (!child.isOfCategory(201120) || (aSimpleNode = (V5SimpleNode)child).isNullable()) continue;
            return false;
        }
        return true;
    }
}

