/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.BooleanFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.v5.AugmentV5SQLQueryItemReferenceWithDataType;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5ComparisonExpression
extends AbstractV5BooleanExpression {
    public static final String NODE_TYPE_NAME = "V5ComparisonExpression";
    public static final int SUBTYPE_LESS = 0;
    public static final int SUBTYPE_LESSEQUAL = 1;
    public static final int SUBTYPE_EQUAL = 2;
    public static final int SUBTYPE_NOTEQUAL = 3;
    public static final int SUBTYPE_GREATEREQUAL = 4;
    public static final int SUBTYPE_GREATER = 5;
    public static final String PROP_INTEGER_COMPARE = "compare";
    public static final int COMPARE_UNSPECIFIED = 0;
    public static final int COMPARE_ALL = 1;
    public static final int COMPARE_ANY = 2;
    public static final String PROP_BOOLEAN_USE_QUERY_REUSE = "useQueryReuse";
    public static final String PROP_MASTERDETAIL_LINK_NAME = "masterDetailLinkName";
    private static final int[] SUBTYPE_INVERSE = new int[]{4, 5, 3, 2, 0, 1};
    public static final int[] USE_VALUE_EXPRESSION_TYPES = new int[]{201116, 201117};

    public void setOption(int option) {
        this.setPropertyValue(PROP_INTEGER_COMPARE, XQEIntegerPool.getInteger(option));
    }

    public int getOption() {
        Integer integer = (Integer)this.getPropertyValue(PROP_INTEGER_COMPARE);
        if (integer != null) {
            return integer;
        }
        return 0;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201013) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201013;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return BooleanFunction.getOutputType(this.getChildDataTypes());
    }

    public void invertSubType() {
        this.setSubType(SUBTYPE_INVERSE[this.getSubType()]);
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        SQLQueryItem sqlQueryItem;
        IDataType expectedDataType = null;
        IXQEQueryNode lhs = this.getV5ParameterChildAtIndex(index);
        if (lhs.getType() == 801009) {
            RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
            lhs = proj.getExpression();
        }
        if (lhs.getType() == 201103 && (sqlQueryItem = AugmentV5SQLQueryItemReferenceWithDataType.findSQLQueryItem((V5BoundSQLQueryItemReference)lhs)) != null) {
            expectedDataType = sqlQueryItem.getDataType();
            return expectedDataType;
        }
        if (lhs.getType() == 201024 && lhs.getPropertyValue("datatype") == null) {
            return null;
        }
        expectedDataType = ((V5SimpleNode)lhs).getDataType();
        return expectedDataType;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length != 2) {
            super.writeFormattedText(buffer);
            return;
        }
        children[0].writeFormattedText(buffer);
        switch (this.getSubType()) {
            case 0: {
                buffer.append(" < ");
                break;
            }
            case 1: {
                buffer.append(" <= ");
                break;
            }
            case 2: {
                buffer.append(" = ");
                break;
            }
            case 3: {
                buffer.append(" <> ");
                break;
            }
            case 4: {
                buffer.append(" >= ");
                break;
            }
            case 5: {
                buffer.append(" > ");
                break;
            }
            default: {
                super.writeFormattedText(buffer);
                return;
            }
        }
        switch (this.getOption()) {
            case 0: {
                break;
            }
            case 1: {
                buffer.append("ALL ");
                break;
            }
            case 2: {
                buffer.append("ANY ");
                break;
            }
            default: {
                super.writeFormattedText(buffer);
                return;
            }
        }
        children[1].writeFormattedText(buffer);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("subtype")) {
                this.setSubType(Integer.parseInt(att.getValue()));
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            V5QueryNode node;
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5MultiPartIdentifier") || childname.equals("V5LiteralValue") || childname.equals("V5DataItemReference")) {
                node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals("V5Expression")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

