/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5ContainsExpression
extends AbstractV5BooleanExpression {
    public static final String NODE_TYPE_NAME = "V5ContainsExpression";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201005) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201005;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return BooleanType.BOOLEANTYPE;
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        IDataType expectedDataType = null;
        IXQEQueryNode lhs = this.getV5ParameterChildAtIndex(index);
        if (lhs.getType() == 801009) {
            RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
            lhs = proj.getExpression();
        }
        if (lhs.getType() == 201024 && lhs.getPropertyValue("datatype") == null) {
            return null;
        }
        expectedDataType = lhs.getType() == 201143 ? ((V5SimpleNode)lhs).getDataType() : VarcharType.DEFAULTVARCHARTYPE;
        return expectedDataType;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length != 2) {
            super.writeFormattedText(buffer);
            return;
        }
        children[0].writeFormattedText(buffer);
        buffer.append(" contains ");
        children[1].writeFormattedText(buffer);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5StringFunction")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

