/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5InExpression
extends AbstractV5BooleanExpression {
    public static final String NODE_TYPE_NAME = "V5InExpression";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201011) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201011;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return BooleanType.BOOLEANTYPE;
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        IDataType expectedDataType = null;
        IXQEQueryNode lhs = this.getV5ParameterChildAtIndex(index);
        if (lhs.getType() == 801009) {
            RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
            lhs = proj.getExpression();
        }
        if (lhs.getType() == 201024 && lhs.getPropertyValue("datatype") == null) {
            return null;
        }
        expectedDataType = ((V5SimpleNode)lhs).getDataType();
        return expectedDataType;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        String in = " in (";
        IXQEQueryNode[] children = this.getChildren();
        if (children.length == 0) {
            buffer.append(in);
            return;
        }
        children[0].writeFormattedText(buffer);
        buffer.append(in);
        if (children.length == 1) {
            return;
        }
        for (int i = 1; i < children.length; ++i) {
            ((V5QueryNode)children[i]).writeFormattedText(buffer);
            buffer.append("; ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        buffer.append(")");
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpNodeLineage(trace);
        this.dumpProperties(trace);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        int numberChildren = this.getNumberChildren();
        if (includeRuntimeSpecifics) {
            for (int i = 0; i < numberChildren; ++i) {
                this.getChild(i).dump(trace, includeRuntimeSpecifics);
            }
        } else if (numberChildren > 0) {
            this.getChild(0).dump(trace, includeRuntimeSpecifics);
            ArrayList<V5SimpleNode> rhsChildren = new ArrayList<V5SimpleNode>();
            for (int i = 1; i < numberChildren; ++i) {
                if (this.getChild(i) instanceof V5SimpleNode) {
                    rhsChildren.add((V5SimpleNode)this.getChild(i));
                    continue;
                }
                this.getChild(i).dump(trace, includeRuntimeSpecifics);
            }
            ChildCompare comparator = new ChildCompare();
            Collections.sort(rhsChildren, comparator);
            for (V5SimpleNode childNode : rhsChildren) {
                childNode.dump(trace, includeRuntimeSpecifics);
            }
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5LiteralValue") || childname.equals("V5MultiPartIdentifier") || childname.equals("V5MemberUniqueName") || childname.equals("V5BoundMemberUniqueName") || childname.equals("V5BoundModelIdentifier") || childname.equals("V5DataItemReference")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    private class ChildCompare
    implements Comparator<V5SimpleNode> {
        private ChildCompare() {
        }

        @Override
        public int compare(V5SimpleNode arg0, V5SimpleNode arg1) {
            Value arg1Value;
            if (arg0.getType() != arg1.getType()) {
                return -1;
            }
            if (arg0.getType() != 201026) {
                return 0;
            }
            Value arg0Value = ((V5LiteralValue)arg0).getValue();
            if (arg0Value == (arg1Value = ((V5LiteralValue)arg1).getValue())) {
                return 0;
            }
            if (arg0Value == null) {
                return -1;
            }
            if (arg1Value == null) {
                return 1;
            }
            return arg0Value.compareTo(arg1Value);
        }
    }
}

