/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.IDataType;

public class V5InRangeExpression
extends AbstractV5BooleanExpression {
    private static final String IN_RANGE = "in_range";
    public static final String NODE_TYPE_NAME = "V5InRangeExpression";

    public V5InRangeExpression() {
        this.setNativeName(IN_RANGE);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201012) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201012;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return BooleanType.BOOLEANTYPE;
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        IDataType expectedDataType = null;
        IXQEQueryNode lhs = this.getV5ParameterChildAtIndex(index);
        if (lhs.getType() == 801009) {
            RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
            lhs = proj.getExpression();
        }
        if (lhs.getType() == 201024 && lhs.getPropertyValue("datatype") == null) {
            return null;
        }
        expectedDataType = ((V5SimpleNode)lhs).getDataType();
        return expectedDataType;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length > 0 && children[0] != null) {
            children[0].writeFormattedText(buffer);
        } else {
            buffer.append(children[0]);
        }
        buffer.append(" ");
        buffer.append(this.getNativeName());
        buffer.append(" ");
        buffer.append("{");
        if (children.length > 1 && children[1] != null) {
            children[1].writeFormattedText(buffer);
        } else {
            buffer.append(children[1]);
        }
        if (children.length > 2) {
            buffer.append(" ");
            buffer.append(':');
            buffer.append(" ");
            if (children[2] != null) {
                children[2].writeFormattedText(buffer);
            } else {
                buffer.append(children[1]);
            }
        }
        buffer.append("}");
    }
}

