/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5MultiPartIdentifier
extends V5SimpleNode {
    public static final String NODE_TYPE_NAME = "V5MultiPartIdentifier";
    public static final String PROP_STRING_IDENTIFIER = "identifier";
    public static final String PROP_STRINGARRAY_NAMEPARTS = "nameParts";
    private static final String PROP_ATTEMPTED_BIND_TO_V5ITEM = "attemptedBindToV5Item";
    private static final String PROP_CREATED_FROM_QUERYITEM_OF_QUERYSUBJECT = "createdFromQueryItemOfQuerySubject";
    public static final String PROP_DMR_LEVEL_METADATA = "dmrLevelMetadata";
    public static final String PROP_TO_V5ITEM = "ToV5Item";
    public static final String PROP_BOOLEAN_BIND_TO_MODEL_FAILED = "BindToModelFailed";

    public void setIdentifier(String identifier) {
        this.setPropertyValue(PROP_STRING_IDENTIFIER, identifier);
        this.setNativeName(identifier);
    }

    public String getIdentifier() {
        return (String)this.getPropertyValue(PROP_STRING_IDENTIFIER);
    }

    @Override
    public int getType() {
        return 201030;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public void setNameParts(String[] nameParts) {
        this.setPropertyValue(PROP_STRINGARRAY_NAMEPARTS, nameParts);
    }

    public String[] getNameParts() {
        String[] parts = (String[])this.getPropertyValue(PROP_STRINGARRAY_NAMEPARTS);
        if (parts == null) {
            parts = this.parseNameParts(this.getIdentifier());
            this.setPropertyValue(PROP_STRINGARRAY_NAMEPARTS, parts);
        }
        return (String[])parts.clone();
    }

    private String[] parseNameParts(String identifier) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse(identifier, -1);
        }
        catch (UniqueNameParserException e) {
            parts = new String[]{identifier};
        }
        return parts;
    }

    public boolean attemptedBindToV5Item() {
        return this.getBooleanPropertyValue(PROP_ATTEMPTED_BIND_TO_V5ITEM) == Boolean.TRUE;
    }

    public void setAttemptedBindToV5Item() {
        this.setPropertyValue(PROP_ATTEMPTED_BIND_TO_V5ITEM, Boolean.TRUE);
    }

    public boolean createdFromQueryItemOfQuerySubject() {
        return this.getBooleanPropertyValue(PROP_CREATED_FROM_QUERYITEM_OF_QUERYSUBJECT) == Boolean.TRUE;
    }

    public void setCreatedFromQueryItemOfQuerySubject() {
        this.setPropertyValue(PROP_CREATED_FROM_QUERYITEM_OF_QUERYSUBJECT, Boolean.TRUE);
    }

    public boolean hasBindToModelFailed() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_BIND_TO_MODEL_FAILED) == Boolean.TRUE;
    }

    public void setBindToModelFailed() {
        this.setPropertyValue(PROP_BOOLEAN_BIND_TO_MODEL_FAILED, Boolean.TRUE);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        boolean status = false;
        if (this.getType() == node.getType() && this.getIdentifier() != null && ((V5MultiPartIdentifier)node).getIdentifier() != null && this.getIdentifier().equals(((V5MultiPartIdentifier)node).getIdentifier())) {
            return true;
        }
        return status;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_IDENTIFIER)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals("nativeName")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_DMR_LEVEL_METADATA)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        if (children.size() > 0) {
            Element child = (Element)children.get(0);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

