/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public class V5OrderedValueExpression
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5OrderedValueExpression";
    public static final int SUBTYPE_ORDER_UNSPECIFIED = 0;
    public static final int SUBTYPE_ORDER_ASC = 1;
    public static final int SUBTYPE_ORDER_DESC = 2;
    public static final String PROP_INTEGER_NULLORDERING = "nullOrdering";
    public static final int NULLORDERING_UNSPECIFIED = 0;
    public static final int NULLORDERING_NULLSFIRST = 1;
    public static final int NULLORDERING_NULLSLAST = 2;

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201114) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201114;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public boolean isASCsort() {
        return this.getSubType() == 1;
    }

    public void setNullOrdering(int nullOrdering) {
        this.setPropertyValue(PROP_INTEGER_NULLORDERING, XQEIntegerPool.getInteger(nullOrdering));
    }

    public int getNullOrdering() {
        Integer integer = (Integer)this.getPropertyValue(PROP_INTEGER_NULLORDERING);
        if (integer != null) {
            return integer;
        }
        return 0;
    }

    @Override
    public boolean isOLAPConstruct() {
        return this.getParent().getType() == 201034 || super.isOLAPConstruct();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        this.getChild(0).writeFormattedText(buffer);
        buffer.append(' ');
        if (this.isASCsort()) {
            buffer.append("ASC");
        } else {
            buffer.append("DESC");
        }
        switch (this.getNullOrdering()) {
            case 1: {
                buffer.append(" NULL FIRST");
                break;
            }
            case 2: {
                buffer.append(" NULL LAST");
                break;
            }
            default: {
                return;
            }
        }
    }
}

