/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.character.CharLength;
import com.cognos.xqe.function.character.Index;
import com.cognos.xqe.function.character.Lower;
import com.cognos.xqe.function.character.OctetLength;
import com.cognos.xqe.function.character.Position;
import com.cognos.xqe.function.character.Reverse;
import com.cognos.xqe.function.character.Substring;
import com.cognos.xqe.function.character.SubstringR;
import com.cognos.xqe.function.regex.OccurrencesRegex;
import com.cognos.xqe.function.regex.PositionRegex;
import com.cognos.xqe.function.regex.SubstringRegex;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.decomposition.ValidateV5Expression;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5StringFunction
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5StringFunction";
    public static final int SUBTYPE_UPPER = 0;
    public static final int SUBTYPE_LOWER = 1;
    public static final int SUBTYPE_SUBSTRING = 2;
    public static final int SUBTYPE_POSITION = 3;
    public static final int SUBTYPE_INDEX = 4;
    public static final int SUBTYPE_CHAR_LENGTH = 5;
    public static final int SUBTYPE_OCTET_LENGTH = 6;
    public static final int SUBTYPE_REVERSE = 7;
    private static final String STRING = "string";
    public static final int SUBTYPE_SUBSTRINGR = 8;
    public static final int SUBTYPE_SUBSTRING_REGEX = 9;
    public static final int SUBTYPE_POSITION_REGEX = 10;
    public static final int SUBTYPE_OCCURRENCES_REGEX = 11;

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201041) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201041;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        IDataType[] oDataTypes = this.getChildDataTypes();
        switch (this.getSubType()) {
            case 5: {
                return CharLength.getOutputType(oDataTypes);
            }
            case 6: {
                return OctetLength.getOutputType(oDataTypes);
            }
            case 3: {
                return Position.getOutputType(oDataTypes);
            }
            case 4: {
                return Index.getOutputType(oDataTypes);
            }
            case 0: 
            case 1: {
                return Lower.getOutputType(oDataTypes);
            }
            case 2: {
                return Substring.getOutputType(oDataTypes);
            }
            case 8: {
                return SubstringR.getOutputType(oDataTypes);
            }
            case 7: {
                return Reverse.getOutputType(oDataTypes);
            }
            case 9: {
                return SubstringRegex.getOutputType(oDataTypes);
            }
            case 10: {
                return PositionRegex.getOutputType(oDataTypes);
            }
            case 11: {
                return OccurrencesRegex.getOutputType(oDataTypes);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        switch (this.getSubType()) {
            case 5: {
                return "CHAR_LENGTH";
            }
            case 6: {
                return "OCTET_LENGTH";
            }
            case 3: {
                return "POSITION";
            }
            case 4: {
                return "INDEX";
            }
            case 1: {
                return "LOWER";
            }
            case 0: {
                return "UPPER";
            }
            case 2: {
                return "SUBSTRING";
            }
            case 8: {
                return "SUBSTRINGR";
            }
            case 7: {
                return "REVERSE";
            }
        }
        return "";
    }

    public IDataType getParameterType(int index) {
        switch (this.getSubType()) {
            case 5: {
                return CharLength.getParameterType(index);
            }
            case 6: {
                return OctetLength.getParameterType(index);
            }
            case 3: {
                return Position.getParameterType(index);
            }
            case 4: {
                return Index.getParameterType(index);
            }
            case 0: 
            case 1: {
                return Lower.getParameterType(index);
            }
            case 2: {
                return Substring.getParameterType(index);
            }
            case 8: {
                return SubstringR.getParameterType(index);
            }
            case 7: {
                return Reverse.getParameterType(index);
            }
        }
        return null;
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        return this.getParameterType(index);
    }

    @Override
    public ValidateV5Expression.ErrorCode validateExpression(ArrayList<String> parts) {
        IDataType dataType;
        DataSubType dataSubType = null;
        IXQEQueryNode child = this.getChild(0);
        if (child instanceof V5SimpleNode && (dataType = ((V5SimpleNode)child).getDataType()) != null) {
            dataSubType = dataType.getSubType();
        }
        if (dataSubType == DataSubType.METADATATYPE) {
            int nodePosition = this.getParent().getPositionOfChild(this) + 1;
            parts.add(String.valueOf(nodePosition));
            parts.add(((V5SimpleNode)this).getNativeName());
            V5DataItem v5DataItem = (V5DataItem)this.getAncestorOfType(101003);
            if (v5DataItem != null) {
                parts.add(v5DataItem.getNameProperty());
            } else {
                parts.add("");
            }
            parts.add(STRING);
            return ValidateV5Expression.ErrorCode.InvalidFunctionParameter;
        }
        return ValidateV5Expression.ErrorCode.OK;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("subtype")) {
                this.setSubType(Integer.parseInt(att.getValue()));
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5CaptionFunction") || childname.equals("V5LiteralValue")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    @Override
    public String getNativeName() {
        if (super.getNativeName() != null) {
            return super.getNativeName();
        }
        String nativeName = "";
        switch (this.getSubType()) {
            case 0: {
                nativeName = "upper";
                break;
            }
            case 1: {
                nativeName = "lower";
                break;
            }
            case 2: {
                nativeName = "substring";
                break;
            }
            case 3: {
                nativeName = "position";
                break;
            }
            case 4: {
                nativeName = "index";
                break;
            }
            case 5: {
                nativeName = "char_length";
                break;
            }
            case 6: {
                nativeName = "octet_length";
                break;
            }
            case 7: {
                nativeName = "reverse";
                break;
            }
            case 8: {
                nativeName = "";
                break;
            }
            case 9: {
                nativeName = "substring_regex";
                break;
            }
            case 10: {
                nativeName = "position_regex";
                break;
            }
            case 11: {
                nativeName = "occurrences_regex";
                break;
            }
        }
        return nativeName;
    }
}

