/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.set.Avg;
import com.cognos.xqe.function.set.CountStar;
import com.cognos.xqe.function.set.Max;
import com.cognos.xqe.function.set.StdDevPop;
import com.cognos.xqe.function.set.StdDevSamp;
import com.cognos.xqe.function.set.Sum;
import com.cognos.xqe.function.set.VarPop;
import com.cognos.xqe.function.set.VarSamp;
import com.cognos.xqe.function.set.regression.Corr;
import com.cognos.xqe.function.set.regression.CovarPop;
import com.cognos.xqe.function.set.regression.CovarSamp;
import com.cognos.xqe.function.set.regression.RegrAvgX;
import com.cognos.xqe.function.set.regression.RegrAvgY;
import com.cognos.xqe.function.set.regression.RegrCount;
import com.cognos.xqe.function.set.regression.RegrIntercept;
import com.cognos.xqe.function.set.regression.RegrR2;
import com.cognos.xqe.function.set.regression.RegrSXX;
import com.cognos.xqe.function.set.regression.RegrSXY;
import com.cognos.xqe.function.set.regression.RegrSYY;
import com.cognos.xqe.function.set.regression.RegrSlope;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5ValueSummaryFunction
extends V5AggregateFunction {
    public static final String NODE_TYPE_NAME = "V5ValueSummaryFunction";
    public static final String CALCULATED = "calculated";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201031) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201031;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        IDataType[] oDataTypes = this.getChildDataTypes();
        switch (this.mSubtype) {
            case 1: {
                return Avg.getOutputType(oDataTypes);
            }
            case 2: 
            case 3: {
                return CountStar.getOutputType(oDataTypes);
            }
            case 4: 
            case 6: {
                return Max.getOutputType(oDataTypes);
            }
            case 9: {
                return Sum.getOutputType(oDataTypes);
            }
            case 7: {
                return StdDevSamp.getOutputType(oDataTypes);
            }
            case 8: {
                return StdDevPop.getOutputType(oDataTypes);
            }
            case 10: {
                return VarSamp.getOutputType(oDataTypes);
            }
            case 11: {
                return VarPop.getOutputType(oDataTypes);
            }
            case 42: {
                return VarSamp.getOutputType(oDataTypes);
            }
            case 29: {
                return Corr.getOutputType(oDataTypes);
            }
            case 30: {
                return CovarPop.getOutputType(oDataTypes);
            }
            case 31: {
                return CovarSamp.getOutputType(oDataTypes);
            }
            case 32: {
                return RegrAvgX.getOutputType(oDataTypes);
            }
            case 33: {
                return RegrAvgY.getOutputType(oDataTypes);
            }
            case 34: {
                return RegrCount.getOutputType(oDataTypes);
            }
            case 35: {
                return RegrIntercept.getOutputType(oDataTypes);
            }
            case 36: {
                return RegrR2.getOutputType(oDataTypes);
            }
            case 37: {
                return RegrSlope.getOutputType(oDataTypes);
            }
            case 38: {
                return RegrSXX.getOutputType(oDataTypes);
            }
            case 39: {
                return RegrSXY.getOutputType(oDataTypes);
            }
            case 40: {
                return RegrSYY.getOutputType(oDataTypes);
            }
        }
        return DoubleType.DOUBLETYPE;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getNativeName());
        buffer.append("(");
        if (this.getDistinct()) {
            buffer.append("distinct ");
        }
        IXQEQueryNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].writeFormattedText(buffer);
        }
        buffer.append(")");
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("distinct")) {
                this.setDistinct(new Boolean(att.getValue()));
                continue;
            }
            if (attname.equals("subtype")) {
                this.setSubType(Integer.parseInt(att.getValue()));
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5MultiPartIdentifier") || childname.equals("V5AggregateBreakClause") || childname.equals("V5DataItemReference") || childname.equals("V5BoundModelIdentifier")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

