/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberSetReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import java.util.HashSet;

public abstract class V5ExpressionCheck {
    private V5ExpressionCheck() {
    }

    public static V5ExpressionTypeEnum getExpressionType(IXQEQueryNode v5Expr) {
        V5ExpressionTypeEnum expressionType = V5ExpressionTypeEnum.UNKNOWN;
        IXQEQueryNode exprNode = v5Expr;
        while (exprNode.getType() == 101003 || exprNode.getType() == 101004) {
            exprNode = exprNode.getChild(0);
        }
        if (exprNode.isOfCategory(201121)) {
            expressionType = V5ExpressionTypeEnum.MEMBER;
        } else if (exprNode.isOfCategory(201122)) {
            expressionType = V5ExpressionTypeEnum.SET;
        } else if (exprNode.isOfCategory(201125)) {
            expressionType = V5ExpressionTypeEnum.VALUE;
        } else if (exprNode.isOfCategory(201123)) {
            expressionType = V5ExpressionTypeEnum.TUPLE;
        } else if (exprNode.isOfCategory(201126)) {
            expressionType = V5ExpressionTypeEnum.BOOLEAN;
        } else {
            switch (exprNode.getType()) {
                case 201028: 
                case 201117: 
                case 201118: {
                    expressionType = V5ExpressionTypeEnum.MEMBER;
                    break;
                }
                case 201015: 
                case 201097: 
                case 201103: {
                    expressionType = V5ExpressionTypeEnum.VALUE;
                    break;
                }
                case 201073: {
                    expressionType = V5ExpressionTypeEnum.HIERARCHY;
                    break;
                }
                case 201082: 
                case 201083: {
                    expressionType = V5ExpressionTypeEnum.LEVEL;
                    break;
                }
                case 201060: {
                    V5Query referencedQuery;
                    V5BoundDataItemReference ref = (V5BoundDataItemReference)exprNode;
                    V5DataItem dataItem = ((V5BoundDataItemReference)exprNode).getRefDataItem();
                    if (ref.isQueryRefItem() && (referencedQuery = (V5Query)ref.getAncestorOfType(101006)) != null && referencedQuery.isRelStyle()) {
                        return V5ExpressionTypeEnum.VALUE;
                    }
                    expressionType = V5ExpressionCheck.getExpressionType(dataItem);
                    break;
                }
                case 201138: {
                    V5DataItem dataItem = ((V5BoundMemberSetReference)exprNode).getFirstRefDataItemByName();
                    expressionType = V5ExpressionCheck.getExpressionType(dataItem);
                    break;
                }
                case 201116: {
                    IMetadata metaData = ((V5BoundModelIdentifier)exprNode).getMetadata();
                    expressionType = V5ExpressionCheck.getMetadataExpressionType(metaData);
                    break;
                }
                case 201127: {
                    V5BoundParameter boundParameter = (V5BoundParameter)exprNode;
                    if (boundParameter.isLiteral()) {
                        expressionType = V5ExpressionTypeEnum.VALUE;
                        break;
                    }
                    expressionType = V5ExpressionTypeEnum.MEMBER;
                    break;
                }
                case 201024: {
                    V5Parameter literalPrompt = (V5Parameter)exprNode;
                    if (literalPrompt.isLiteral()) {
                        expressionType = V5ExpressionTypeEnum.VALUE;
                        break;
                    }
                    expressionType = V5ExpressionTypeEnum.MEMBER;
                    break;
                }
                case 201019: {
                    IXQEQueryNode thenClause = V5SimpleNode.skipUnrelatedNodes(exprNode.getChild(1));
                    expressionType = V5ExpressionCheck.getExpressionType(thenClause);
                    break;
                }
                case 601024: {
                    RelationalOlapDecorationNode wrapNode = (RelationalOlapDecorationNode)exprNode;
                    expressionType = wrapNode.getExpressionType();
                    break;
                }
            }
        }
        return expressionType;
    }

    public static V5ExpressionTypeEnum getExpressionTypeLookingForProjectedValueExpression(IXQEQueryNode v5Expr) {
        V5ExpressionTypeEnum expressionType = V5ExpressionTypeEnum.UNKNOWN;
        IXQEQueryNode exprNode = v5Expr;
        while (exprNode.getType() == 101003 || exprNode.getType() == 101004) {
            exprNode = exprNode.getChild(0);
        }
        if (exprNode.isOfCategory(201121)) {
            if (exprNode.getType() == 201085) {
                expressionType = V5ExpressionTypeEnum.VALUE;
            } else if (exprNode.getType() == 201076) {
                expressionType = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode.getChild(0));
            }
            if (expressionType != V5ExpressionTypeEnum.VALUE) {
                expressionType = V5ExpressionTypeEnum.MEMBER;
            }
        } else if (exprNode.isOfCategory(201122)) {
            expressionType = V5ExpressionTypeEnum.SET;
            switch (exprNode.getType()) {
                case 201046: 
                case 201053: 
                case 201062: 
                case 201064: 
                case 201074: {
                    expressionType = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode.getChild(0));
                    break;
                }
                case 201054: 
                case 201079: 
                case 201090: 
                case 201095: {
                    if (exprNode.getNumberChildren() <= 1) break;
                    expressionType = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode.getChild(1));
                    break;
                }
                case 201093: 
                case 201134: {
                    break;
                }
                case 201101: {
                    for (int i = 0; i < exprNode.getNumberChildren() && (expressionType = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode.getChild(i))) != V5ExpressionTypeEnum.VALUE; ++i) {
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < exprNode.getNumberChildren() && (V5ExpressionCheck.getExpressionType(exprNode.getChild(i)) != V5ExpressionTypeEnum.SET || (expressionType = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode.getChild(i))) != V5ExpressionTypeEnum.VALUE); ++i) {
                    }
                }
            }
            if (expressionType != V5ExpressionTypeEnum.VALUE) {
                expressionType = V5ExpressionTypeEnum.SET;
            }
        } else if (exprNode.isOfCategory(201125)) {
            expressionType = V5ExpressionTypeEnum.VALUE;
        } else if (exprNode.isOfCategory(201123)) {
            for (int i = 0; i < exprNode.getNumberChildren() && (expressionType = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode.getChild(i))) != V5ExpressionTypeEnum.VALUE; ++i) {
            }
            if (expressionType != V5ExpressionTypeEnum.VALUE) {
                expressionType = V5ExpressionTypeEnum.TUPLE;
            }
        } else {
            switch (exprNode.getType()) {
                case 201117: 
                case 201118: {
                    expressionType = V5ExpressionTypeEnum.MEMBER;
                    break;
                }
                case 201015: 
                case 201097: 
                case 201103: {
                    expressionType = V5ExpressionTypeEnum.VALUE;
                    break;
                }
                case 201073: {
                    expressionType = V5ExpressionTypeEnum.HIERARCHY;
                    break;
                }
                case 201082: 
                case 201083: {
                    expressionType = V5ExpressionTypeEnum.LEVEL;
                    break;
                }
                case 201060: {
                    V5DataItem dataItem = ((V5BoundDataItemReference)exprNode).getRefDataItem();
                    expressionType = V5ExpressionCheck.getExpressionType(dataItem);
                    break;
                }
                case 201138: {
                    V5DataItem dataItem = ((V5BoundMemberSetReference)exprNode).getFirstRefDataItemByName();
                    expressionType = V5ExpressionCheck.getExpressionType(dataItem);
                    break;
                }
                case 201116: {
                    IMetadata metaData = ((V5BoundModelIdentifier)exprNode).getMetadata();
                    expressionType = V5ExpressionCheck.getMetadataExpressionType(metaData);
                    break;
                }
                case 201127: {
                    V5BoundParameter boundParameter = (V5BoundParameter)exprNode;
                    if (boundParameter.isLiteral()) {
                        expressionType = V5ExpressionTypeEnum.VALUE;
                        break;
                    }
                    expressionType = V5ExpressionTypeEnum.MEMBER;
                    break;
                }
                case 201024: {
                    V5Parameter literalPrompt = (V5Parameter)exprNode;
                    if (literalPrompt.isLiteral()) {
                        expressionType = V5ExpressionTypeEnum.VALUE;
                        break;
                    }
                    expressionType = V5ExpressionTypeEnum.MEMBER;
                    break;
                }
            }
        }
        return expressionType;
    }

    private static V5ExpressionTypeEnum getMetadataExpressionType(IMetadata metadata) {
        IQueryItem qItem;
        IMetadata metaData = metadata;
        V5ExpressionTypeEnum expressionType = V5ExpressionTypeEnum.UNKNOWN;
        int maxRecursionDepth = 33;
        int recursionDepth = 0;
        while (metaData.getObjectType() == MetadataType.SHORTCUT) {
            metaData = ((IShortcut)metaData).getTarget();
            if (recursionDepth > 33) {
                HashSet<String> setID = new HashSet<String>();
                StringBuilder sb = new StringBuilder();
                for (int rd = 0; rd <= 33; ++rd) {
                    metaData = ((IShortcut)metaData).getTarget();
                    if (rd > 0) {
                        sb.append("->");
                    }
                    sb.append(metadata.getID());
                    if (!setID.add(metadata.getID())) break;
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInModel, sb.toString());
            }
            ++recursionDepth;
        }
        if (metaData.getObjectType() == MetadataType.MEMBER || MetadataType.isMeasure(metaData)) {
            expressionType = V5ExpressionTypeEnum.MEMBER;
        } else if (metaData.getObjectType() == MetadataType.HIERARCHY || metaData.getObjectType() == MetadataType.DIMENSION && ((IDimension)metaData).isMeasuresDimension()) {
            expressionType = V5ExpressionTypeEnum.HIERARCHY;
        } else if (metaData.getObjectType() == MetadataType.LEVEL) {
            expressionType = V5ExpressionTypeEnum.LEVEL;
        } else if (metaData.getObjectType() == MetadataType.NAMED_SET) {
            expressionType = V5ExpressionTypeEnum.SET;
        } else if (MetadataType.isProperty(metaData)) {
            expressionType = V5ExpressionTypeEnum.VALUE;
        } else if (MetadataType.isCalculation(metaData)) {
            expressionType = ((ICalculation)metaData).getCalcType().equals("namedSet") ? V5ExpressionTypeEnum.SET : V5ExpressionTypeEnum.VALUE;
        } else if (MetadataType.isQueryItem(metaData) && ((qItem = (IQueryItem)metaData).isBusinessKey() || qItem.isFact() || qItem.isProperty())) {
            expressionType = V5ExpressionTypeEnum.VALUE;
        }
        return expressionType;
    }

    public static boolean isValueExpression(IXQEQueryNode v5Expr) {
        return V5ExpressionCheck.getExpressionType(v5Expr) == V5ExpressionTypeEnum.VALUE;
    }

    public static boolean isBooleanExpression(IXQEQueryNode v5Expr) {
        V5ExpressionTypeEnum expressionType = V5ExpressionCheck.getExpressionType(v5Expr);
        return expressionType == V5ExpressionTypeEnum.BOOLEAN;
    }

    public static boolean canBeCoercedToValueExpression(IXQEQueryNode v5Expr) {
        V5ExpressionTypeEnum expressionType = V5ExpressionCheck.getExpressionType(v5Expr);
        return expressionType == V5ExpressionTypeEnum.MEMBER || expressionType == V5ExpressionTypeEnum.TUPLE;
    }

    public static boolean isMemberExpression(IXQEQueryNode node) {
        return V5ExpressionCheck.getExpressionType(node) == V5ExpressionTypeEnum.MEMBER;
    }

    public static boolean isHierarchyExpression(IXQEQueryNode node) {
        return V5ExpressionCheck.getExpressionType(node) == V5ExpressionTypeEnum.HIERARCHY;
    }

    public static boolean isSetExpression(IXQEQueryNode node) {
        return V5ExpressionCheck.getExpressionType(node) == V5ExpressionTypeEnum.SET;
    }

    public static boolean canBeCoercedToSet(IXQEQueryNode node) {
        V5ExpressionTypeEnum expressionType = V5ExpressionCheck.getExpressionType(node);
        return expressionType == V5ExpressionTypeEnum.HIERARCHY || expressionType == V5ExpressionTypeEnum.LEVEL || expressionType == V5ExpressionTypeEnum.MEMBER || expressionType == V5ExpressionTypeEnum.TUPLE;
    }

    public static boolean isExplicitProperty(IXQEQueryNode node) {
        IMetadata metaData;
        MetadataType type;
        IXQEQueryNode exprNode = node;
        while (exprNode.getType() == 101003) {
            exprNode = exprNode.getChild(0);
        }
        return exprNode.getType() == 201116 && (type = (metaData = ((V5BoundModelIdentifier)exprNode).getMetadata()).getObjectType()) == MetadataType.QUERY_ITEM && ((IQueryItem)metaData).isProperty() && ((IQueryItem)metaData).getQuerySubject() == null;
    }

    public static boolean shouldBeCoercedToSet(IXQEQueryNode node) {
        IXQEQueryNode exprNode = node;
        while (exprNode.getType() == 101003) {
            exprNode = exprNode.getChild(0);
        }
        if (exprNode.isOfCategory(101064) && !((V5QueryNode)exprNode).isOLAPConstruct()) {
            return false;
        }
        V5Query query = (V5Query)exprNode.getAncestorOfType(101006);
        if (query != null && query.getV5Source().needQueryOverTabularStream()) {
            V5DetailFilter filter = (V5DetailFilter)exprNode.getAncestorOfType(101008);
            if (filter != null) {
                return filter.getPostAutoAggregation();
            }
            return false;
        }
        return true;
    }

    public static void throwInvalidCoercionException(IXQEQueryNode node, V5ExpressionTypeEnum coercionTargetType) {
        IXQEQueryNode exprNode = node.getParent();
        while (exprNode.getType() == 101003) {
            exprNode = exprNode.getParent();
        }
        int nodePosition = node.getParent().getPositionOfChild(node) + 1;
        V5DataItem v5DataItem = (V5DataItem)node.getAncestorOfType(101003);
        if (v5DataItem == null) {
            String contextName = null;
            if (node.getAncestorOfType(101008) != null) {
                contextName = "detailFilter";
            } else if (node.getAncestorOfType(101011) != null) {
                contextName = "summaryFilter";
            } else if (node.getAncestorOfType(101010) != null) {
                contextName = "slicer";
            }
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidCoercionNoDataItem, String.valueOf(nodePosition), (Object)((V5SimpleNode)exprNode).getNativeName(), (Object)contextName, (Object)coercionTargetType.getExpressionTypeName());
        }
        String dataItemName = v5DataItem.getNameProperty();
        V5ExpressionTypeEnum expressionType = V5ExpressionCheck.getExpressionType(node);
        XQEMessage message = null;
        message = expressionType != V5ExpressionTypeEnum.UNKNOWN ? new XQEMessage(XQEMessageKeys.PLN_InvalidCoercion, String.valueOf(nodePosition), ((V5SimpleNode)exprNode).getNativeName(), dataItemName, expressionType.getExpressionTypeName(), coercionTargetType.getExpressionTypeName(), node) : new XQEMessage(XQEMessageKeys.PLN_InvalidCoercionOnlyWithTargetType, String.valueOf(nodePosition), ((V5SimpleNode)exprNode).getNativeName(), dataItemName, coercionTargetType.getExpressionTypeName(), node);
        throw new XQEOlapUnsupportedQueryException(message);
    }

    public static boolean shouldBeCoercedToValue(IXQEQueryNode node) {
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query != null && query.isTabular() && query.isRelStyle()) {
            return false;
        }
        IXQEQueryNode exprNode = node;
        while (exprNode.getType() == 101003) {
            exprNode = exprNode.getChild(0);
        }
        if (exprNode.getType() == 201116) {
            IMetadata metaData = ((V5BoundModelIdentifier)exprNode).getMetadata();
            if (metaData.isDMR() && ((V5BoundModelIdentifier)exprNode).isDMRInQueryContext(metaData)) {
                MetadataType type = metaData.getObjectType();
                if (type == MetadataType.LEVEL || type == MetadataType.PROPERTY) {
                    return false;
                }
                if (query != null && query.getV5Source().needQueryOverTabularStream()) {
                    V5DetailFilter detailFilter = (V5DetailFilter)exprNode.getAncestorOfType(101008);
                    if (detailFilter != null) {
                        return detailFilter.getPostAutoAggregation();
                    }
                    if (exprNode.getAncestorOfType(201085) == null) {
                        return false;
                    }
                }
            }
            return MetadataType.isOLAP(metaData);
        }
        if (query != null && query.isTabular() && exprNode.getType() == 201060) {
            return false;
        }
        if (exprNode.isOfCategory(201126)) {
            IXQEQueryNode p;
            for (p = exprNode.getParent(); p != null && (p.getType() == 201017 || p.getType() == 201018 || p.getType() == 201019 || p.getType() == 201003); p = p.getParent()) {
            }
            if (p != null && p.getType() == 101008) {
                return false;
            }
        }
        return true;
    }

    public static FDSDataTypeEnum getFDSDataTypeForV5Expression(IXQEQueryNode v5Expr) {
        IXQEQueryNode exprNode = v5Expr;
        while (exprNode.getType() == 101003 || exprNode.getType() == 101004) {
            exprNode = exprNode.getChild(0);
        }
        if (exprNode.isOfCategory(201116)) {
            IMetadata metadata = ((V5BoundModelIdentifier)exprNode).getMetadata();
            if (metadata != null) {
                return V5NameBinding.getMetadataFDSDataType(metadata);
            }
        } else if (exprNode.isOfCategory(201103)) {
            return ((V5BoundSQLQueryItemReference)v5Expr).getFDSDataType();
        }
        FDSDataTypeEnum fdsDataType = null;
        V5ExpressionTypeEnum v5ExprType = V5ExpressionCheck.getExpressionType(exprNode);
        switch (v5ExprType) {
            case HIERARCHY: {
                fdsDataType = FDSDataTypeEnum.HIERARCHY;
                break;
            }
            case LEVEL: {
                fdsDataType = FDSDataTypeEnum.LEVEL;
                break;
            }
            case MEMBER: {
                fdsDataType = FDSDataTypeEnum.MEMBER;
                break;
            }
            case SET: {
                fdsDataType = FDSDataTypeEnum.MEMBERSET;
                break;
            }
            case TUPLE: {
                fdsDataType = FDSDataTypeEnum.TUPLE;
                break;
            }
            case VALUE: {
                IDataType v5DataType = ((V5SimpleNode)exprNode).getDataType();
                if (v5DataType == null) break;
                fdsDataType = V5NameBinding.v5DataTypeToFDS(v5DataType);
                break;
            }
        }
        return fdsDataType;
    }
}

