/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp.util;

import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.xml.XMLEscCharacter;

public class V5MunUtil {
    public static final String PROP_BOOLEAN_DMR_MUN = "isDMRMun";
    public static final String PROP_BOOLEAN_MUN_BINDING = "bound";

    public static boolean isDMRMun(V5MemberUniqueName v5Mun) {
        IMetadata meta = v5Mun.getMetadata();
        if (Boolean.TRUE.equals(v5Mun.getPropertyValue(PROP_BOOLEAN_DMR_MUN)) || meta != null && meta.isDMR()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void setPropertyDMRMUN(V5MemberUniqueName v5Mun, boolean isDMRMunUsed) {
        v5Mun.setPropertyValue(PROP_BOOLEAN_DMR_MUN, isDMRMunUsed);
    }

    public static boolean isMunBindingFailed(V5MemberUniqueName v5Mun) {
        if (Boolean.FALSE.equals(v5Mun.getPropertyValue(PROP_BOOLEAN_MUN_BINDING))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void setPropertyMUNBinding(V5MemberUniqueName v5Mun, boolean boundSucceed) {
        v5Mun.setPropertyValue(PROP_BOOLEAN_MUN_BINDING, boundSucceed);
    }

    public static String getExternalMemberUniqueName(V5MemberUniqueName v5Mun, boolean isForXML) {
        String physical = v5Mun.getPhysical();
        String logical = v5Mun.getLogical();
        if (logical != null && (physical == null || V5MunUtil.isDMRMun(v5Mun))) {
            return v5Mun.getLogical();
        }
        if (v5Mun.getProperties().containsKey("logical") && logical == null && physical == null) {
            return null;
        }
        try {
            String[] parts = UniqueNameParser.parse(physical);
            if (parts.length == 2 && parts[1].indexOf("[") == 0) {
                return parts[1];
            }
            if (parts.length > 1) {
                String[] newParts = new String[parts.length - 1];
                for (int i = 1; i < parts.length; ++i) {
                    newParts[i - 1] = isForXML ? XMLEscCharacter.escapeString(parts[i]) : parts[i];
                }
                return UniqueNameGenerator.createUniqueName(newParts);
            }
            if (parts.length == 1) {
                if (isForXML) {
                    return UniqueNameGenerator.createUniqueName(XMLEscCharacter.escapeString(parts[0]));
                }
                return UniqueNameGenerator.createUniqueName(parts[0]);
            }
        }
        catch (UniqueNameParserException e) {
            return null;
        }
        return null;
    }

    public static String getExternalMUNWithEscapedSquareBrackets(V5MemberUniqueName v5Mun, boolean isForXML) {
        String physical = v5Mun.getPhysical();
        String logical = v5Mun.getLogical();
        if (physical == null && logical != null) {
            physical = logical;
        }
        if (physical == null) {
            return null;
        }
        String[] parts = UniqueNameParser.parseNoThrow(physical);
        if (parts == null || parts.length == 0) {
            return null;
        }
        if (parts.length > 1) {
            String[] newParts = new String[parts.length - 1];
            for (int i = 1; i < parts.length; ++i) {
                newParts[i - 1] = isForXML ? XMLEscCharacter.escapeString(UniqueNameParser.escapeSquareBrackets(parts[i])) : UniqueNameParser.escapeSquareBrackets(parts[i]);
            }
            return UniqueNameGenerator.createUniqueName(newParts);
        }
        return UniqueNameGenerator.createUniqueName(XMLEscCharacter.escapeString(UniqueNameParser.escapeSquareBrackets(parts[0])));
    }
}

