/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp_new2.parser;

import com.cognos.xqe.ast.v5Exp_new2.parser.INameBinding;
import com.cognos.xqe.ast.v5Exp_new2.parser.Node;
import com.cognos.xqe.ast.v5Exp_new2.parser.SimpleNode;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParser;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParserVisitor;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;

public class ASTMultiPartIdentifier
extends SimpleNode {
    public static final String PROP_STRING_NAME_PARTS = "nameParts";
    public static final String PROP_STRING_STATUS = "status";
    public static final String PROP_FDS_DATATYPE = "fdsDataType";
    public static final String PROP_BOOLEAN_IS_MEASURE = "isMeasure";
    public static final String PROP_BOOLEAN_IS_EXPLICIT_PROPERTY = "isExplicitProperty";
    public static final String DOT = ".";

    public ASTMultiPartIdentifier(int id) {
        super(id);
        this.setStatus(IdentifierStatusEnum.UNBOUND);
        this.setNameParts(new String[0]);
    }

    public ASTMultiPartIdentifier(V5ExpressionParser p, int id) {
        super(p, id);
        this.setStatus(IdentifierStatusEnum.UNBOUND);
        this.setNameParts(new String[0]);
    }

    public ASTMultiPartIdentifier(String[] parts, String nativeName) {
        super(14);
        this.setStatus(IdentifierStatusEnum.UNBOUND);
        this.setNameParts(parts);
        this.setNativeName(nativeName);
    }

    public static Node jjtCreate(int id) {
        return new ASTMultiPartIdentifier(id);
    }

    public static Node jjtCreate(V5ExpressionParser p, int id) {
        return new ASTMultiPartIdentifier(p, id);
    }

    @Override
    public Object jjtAccept(V5ExpressionParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void completeNames() {
        StringBuilder theNativeName = new StringBuilder();
        boolean firstPart = true;
        String[] nameParts = this.getNameParts();
        for (int i = 0; i < nameParts.length; ++i) {
            String namePart = nameParts[i];
            if (firstPart) {
                firstPart = false;
            } else {
                theNativeName.append(DOT);
            }
            theNativeName.append(namePart);
            StringBuilder newNamePart = new StringBuilder();
            boolean skipped = false;
            if (namePart.charAt(0) == '[') {
                for (int j = 1; j < namePart.length() - 1; ++j) {
                    char ch = namePart.charAt(j);
                    if (ch == ']') {
                        if (skipped) {
                            skipped = false;
                        } else {
                            skipped = true;
                            continue;
                        }
                    }
                    newNamePart.append(ch);
                }
                nameParts[i] = newNamePart.toString();
                continue;
            }
            nameParts[i] = namePart;
        }
        super.setNativeName(theNativeName.toString());
    }

    public void setStatus(IdentifierStatusEnum value) {
        this.setPropertyValue(PROP_STRING_STATUS, value.getStatusName());
    }

    public IdentifierStatusEnum getStatus() {
        String statusName = (String)this.getPropertyValue(PROP_STRING_STATUS);
        return IdentifierStatusEnum.getStatusUsingName(statusName);
    }

    public void addNamePart(String namePart) {
        String[] oldNameParts = this.getNameParts();
        String[] newNameParts = new String[oldNameParts.length + 1];
        int idx = 0;
        String[] stringArray = oldNameParts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String oldNamePart;
            newNameParts[idx] = oldNamePart = stringArray[i];
            ++idx;
        }
        newNameParts[idx] = namePart;
        this.setNameParts(newNameParts);
    }

    public String[] getNameParts() {
        return (String[])this.getPropertyValue(PROP_STRING_NAME_PARTS);
    }

    public void setNameParts(String[] nameParts) {
        this.setPropertyValue(PROP_STRING_NAME_PARTS, nameParts);
    }

    @Override
    public void bindNames(INameBinding bindingImpl) {
        bindingImpl.bindMultiPartIdentifier(this);
    }

    @Override
    protected SimpleNode createNode() {
        return new ASTMultiPartIdentifier(this.id);
    }

    @Override
    public FDSDataTypeEnum getFDSDataType() {
        FDSDataTypeEnum dataType = (FDSDataTypeEnum)((Object)this.getPropertyValue(PROP_FDS_DATATYPE));
        return dataType;
    }

    public void setFDSDataType(FDSDataTypeEnum dataType) {
        this.setPropertyValue(PROP_FDS_DATATYPE, (Object)dataType);
    }

    public boolean isMeasure() {
        return this.getPropertyValue(PROP_BOOLEAN_IS_MEASURE) == Boolean.TRUE;
    }

    public void setIsMeasure() {
        this.setPropertyValue(PROP_BOOLEAN_IS_MEASURE, Boolean.TRUE);
    }

    public boolean isExplicitProperty() {
        return this.getPropertyValue(PROP_BOOLEAN_IS_EXPLICIT_PROPERTY) == Boolean.TRUE;
    }

    public void setIsExplicitProperty() {
        this.setPropertyValue(PROP_BOOLEAN_IS_EXPLICIT_PROPERTY, Boolean.TRUE);
    }

    public static enum IdentifierStatusEnum {
        UNBOUND("Unbound"),
        BOUND_DATA_ITEM("BoundDataItem"),
        BOUND_QUERY_ITEM("BoundQueryItem"),
        BOUND_SQL_QUERY_ITEM("BoundSQLQueryItem"),
        BOUND_MEMBER_SET("BoundMemberSet"),
        BOUND_MODEL_OBJECT("BoundModelObject"),
        BIND_FAILED("BindFailed");

        private String statusName;

        private IdentifierStatusEnum(String name) {
            this.statusName = name;
        }

        public String getStatusName() {
            return this.statusName;
        }

        public static IdentifierStatusEnum getStatusUsingName(String name) {
            if (name.equals(IdentifierStatusEnum.UNBOUND.statusName)) {
                return UNBOUND;
            }
            if (name.equals(IdentifierStatusEnum.BOUND_DATA_ITEM.statusName)) {
                return BOUND_DATA_ITEM;
            }
            if (name.equals(IdentifierStatusEnum.BOUND_QUERY_ITEM.statusName)) {
                return BOUND_QUERY_ITEM;
            }
            if (name.equals(IdentifierStatusEnum.BOUND_SQL_QUERY_ITEM.statusName)) {
                return BOUND_SQL_QUERY_ITEM;
            }
            if (name.equals(IdentifierStatusEnum.BOUND_MEMBER_SET.statusName)) {
                return BOUND_MEMBER_SET;
            }
            if (name.equals(IdentifierStatusEnum.BOUND_MODEL_OBJECT.statusName)) {
                return BOUND_MODEL_OBJECT;
            }
            if (name.equals(IdentifierStatusEnum.BIND_FAILED.statusName)) {
                return BIND_FAILED;
            }
            return null;
        }
    }
}

